/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.transform.decode;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.sysml.parser.Expression;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.matrix.data.FrameBlock;
import org.apache.sysml.runtime.transform.decode.Decoder;
import org.apache.sysml.runtime.transform.decode.DecoderComposite;
import org.apache.sysml.runtime.transform.decode.DecoderDummycode;
import org.apache.sysml.runtime.transform.decode.DecoderPassThrough;
import org.apache.sysml.runtime.transform.decode.DecoderRecode;
import org.apache.sysml.runtime.transform.meta.TfMetaUtils;
import org.apache.sysml.runtime.util.UtilFunctions;
import org.apache.wink.json4j.JSONObject;

public class DecoderFactory {
    public static Decoder createDecoder(String spec, String[] colnames, Expression.ValueType[] schema, FrameBlock meta) {
        return DecoderFactory.createDecoder(spec, colnames, schema, meta, meta.getNumColumns());
    }

    public static Decoder createDecoder(String spec, String[] colnames, Expression.ValueType[] schema, FrameBlock meta, int clen) {
        DecoderComposite decoder = null;
        try {
            JSONObject jSpec = new JSONObject(spec);
            ArrayList<Decoder> ldecoders = new ArrayList<Decoder>();
            List<Integer> rcIDs = Arrays.asList(ArrayUtils.toObject(TfMetaUtils.parseJsonIDList(jSpec, colnames, "recode")));
            List<Integer> dcIDs = Arrays.asList(ArrayUtils.toObject(TfMetaUtils.parseJsonIDList(jSpec, colnames, "dummycode")));
            rcIDs = new ArrayList<Integer>(CollectionUtils.union(rcIDs, dcIDs));
            int len = dcIDs.isEmpty() ? Math.min(meta.getNumColumns(), clen) : meta.getNumColumns();
            ArrayList ptIDs = new ArrayList(CollectionUtils.subtract(UtilFunctions.getSeqList(1, len, 1), rcIDs));
            if (schema == null) {
                schema = UtilFunctions.nCopies(len, Expression.ValueType.STRING);
                for (Integer col : ptIDs) {
                    schema[col.intValue() - 1] = Expression.ValueType.DOUBLE;
                }
            }
            if (!dcIDs.isEmpty()) {
                ldecoders.add(new DecoderDummycode(schema, ArrayUtils.toPrimitive(dcIDs.toArray(new Integer[0]))));
            }
            if (!rcIDs.isEmpty()) {
                ldecoders.add(new DecoderRecode(schema, !dcIDs.isEmpty(), ArrayUtils.toPrimitive(rcIDs.toArray(new Integer[0]))));
            }
            if (!ptIDs.isEmpty()) {
                ldecoders.add(new DecoderPassThrough(schema, ArrayUtils.toPrimitive(ptIDs.toArray(new Integer[0])), ArrayUtils.toPrimitive(dcIDs.toArray(new Integer[0]))));
            }
            decoder = new DecoderComposite(schema, ldecoders);
            decoder.setColnames(colnames);
            if (meta != null) {
                ((Decoder)decoder).initMetaData(meta);
            }
        }
        catch (Exception ex) {
            throw new DMLRuntimeException(ex);
        }
        return decoder;
    }
}

