/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hdfs.StorageType;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenIdentifier;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.hadoop.security.token.Token;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class LocatedBlock {
    private final ExtendedBlock b;
    private long offset;
    private final DatanodeInfo[] locs;
    private final String[] storageIDs;
    private final StorageType[] storageTypes;
    private boolean corrupt;
    private Token<BlockTokenIdentifier> blockToken = new Token();
    private DatanodeInfo[] cachedLocs;
    private static final DatanodeInfo[] EMPTY_LOCS = new DatanodeInfo[0];

    public LocatedBlock(ExtendedBlock b, DatanodeInfo[] locs) {
        this(b, locs, -1L, false);
    }

    public LocatedBlock(ExtendedBlock b, DatanodeInfo[] locs, long startOffset, boolean corrupt) {
        this(b, locs, null, null, startOffset, corrupt, EMPTY_LOCS);
    }

    public LocatedBlock(ExtendedBlock b, DatanodeStorageInfo[] storages) {
        this(b, storages, -1L, false);
    }

    public LocatedBlock(ExtendedBlock b, DatanodeInfo[] locs, String[] storageIDs, StorageType[] storageTypes) {
        this(b, locs, storageIDs, storageTypes, -1L, false, EMPTY_LOCS);
    }

    public LocatedBlock(ExtendedBlock b, DatanodeStorageInfo[] storages, long startOffset, boolean corrupt) {
        this(b, DatanodeStorageInfo.toDatanodeInfos(storages), DatanodeStorageInfo.toStorageIDs(storages), DatanodeStorageInfo.toStorageTypes(storages), startOffset, corrupt, EMPTY_LOCS);
    }

    public LocatedBlock(ExtendedBlock b, DatanodeInfo[] locs, String[] storageIDs, StorageType[] storageTypes, long startOffset, boolean corrupt, DatanodeInfo[] cachedLocs) {
        this.b = b;
        this.offset = startOffset;
        this.corrupt = corrupt;
        this.locs = locs == null ? EMPTY_LOCS : locs;
        this.storageIDs = storageIDs;
        this.storageTypes = storageTypes;
        this.cachedLocs = cachedLocs == null || cachedLocs.length == 0 ? EMPTY_LOCS : cachedLocs;
    }

    public Token<BlockTokenIdentifier> getBlockToken() {
        return this.blockToken;
    }

    public void setBlockToken(Token<BlockTokenIdentifier> token) {
        this.blockToken = token;
    }

    public ExtendedBlock getBlock() {
        return this.b;
    }

    public DatanodeInfo[] getLocations() {
        return this.locs;
    }

    public StorageType[] getStorageTypes() {
        return this.storageTypes;
    }

    public String[] getStorageIDs() {
        return this.storageIDs;
    }

    public long getStartOffset() {
        return this.offset;
    }

    public long getBlockSize() {
        return this.b.getNumBytes();
    }

    void setStartOffset(long value) {
        this.offset = value;
    }

    void setCorrupt(boolean corrupt) {
        this.corrupt = corrupt;
    }

    public boolean isCorrupt() {
        return this.corrupt;
    }

    public void addCachedLoc(DatanodeInfo loc) {
        ArrayList cachedList = Lists.newArrayList((Object[])this.cachedLocs);
        if (cachedList.contains(loc)) {
            return;
        }
        for (int i = 0; i < this.locs.length; ++i) {
            if (!this.locs[i].equals(loc)) continue;
            cachedList.add(this.locs[i]);
            this.cachedLocs = cachedList.toArray(this.cachedLocs);
            return;
        }
        cachedList.add(loc);
        this.cachedLocs = cachedList.toArray(this.cachedLocs);
    }

    public DatanodeInfo[] getCachedLocations() {
        return this.cachedLocs;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{" + this.b + "; getBlockSize()=" + this.getBlockSize() + "; corrupt=" + this.corrupt + "; offset=" + this.offset + "; locs=" + Arrays.asList(this.locs) + "; storageIDs=" + (this.storageIDs != null ? Arrays.asList(this.storageIDs) : null) + "; storageTypes=" + (this.storageTypes != null ? Arrays.asList(this.storageTypes) : null) + "}";
    }
}

