/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress;

import java.util.EnumSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.runtime.compress.cocode.CoCoderFactory;
import org.apache.sysds.runtime.compress.colgroup.AColGroup;
import org.apache.sysds.runtime.compress.cost.CostEstimatorFactory;
import org.apache.sysds.runtime.compress.estim.sample.SampleEstimatorFactory;

public class CompressionSettings {
    private static final Log LOG = LogFactory.getLog((String)CompressionSettings.class.getName());
    public static final int BITMAP_BLOCK_SZ = 65535;
    public final boolean sortValuesByLength;
    public final double samplingRatio;
    public final boolean allowSharedDictionary;
    public final String transposeInput;
    public final int seed;
    public final boolean lossy;
    public final CoCoderFactory.PartitionerType columnPartitioner;
    public final CostEstimatorFactory.CostType costComputationType;
    public final int maxColGroupCoCode;
    public final double coCodePercentage;
    public final EnumSet<AColGroup.CompressionType> validCompressions;
    public final int minimumSampleSize;
    public final int maxSampleSize;
    public final SampleEstimatorFactory.EstimationType estimationType;
    public boolean transposed = false;
    public final double minimumCompressionRatio;
    public final boolean isInSparkInstruction;

    protected CompressionSettings(double samplingRatio, boolean allowSharedDictionary, String transposeInput, int seed, boolean lossy, EnumSet<AColGroup.CompressionType> validCompressions, boolean sortValuesByLength, CoCoderFactory.PartitionerType columnPartitioner, int maxColGroupCoCode, double coCodePercentage, int minimumSampleSize, int maxSampleSize, SampleEstimatorFactory.EstimationType estimationType, CostEstimatorFactory.CostType costComputationType, double minimumCompressionRatio, boolean isInSparkInstruction) {
        this.samplingRatio = samplingRatio;
        this.allowSharedDictionary = allowSharedDictionary;
        this.transposeInput = transposeInput;
        this.seed = seed;
        this.validCompressions = validCompressions;
        this.lossy = lossy;
        this.sortValuesByLength = sortValuesByLength;
        this.columnPartitioner = columnPartitioner;
        this.maxColGroupCoCode = maxColGroupCoCode;
        this.coCodePercentage = coCodePercentage;
        this.minimumSampleSize = minimumSampleSize;
        this.maxSampleSize = maxSampleSize;
        this.estimationType = estimationType;
        this.costComputationType = costComputationType;
        this.minimumCompressionRatio = minimumCompressionRatio;
        this.isInSparkInstruction = isInSparkInstruction;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)this.toString());
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("CompressionSettings: ");
        sb.append("\t Valid Compressions: " + this.validCompressions);
        sb.append("\t Share dict: " + this.allowSharedDictionary);
        sb.append("\t Partitioner: " + (Object)((Object)this.columnPartitioner));
        sb.append("\t Lossy: " + this.lossy);
        sb.append("\t Cost Computation Type: " + (Object)((Object)this.costComputationType));
        if (this.samplingRatio < 1.0) {
            sb.append("\t Estimation Type: " + (Object)((Object)this.estimationType));
        }
        return sb.toString();
    }
}

