/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.rest.jackson.internal;

import java.io.IOException;
import java.io.PrintWriter;
import org.apache.tapestry5.http.ContentType;
import org.apache.tapestry5.http.services.Response;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.apache.tapestry5.jacksondatabind.services.ObjectMapperSource;
import org.apache.tapestry5.services.ComponentEventResultProcessor;

public class JacksonComponentEventResultProcessor<T>
implements ComponentEventResultProcessor<T> {
    private final Response response;
    private final ContentType contentType;
    private final ObjectMapperSource objectMapperSource;
    private final Class<T> entityClass;

    public JacksonComponentEventResultProcessor(Class<T> entityClass, Response response, @Symbol(value="tapestry.charset") String outputEncoding, ObjectMapperSource objectMapperSource) {
        this.response = response;
        this.objectMapperSource = objectMapperSource;
        this.entityClass = entityClass;
        this.contentType = new ContentType("application/json").withCharset(outputEncoding);
    }

    public void processResultValue(T object) throws IOException {
        PrintWriter pw = this.response.getPrintWriter(this.contentType.toString());
        pw.write(this.objectMapperSource.get(this.entityClass).writeValueAsString(object));
        pw.close();
    }
}

