/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.detect.zip;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.tika.config.LoadErrorHandler;
import org.apache.tika.config.ServiceLoader;
import org.apache.tika.detect.zip.DefaultZipContainerDetector;
import org.apache.tika.detect.zip.ZipContainerDetector;
import org.apache.tika.io.BoundedInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;

public class StreamingZipContainerDetector
extends DefaultZipContainerDetector {
    private static final long serialVersionUID = 2891763938430295453L;

    public StreamingZipContainerDetector() {
        this(new ServiceLoader(StreamingZipContainerDetector.class.getClassLoader(), LoadErrorHandler.WARN, false));
    }

    public StreamingZipContainerDetector(ServiceLoader loader) {
        super(loader);
    }

    public StreamingZipContainerDetector(List<ZipContainerDetector> zipDetectors) {
        super(zipDetectors);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MediaType detect(InputStream input, Metadata metadata) throws IOException {
        if (input == null) {
            return MediaType.OCTET_STREAM;
        }
        byte[] prefix = new byte[1024];
        input.mark(1024);
        int length = -1;
        try {
            length = IOUtils.read(input, prefix, 0, 1024);
        }
        finally {
            input.reset();
        }
        MediaType type = StreamingZipContainerDetector.detectArchiveFormat(prefix, length);
        if (type == TIFF) {
            return TIFF;
        }
        if (StreamingZipContainerDetector.isZipArchive(type)) {
            input.mark(this.markLimit);
            try {
                MediaType mediaType;
                try (BoundedInputStream lookahead = new BoundedInputStream(this.markLimit, input);){
                    mediaType = this.detectStreaming(lookahead, metadata);
                }
                return mediaType;
            }
            finally {
                input.reset();
            }
        }
        if (!type.equals(MediaType.OCTET_STREAM)) {
            return type;
        }
        return StreamingZipContainerDetector.detectCompressorFormat(prefix, length);
    }
}

