/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.langdetect.optimaize;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.optimaize.langdetect.DetectedLanguage;
import com.optimaize.langdetect.LanguageDetector;
import com.optimaize.langdetect.LanguageDetectorBuilder;
import com.optimaize.langdetect.i18n.LdLocale;
import com.optimaize.langdetect.ngram.NgramExtractors;
import com.optimaize.langdetect.profiles.BuiltInLanguages;
import com.optimaize.langdetect.profiles.LanguageProfile;
import com.optimaize.langdetect.profiles.LanguageProfileReader;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.tika.language.detect.LanguageConfidence;
import org.apache.tika.language.detect.LanguageNames;
import org.apache.tika.language.detect.LanguageResult;

public class OptimaizeLangDetector
extends org.apache.tika.language.detect.LanguageDetector {
    private static final List<LanguageProfile> DEFAULT_LANGUAGE_PROFILES;
    private static final ImmutableSet<String> DEFAULT_LANGUAGES;
    private static final LanguageDetector DEFAULT_DETECTOR;
    public static final int DEFAULT_MAX_CHARS_FOR_DETECTION = 20000;
    public static final int DEFAULT_MAX_CHARS_FOR_SHORT_DETECTION = 200;
    private LanguageDetector detector;
    private CharArrayWriter writer;
    private Set<String> languages;
    private Map<String, Float> languageProbabilities;
    private int maxCharsForDetection = 20000;

    public OptimaizeLangDetector() {
        this(20000);
    }

    public OptimaizeLangDetector(int maxCharsForDetection) {
        this.writer = new CharArrayWriter(maxCharsForDetection);
    }

    private static String makeLanguageName(LdLocale locale) {
        return LanguageNames.makeName(locale.getLanguage(), locale.getScript().orNull(), locale.getRegion().orNull());
    }

    private static LanguageDetector createDetector(List<LanguageProfile> languageProfiles, Map<String, Float> languageProbabilities) {
        LanguageDetectorBuilder builder = LanguageDetectorBuilder.create(NgramExtractors.standard()).shortTextAlgorithm(30).withProfiles(languageProfiles);
        if (languageProbabilities != null) {
            HashMap<LdLocale, Double> languageWeights = new HashMap<LdLocale, Double>(languageProbabilities.size());
            for (String language : languageProbabilities.keySet()) {
                Double priority = languageProbabilities.get(language).floatValue();
                languageWeights.put(LdLocale.fromString(language), priority);
            }
            builder.languagePriorities(languageWeights);
        }
        return builder.build();
    }

    @Override
    public org.apache.tika.language.detect.LanguageDetector loadModels() {
        this.languages = DEFAULT_LANGUAGES;
        this.detector = this.languageProbabilities != null ? OptimaizeLangDetector.createDetector(DEFAULT_LANGUAGE_PROFILES, this.languageProbabilities) : DEFAULT_DETECTOR;
        return this;
    }

    @Override
    public org.apache.tika.language.detect.LanguageDetector loadModels(Set<String> languages) throws IOException {
        this.languages = new HashSet<String>(languages.size());
        for (String language : languages) {
            this.languages.add(LanguageNames.normalizeName(language));
        }
        HashSet<LdLocale> locales = new HashSet<LdLocale>();
        for (LdLocale locale : BuiltInLanguages.getLanguages()) {
            String languageName = OptimaizeLangDetector.makeLanguageName(locale);
            if (!this.languages.contains(languageName)) continue;
            locales.add(locale);
        }
        this.detector = OptimaizeLangDetector.createDetector(new LanguageProfileReader().readBuiltIn(locales), this.languageProbabilities);
        return this;
    }

    @Override
    public boolean hasModel(String language) {
        return this.languages.contains(language);
    }

    @Override
    public org.apache.tika.language.detect.LanguageDetector setPriors(Map<String, Float> languageProbabilities) throws IOException {
        this.languageProbabilities = languageProbabilities;
        this.loadModels(languageProbabilities.keySet());
        return this;
    }

    @Override
    public void reset() {
        this.writer.reset();
    }

    @Override
    public void addText(char[] cbuf, int off, int len) {
        if (this.hasEnoughText()) {
            return;
        }
        this.writer.write(cbuf, off, len);
        this.writer.write(32);
    }

    @Override
    public List<LanguageResult> detectAll() {
        if (this.detector == null) {
            throw new IllegalStateException("models haven't been loaded yet (forgot to call loadModels?)");
        }
        ArrayList<LanguageResult> result = new ArrayList<LanguageResult>();
        List<DetectedLanguage> rawResults = this.detector.getProbabilities(this.writer.toString());
        for (DetectedLanguage rawResult : rawResults) {
            LanguageConfidence confidence = rawResult.getProbability() > 0.9 ? LanguageConfidence.HIGH : LanguageConfidence.MEDIUM;
            result.add(new LanguageResult(OptimaizeLangDetector.makeLanguageName(rawResult.getLocale()), confidence, (float)rawResult.getProbability()));
        }
        if (result.isEmpty()) {
            result.add(LanguageResult.NULL);
        }
        return result;
    }

    @Override
    public boolean hasEnoughText() {
        return this.writer.size() >= this.getTextLimit();
    }

    private int getTextLimit() {
        int limit;
        int n = limit = this.shortText ? 200 : this.maxCharsForDetection;
        if (this.mixedLanguages) {
            limit *= 2;
        }
        return limit;
    }

    static {
        try {
            DEFAULT_LANGUAGE_PROFILES = ImmutableList.copyOf(new LanguageProfileReader().readAllBuiltIn());
            ImmutableSet.Builder builder = new ImmutableSet.Builder();
            for (LanguageProfile profile : DEFAULT_LANGUAGE_PROFILES) {
                builder.add(OptimaizeLangDetector.makeLanguageName(profile.getLocale()));
            }
            DEFAULT_LANGUAGES = builder.build();
            DEFAULT_DETECTOR = OptimaizeLangDetector.createDetector(DEFAULT_LANGUAGE_PROFILES, null);
        }
        catch (IOException e) {
            throw new RuntimeException("can't initialize OptimaizeLangDetector");
        }
    }
}

