/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.intake.model;

import java.math.BigDecimal;
import org.apache.fulcrum.intake.IntakeException;
import org.apache.fulcrum.intake.model.Field;
import org.apache.fulcrum.intake.model.Group;
import org.apache.fulcrum.intake.model.XmlField;
import org.apache.fulcrum.intake.validator.BigDecimalValidator;

public class BigDecimalField
extends Field<BigDecimal> {
    private static final long serialVersionUID = -8356433008715252236L;

    public BigDecimalField(XmlField field, Group group) throws IntakeException {
        super(field, group);
    }

    @Override
    public void setDefaultValue(String prop) {
        this.defaultValue = null;
        if (prop == null) {
            return;
        }
        this.defaultValue = new BigDecimal(prop);
    }

    @Override
    public void setEmptyValue(String prop) {
        this.emptyValue = null;
        if (prop == null) {
            return;
        }
        this.emptyValue = new BigDecimal(prop);
    }

    @Override
    protected String getDefaultValidator() {
        return BigDecimalValidator.class.getName();
    }

    @Override
    protected void doSetValue() {
        if (this.isMultiValued()) {
            BigDecimal[] values = this.parser.getBigDecimals(this.getKey());
            for (int i = 0; i < values.length; ++i) {
                if (values[i] != null) continue;
                values[i] = (BigDecimal)this.getEmptyValue();
            }
            this.setTestValue(values);
        } else {
            this.setTestValue(this.parser.getBigDecimal(this.getKey(), (BigDecimal)this.getEmptyValue()));
        }
    }
}

