/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputFilter;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.turbine.Turbine;

public abstract class ObjectUtils {
    private static final Logger log = LogManager.getLogger(ObjectUtils.class);

    public static byte[] serializeMap(Map<String, Object> map) throws Exception {
        byte[] byteArray = null;
        HashMap<String, Object> mapCopy = new HashMap<String, Object>(map);
        Iterator i = mapCopy.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            if (entry.getValue() instanceof Serializable) continue;
            i.remove();
            log.warn("Skipping serialization, value is not serializable: " + String.valueOf(entry.getValue()));
        }
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
             ObjectOutputStream out = new ObjectOutputStream(baos);){
            out.writeObject(mapCopy);
            out.flush();
            byteArray = baos.toByteArray();
        }
        return byteArray;
    }

    public static <T> T deserialize(byte[] objectData) {
        Object object = null;
        if (objectData != null) {
            String filterPattern = Turbine.getConfiguration().getString("session.objectinputfilter");
            try (ByteArrayInputStream bin = new ByteArrayInputStream(objectData);
                 ObjectInputStream in = new ObjectInputStream(bin);){
                if (StringUtils.isNotEmpty((CharSequence)filterPattern)) {
                    in.setObjectInputFilter(ObjectInputFilter.Config.createFilter(filterPattern));
                }
                object = in.readObject();
            }
            catch (Exception e) {
                log.warn("Problem deserializing object.", (Throwable)e);
            }
        }
        return (T)object;
    }
}

