/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.modules.screens;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.turbine.modules.screens.RawScreen;
import org.apache.turbine.pipeline.PipelineData;
import org.apache.turbine.util.RunData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlainJSONScreen
extends RawScreen {
    protected static final String JSON_TYPE = "application/json;charset=utf-8";
    protected static final int BUFFER_SIZE = 4096;
    static final Logger log = LoggerFactory.getLogger(PlainJSONScreen.class);

    @Override
    protected String getContentType(PipelineData pipelineData) {
        return JSON_TYPE;
    }

    @Override
    protected void doOutput(PipelineData pipelineData) throws Exception {
        RunData data = pipelineData.getRunData();
        Charset charset = StandardCharsets.UTF_8;
        String json_res = data.getMessage();
        log.debug("json_res output: {}", (Object)json_res);
        try (PrintWriter out = new PrintWriter(new OutputStreamWriter((OutputStream)data.getResponse().getOutputStream(), charset));){
            out.print(json_res.toString());
            out.flush();
        }
    }
}

