/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.ide.debug.ui.launchConfiguration;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.uima.ruta.ide.RutaIdeUIPlugin;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationManager;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationsMessages;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchGroupExtension;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchHistory;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.ILaunchGroup;
import org.eclipse.debug.ui.StringVariableSelectionDialog;
import org.eclipse.dltk.core.environment.EnvironmentManager;
import org.eclipse.dltk.core.environment.IExecutionEnvironment;
import org.eclipse.dltk.core.environment.IFileHandle;
import org.eclipse.dltk.internal.ui.util.SWTUtil;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchEncoding;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.ide.IDEEncoding;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceComparator;

public class RutaCommonTab
extends AbstractLaunchConfigurationTab {
    private static final String EMPTY_STRING = "";
    private Button fLocalRadioButton;
    private Button fSharedRadioButton;
    private Text fSharedLocationText;
    private Button fSharedLocationButton;
    private Button fLaunchInBackgroundButton;
    private Button fDefaultEncodingButton;
    private Button fAltEncodingButton;
    private Combo fEncodingCombo;
    private Button fConsoleOutput;
    private Button fFileOutput;
    private Button fFileBrowse;
    private Text fFileText;
    private Button fVariables;
    private Button fAppend;
    private Button fWorkspaceBrowse;
    private Button fUseDltkRadio;
    private Button fNotUseDltkRatio;
    private CheckboxTableViewer fFavoritesTable;
    private ModifyListener fBasicModifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent evt) {
            RutaCommonTab.this.updateLaunchConfigurationDialog();
        }
    };

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.debug.ui.launch_configuration_dialog_common_tab");
        comp.setLayout((Layout)new GridLayout(2, true));
        comp.setFont(parent.getFont());
        this.createSharedConfigComponent(comp);
        this.createFavoritesComponent(comp);
        this.createEncodingComponent(comp);
        this.createOutputCaptureComponent(comp);
        this.createLaunchInBackgroundComponent(comp);
    }

    private void createFavoritesComponent(Composite parent) {
        Group favComp = SWTUtil.createGroup((Composite)parent, (String)LaunchConfigurationsMessages.CommonTab_Display_in_favorites_menu__10, (int)1, (int)1, (int)1808);
        this.fFavoritesTable = CheckboxTableViewer.newCheckList((Composite)favComp, (int)67618);
        Control table = this.fFavoritesTable.getControl();
        GridData gd = new GridData(1808);
        table.setLayoutData((Object)gd);
        table.setFont(parent.getFont());
        this.fFavoritesTable.setContentProvider((IContentProvider)new FavoritesContentProvider());
        this.fFavoritesTable.setLabelProvider((IBaseLabelProvider)new FavoritesLabelProvider());
        this.fFavoritesTable.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                RutaCommonTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    private void createSharedConfigComponent(Composite parent) {
        Group group = SWTUtil.createGroup((Composite)parent, (String)LaunchConfigurationsMessages.CommonTab_0, (int)3, (int)2, (int)768);
        this.fLocalRadioButton = this.createRadioButton((Composite)group, LaunchConfigurationsMessages.CommonTab_L_ocal_3);
        GridData gd = new GridData();
        gd.horizontalSpan = 3;
        this.fLocalRadioButton.setLayoutData((Object)gd);
        this.fSharedRadioButton = this.createRadioButton((Composite)group, LaunchConfigurationsMessages.CommonTab_S_hared_4);
        this.fSharedRadioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                RutaCommonTab.this.handleSharedRadioButtonSelected();
            }
        });
        this.fSharedLocationText = SWTUtil.createSingleText((Composite)group, (int)1);
        this.fSharedLocationText.addModifyListener(this.fBasicModifyListener);
        this.fSharedLocationButton = this.createPushButton((Composite)group, LaunchConfigurationsMessages.CommonTab__Browse_6, null);
        this.fSharedLocationButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                RutaCommonTab.this.handleSharedLocationButtonSelected();
            }
        });
        this.fLocalRadioButton.setSelection(true);
        this.setSharedEnabled(false);
    }

    private void createOutputCaptureComponent(Composite parent) {
        Group group = SWTUtil.createGroup((Composite)parent, (String)"Input and Output", (int)1, (int)2, (int)768);
        this.fUseDltkRadio = this.createRadioButton((Composite)group, "Use DLTK Input and Output");
        this.fUseDltkRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RutaCommonTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.fNotUseDltkRatio = this.createRadioButton((Composite)group, "Use Standard Input and Output");
        this.fNotUseDltkRatio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RutaCommonTab.this.updateLaunchConfigurationDialog();
            }
        });
        Group standardGroup = SWTUtil.createGroup((Composite)group, (String)EMPTY_STRING, (int)5, (int)2, (int)768);
        this.fConsoleOutput = this.createCheckButton((Composite)standardGroup, LaunchConfigurationsMessages.CommonTab_5);
        GridData gd = new GridData(1, 0, true, false);
        gd.horizontalSpan = 5;
        this.fConsoleOutput.setLayoutData((Object)gd);
        this.fConsoleOutput.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RutaCommonTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.fFileOutput = this.createCheckButton((Composite)standardGroup, LaunchConfigurationsMessages.CommonTab_6);
        this.fFileOutput.setLayoutData((Object)new GridData(1, 0, false, false));
        this.fFileOutput.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RutaCommonTab.this.enableOuputCaptureWidgets(RutaCommonTab.this.fFileOutput.getSelection());
                RutaCommonTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.fFileText = SWTUtil.createSingleText((Composite)standardGroup, (int)4);
        this.fFileText.addModifyListener(this.fBasicModifyListener);
        SWTUtil.createLabel((Composite)standardGroup, (String)EMPTY_STRING, (int)2);
        this.fWorkspaceBrowse = this.createPushButton((Composite)standardGroup, LaunchConfigurationsMessages.CommonTab_12, null);
        this.fWorkspaceBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(RutaCommonTab.this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
                dialog.setTitle(LaunchConfigurationsMessages.CommonTab_13);
                dialog.setMessage(LaunchConfigurationsMessages.CommonTab_14);
                dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
                dialog.setComparator((ViewerComparator)new ResourceComparator(1));
                if (dialog.open() == 0) {
                    IResource resource = (IResource)dialog.getFirstResult();
                    String arg = resource.getFullPath().toString();
                    String fileLoc = VariablesPlugin.getDefault().getStringVariableManager().generateVariableExpression("workspace_loc", arg);
                    RutaCommonTab.this.fFileText.setText(fileLoc);
                }
            }
        });
        this.fFileBrowse = this.createPushButton((Composite)standardGroup, LaunchConfigurationsMessages.CommonTab_7, null);
        this.fFileBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String filePath = RutaCommonTab.this.fFileText.getText();
                FileDialog dialog = new FileDialog(RutaCommonTab.this.getShell(), 8192);
                filePath = dialog.open();
                if (filePath != null) {
                    RutaCommonTab.this.fFileText.setText(filePath);
                }
            }
        });
        this.fVariables = this.createPushButton((Composite)standardGroup, LaunchConfigurationsMessages.CommonTab_9, null);
        this.fVariables.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                StringVariableSelectionDialog dialog = new StringVariableSelectionDialog(RutaCommonTab.this.getShell());
                dialog.open();
                String variable = dialog.getVariableExpression();
                if (variable != null) {
                    RutaCommonTab.this.fFileText.insert(variable);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.fAppend = this.createCheckButton((Composite)standardGroup, LaunchConfigurationsMessages.CommonTab_11);
        gd = new GridData(16384, 128, true, false);
        gd.horizontalSpan = 4;
        this.fAppend.setLayoutData((Object)gd);
        this.fAppend.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RutaCommonTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    private void enableOuputCaptureWidgets(boolean enable) {
        this.fFileText.setEnabled(enable);
        this.fFileBrowse.setEnabled(enable);
        this.fWorkspaceBrowse.setEnabled(enable);
        this.fVariables.setEnabled(enable);
        this.fAppend.setEnabled(enable);
    }

    private void createEncodingComponent(Composite parent) {
        List allEncodings = IDEEncoding.getIDEEncodings();
        String defaultEncoding = WorkbenchEncoding.getWorkbenchDefaultEncoding();
        Group group = SWTUtil.createGroup((Composite)parent, (String)LaunchConfigurationsMessages.CommonTab_1, (int)2, (int)1, (int)1808);
        this.fDefaultEncodingButton = this.createRadioButton((Composite)group, MessageFormat.format(LaunchConfigurationsMessages.CommonTab_2, defaultEncoding));
        GridData gd = new GridData(1, 0, true, false);
        gd.horizontalSpan = 2;
        this.fDefaultEncodingButton.setLayoutData((Object)gd);
        this.fAltEncodingButton = this.createRadioButton((Composite)group, LaunchConfigurationsMessages.CommonTab_3);
        this.fAltEncodingButton.setLayoutData((Object)new GridData(32));
        this.fEncodingCombo = new Combo((Composite)group, 8);
        this.fEncodingCombo.setLayoutData((Object)new GridData(768));
        this.fEncodingCombo.setFont(parent.getFont());
        String[] encodingArray = allEncodings.toArray(new String[0]);
        this.fEncodingCombo.setItems(encodingArray);
        if (encodingArray.length > 0) {
            this.fEncodingCombo.select(0);
        }
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RutaCommonTab.this.updateLaunchConfigurationDialog();
                RutaCommonTab.this.fEncodingCombo.setEnabled(RutaCommonTab.this.fAltEncodingButton.getSelection());
            }
        };
        this.fAltEncodingButton.addSelectionListener((SelectionListener)listener);
        this.fDefaultEncodingButton.addSelectionListener((SelectionListener)listener);
        this.fEncodingCombo.addSelectionListener((SelectionListener)listener);
    }

    protected void createLaunchInBackgroundComponent(Composite parent) {
        this.fLaunchInBackgroundButton = this.createCheckButton(parent, LaunchConfigurationsMessages.CommonTab_10);
        GridData data = new GridData(256);
        data.horizontalSpan = 2;
        this.fLaunchInBackgroundButton.setLayoutData((Object)data);
        this.fLaunchInBackgroundButton.setFont(parent.getFont());
        this.fLaunchInBackgroundButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RutaCommonTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    private void handleSharedRadioButtonSelected() {
        this.setSharedEnabled(this.isShared());
        this.updateLaunchConfigurationDialog();
    }

    private void setSharedEnabled(boolean enable) {
        this.fSharedLocationText.setEnabled(enable);
        this.fSharedLocationButton.setEnabled(enable);
    }

    private String getDefaultSharedConfigLocation(ILaunchConfiguration config) {
        String path = EMPTY_STRING;
        try {
            IResource[] res = config.getMappedResources();
            if (res != null) {
                for (int i = 0; i < res.length; ++i) {
                    IProject proj = res[i].getProject();
                    if (!proj.isAccessible()) continue;
                    return proj.getFullPath().toOSString();
                }
            }
        }
        catch (CoreException e) {
            DebugUIPlugin.log((Throwable)e);
        }
        return path;
    }

    private boolean isShared() {
        return this.fSharedRadioButton.getSelection();
    }

    private void handleSharedLocationButtonSelected() {
        String currentContainerString = this.fSharedLocationText.getText();
        IContainer currentContainer = this.getContainer(currentContainerString);
        SharedLocationSelectionDialog dialog = new SharedLocationSelectionDialog(this.getShell(), currentContainer, false, LaunchConfigurationsMessages.CommonTab_Select_a_location_for_the_launch_configuration_13);
        dialog.showClosedProjects(false);
        dialog.open();
        Object[] results = dialog.getResult();
        if (results != null && results.length > 0 && results[0] instanceof IPath) {
            IPath path = (IPath)results[0];
            String containerName = path.toOSString();
            this.fSharedLocationText.setText(containerName);
        }
    }

    private IContainer getContainer(String path) {
        Path containerPath = new Path(path);
        return (IContainer)this.getWorkspaceRoot().findMember((IPath)containerPath);
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        boolean isShared = !configuration.isLocal();
        this.fSharedRadioButton.setSelection(isShared);
        this.fLocalRadioButton.setSelection(!isShared);
        this.setSharedEnabled(isShared);
        this.fSharedLocationText.setText(this.getDefaultSharedConfigLocation(configuration));
        if (isShared) {
            IContainer parent;
            String containerName = EMPTY_STRING;
            IFile file = configuration.getFile();
            if (file != null && (parent = file.getParent()) != null) {
                containerName = parent.getFullPath().toOSString();
            }
            this.fSharedLocationText.setText(containerName);
        }
        this.updateFavoritesFromConfig(configuration);
        this.updateLaunchInBackground(configuration);
        this.updateEncoding(configuration);
        this.updateConsoleOutput(configuration);
    }

    private void updateConsoleOutput(ILaunchConfiguration configuration) {
        boolean haveOutputFile;
        boolean outputToConsole = true;
        String outputFile = null;
        boolean append = false;
        boolean dltkOutput = false;
        try {
            dltkOutput = configuration.getAttribute("use_dltk_interactive_console", false);
            outputToConsole = configuration.getAttribute("org.eclipse.debug.ui.ATTR_CONSOLE_OUTPUT_ON", true);
            outputFile = configuration.getAttribute("org.eclipse.debug.ui.ATTR_CAPTURE_IN_FILE", (String)null);
            append = configuration.getAttribute("org.eclipse.debug.ui.ATTR_APPEND_TO_FILE", false);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        this.fUseDltkRadio.setSelection(dltkOutput);
        this.fNotUseDltkRatio.setSelection(!dltkOutput);
        this.fConsoleOutput.setSelection(outputToConsole);
        this.fAppend.setSelection(append);
        boolean bl = haveOutputFile = outputFile != null;
        if (haveOutputFile) {
            this.fFileText.setText(outputFile);
        }
        this.fFileOutput.setSelection(haveOutputFile);
        this.enableOuputCaptureWidgets(haveOutputFile);
    }

    protected void updateLaunchInBackground(ILaunchConfiguration configuration) {
        this.fLaunchInBackgroundButton.setSelection(RutaCommonTab.isLaunchInBackground(configuration));
    }

    private void updateEncoding(ILaunchConfiguration configuration) {
        String encoding = null;
        try {
            encoding = configuration.getAttribute("org.eclipse.debug.ui.ATTR_CONSOLE_ENCODING", (String)null);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        if (encoding != null) {
            this.fAltEncodingButton.setSelection(true);
            this.fDefaultEncodingButton.setSelection(false);
            this.fEncodingCombo.setText(encoding);
            this.fEncodingCombo.setEnabled(true);
        } else {
            this.fDefaultEncodingButton.setSelection(true);
            this.fAltEncodingButton.setSelection(false);
            this.fEncodingCombo.setEnabled(false);
        }
    }

    public static boolean isLaunchInBackground(ILaunchConfiguration configuration) {
        boolean launchInBackground = true;
        try {
            launchInBackground = configuration.getAttribute("org.eclipse.debug.ui.ATTR_LAUNCH_IN_BACKGROUND", true);
        }
        catch (CoreException ce) {
            DebugUIPlugin.log((Throwable)ce);
        }
        return launchInBackground;
    }

    private void updateFavoritesFromConfig(ILaunchConfiguration config) {
        this.fFavoritesTable.setInput((Object)config);
        this.fFavoritesTable.setCheckedElements(new Object[0]);
        try {
            List groups = config.getAttribute("org.eclipse.debug.ui.favoriteGroups", new ArrayList());
            if (groups.isEmpty()) {
                if (config.getAttribute("org.eclipse.debug.ui.debugFavorite", false)) {
                    groups.add("org.eclipse.debug.ui.launchGroup.debug");
                }
                if (config.getAttribute("org.eclipse.debug.ui.runFavorite", false)) {
                    groups.add("org.eclipse.debug.ui.launchGroup.run");
                }
            }
            if (!groups.isEmpty()) {
                ArrayList<LaunchGroupExtension> list = new ArrayList<LaunchGroupExtension>();
                for (String id : groups) {
                    LaunchGroupExtension extension = this.getLaunchConfigurationManager().getLaunchGroup(id);
                    list.add(extension);
                }
                this.fFavoritesTable.setCheckedElements(list.toArray());
            }
        }
        catch (CoreException e) {
            DebugUIPlugin.log((Throwable)e);
        }
    }

    private void updateConfigFromLocalShared(ILaunchConfigurationWorkingCopy config) {
        if (this.isShared()) {
            String containerPathString = this.fSharedLocationText.getText();
            IContainer container = this.getContainer(containerPathString);
            config.setContainer(container);
        } else {
            config.setContainer(null);
        }
    }

    protected LaunchConfigurationManager getLaunchConfigurationManager() {
        return DebugUIPlugin.getDefault().getLaunchConfigurationManager();
    }

    private void updateConfigFromFavorites(ILaunchConfigurationWorkingCopy config) {
        try {
            ArrayList<Object> groups;
            Object[] checked = this.fFavoritesTable.getCheckedElements();
            boolean debug = config.getAttribute("org.eclipse.debug.ui.debugFavorite", false);
            boolean run = config.getAttribute("org.eclipse.debug.ui.runFavorite", false);
            if (debug || run) {
                groups = new ArrayList<Object>();
                int num = 0;
                if (debug) {
                    groups.add(this.getLaunchConfigurationManager().getLaunchGroup("org.eclipse.debug.ui.launchGroup.debug"));
                    ++num;
                }
                if (run) {
                    ++num;
                    groups.add(this.getLaunchConfigurationManager().getLaunchGroup("org.eclipse.debug.ui.launchGroup.debug"));
                }
                if (num == checked.length) {
                    boolean different = false;
                    for (int i = 0; i < checked.length; ++i) {
                        if (groups.contains(checked[i])) continue;
                        different = true;
                        break;
                    }
                    if (!different) {
                        return;
                    }
                }
            }
            config.setAttribute("org.eclipse.debug.ui.debugFavorite", (String)null);
            config.setAttribute("org.eclipse.debug.ui.runFavorite", (String)null);
            groups = null;
            for (int i = 0; i < checked.length; ++i) {
                LaunchGroupExtension group = (LaunchGroupExtension)checked[i];
                if (groups == null) {
                    groups = new ArrayList();
                }
                groups.add(group.getIdentifier());
            }
            config.setAttribute("org.eclipse.debug.ui.favoriteGroups", groups);
        }
        catch (CoreException e) {
            DebugUIPlugin.log((Throwable)e);
        }
    }

    private IWorkspaceRoot getWorkspaceRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    public boolean isValid(ILaunchConfiguration config) {
        this.setMessage(null);
        this.setErrorMessage(null);
        return this.validateLocalShared() && this.validateRedirectFile() && this.validateEncoding();
    }

    private boolean validateEncoding() {
        return !this.fAltEncodingButton.getSelection() || this.fEncodingCombo.getSelectionIndex() != -1;
    }

    private boolean validateRedirectFile() {
        int len;
        if (this.fFileOutput.getSelection() && (len = this.fFileText.getText().trim().length()) == 0) {
            this.setErrorMessage(LaunchConfigurationsMessages.CommonTab_8);
            return false;
        }
        return true;
    }

    private boolean validateLocalShared() {
        if (this.isShared()) {
            String path = this.fSharedLocationText.getText().trim();
            IContainer container = this.getContainer(path);
            if (container == null || container.equals((Object)ResourcesPlugin.getWorkspace().getRoot())) {
                this.setErrorMessage(LaunchConfigurationsMessages.CommonTab_Invalid_shared_configuration_location_14);
                return false;
            }
            if (!container.getProject().isOpen()) {
                this.setErrorMessage(LaunchConfigurationsMessages.CommonTab_Cannot_save_launch_configuration_in_a_closed_project__1);
                return false;
            }
        }
        return true;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        config.setContainer(null);
        config.setAttribute("org.eclipse.debug.ui.ATTR_LAUNCH_IN_BACKGROUND", true);
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        this.updateConfigFromLocalShared(configuration);
        this.updateConfigFromFavorites(configuration);
        this.setAttribute("org.eclipse.debug.ui.ATTR_LAUNCH_IN_BACKGROUND", configuration, this.fLaunchInBackgroundButton.getSelection(), true);
        String encoding = null;
        if (this.fAltEncodingButton.getSelection()) {
            encoding = this.fEncodingCombo.getText();
        }
        configuration.setAttribute("org.eclipse.debug.ui.ATTR_CONSOLE_ENCODING", encoding);
        boolean captureOutput = false;
        if (this.fConsoleOutput.getSelection()) {
            captureOutput = true;
            configuration.setAttribute("org.eclipse.debug.ui.ATTR_CONSOLE_OUTPUT_ON", (String)null);
        } else {
            configuration.setAttribute("org.eclipse.debug.ui.ATTR_CONSOLE_OUTPUT_ON", false);
        }
        if (this.fFileOutput.getSelection()) {
            captureOutput = true;
            String file = this.fFileText.getText();
            configuration.setAttribute("org.eclipse.debug.ui.ATTR_CAPTURE_IN_FILE", file);
            if (this.fAppend.getSelection()) {
                configuration.setAttribute("org.eclipse.debug.ui.ATTR_APPEND_TO_FILE", true);
            } else {
                configuration.setAttribute("org.eclipse.debug.ui.ATTR_APPEND_TO_FILE", (String)null);
            }
        } else {
            configuration.setAttribute("org.eclipse.debug.ui.ATTR_CAPTURE_IN_FILE", (String)null);
        }
        boolean useDltk = false;
        if (this.fUseDltkRadio.getSelection()) {
            configuration.setAttribute("org.eclipse.debug.core.capture_output", (String)null);
            configuration.setAttribute("console_id", Long.toString(System.currentTimeMillis()));
            try {
                IExecutionEnvironment exeEnv = (IExecutionEnvironment)EnvironmentManager.getLocalEnvironment().getAdapter(IExecutionEnvironment.class);
                IFileHandle proxyFile = RutaIdeUIPlugin.getDefault().getConsoleProxy(exeEnv);
                configuration.setAttribute("environmentId", proxyFile.getEnvironment().getId());
                configuration.setAttribute("proxy_path", proxyFile.toOSString());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            captureOutput = false;
            useDltk = true;
        }
        configuration.setAttribute("use_dltk_interactive_console", useDltk);
        if (captureOutput) {
            configuration.setAttribute("org.eclipse.debug.core.capture_output", (String)null);
        } else {
            configuration.setAttribute("org.eclipse.debug.core.capture_output", false);
        }
    }

    public String getName() {
        return LaunchConfigurationsMessages.CommonTab__Common_15;
    }

    public boolean canSave() {
        return this.validateLocalShared();
    }

    public Image getImage() {
        return DebugUITools.getImage((String)"IMG_OBJS_COMMON_TAB");
    }

    public void activated(ILaunchConfigurationWorkingCopy workingCopy) {
    }

    public void deactivated(ILaunchConfigurationWorkingCopy workingCopy) {
    }

    class FavoritesContentProvider
    implements IStructuredContentProvider {
        FavoritesContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            ILaunchGroup[] groups = DebugUITools.getLaunchGroups();
            ArrayList<ILaunchGroup> possibleGroups = new ArrayList<ILaunchGroup>();
            ILaunchConfiguration configuration = (ILaunchConfiguration)inputElement;
            for (int i = 0; i < groups.length; ++i) {
                ILaunchGroup extension = groups[i];
                LaunchHistory history = RutaCommonTab.this.getLaunchConfigurationManager().getLaunchHistory(extension.getIdentifier());
                if (history == null || !history.accepts(configuration)) continue;
                possibleGroups.add(extension);
            }
            return possibleGroups.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    class FavoritesLabelProvider
    implements ITableLabelProvider {
        private Map fImages = new HashMap();

        FavoritesLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            ImageDescriptor descriptor;
            Image image = (Image)this.fImages.get(element);
            if (image == null && (descriptor = ((LaunchGroupExtension)element).getImageDescriptor()) != null) {
                image = descriptor.createImage();
                this.fImages.put(element, image);
            }
            return image;
        }

        public String getColumnText(Object element, int columnIndex) {
            String label = ((LaunchGroupExtension)element).getLabel();
            return DebugUIPlugin.removeAccelerators((String)label);
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
            for (Image image : this.fImages.values()) {
                image.dispose();
            }
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    class SharedLocationSelectionDialog
    extends ContainerSelectionDialog {
        private final String SETTINGS_ID = "org.eclipse.debug.ui.SHARED_LAUNCH_CONFIGURATON_DIALOG";

        public SharedLocationSelectionDialog(Shell parentShell, IContainer initialRoot, boolean allowNewContainerName, String message) {
            super(parentShell, initialRoot, allowNewContainerName, message);
            this.SETTINGS_ID = "org.eclipse.debug.ui.SHARED_LAUNCH_CONFIGURATON_DIALOG";
        }

        protected IDialogSettings getDialogBoundsSettings() {
            IDialogSettings settings = DebugUIPlugin.getDefault().getDialogSettings();
            IDialogSettings section = settings.getSection("org.eclipse.debug.ui.SHARED_LAUNCH_CONFIGURATON_DIALOG");
            if (section == null) {
                section = settings.addNewSection("org.eclipse.debug.ui.SHARED_LAUNCH_CONFIGURATON_DIALOG");
            }
            return section;
        }
    }
}

