/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.impl;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Optional;
import java.util.Spliterator;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import java.util.stream.Collector;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.CASRuntimeException;
import org.apache.uima.cas.FSIndex;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.SelectFSs;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.impl.CASImpl;
import org.apache.uima.cas.impl.FSIndexRepositoryImpl;
import org.apache.uima.cas.impl.FilteredIterator;
import org.apache.uima.cas.impl.FsIndex_annotation;
import org.apache.uima.cas.impl.FsIndex_iicp;
import org.apache.uima.cas.impl.FsIndex_singletype;
import org.apache.uima.cas.impl.FsIterator_aggregation_common;
import org.apache.uima.cas.impl.FsIterator_backwards;
import org.apache.uima.cas.impl.FsIterator_limited;
import org.apache.uima.cas.impl.FsIterator_subtypes_snapshot;
import org.apache.uima.cas.impl.LowLevelIndex;
import org.apache.uima.cas.impl.LowLevelIterator;
import org.apache.uima.cas.impl.Subiterator;
import org.apache.uima.cas.impl.TypeImpl;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.cas.text.AnnotationIndex;
import org.apache.uima.cas.text.AnnotationPredicates;
import org.apache.uima.jcas.cas.EmptyFSList;
import org.apache.uima.jcas.cas.FSArray;
import org.apache.uima.jcas.cas.FSList;
import org.apache.uima.jcas.cas.NonEmptyFSList;
import org.apache.uima.jcas.cas.TOP;
import org.apache.uima.jcas.impl.JCasImpl;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.util.AutoCloseableNoException;

public class SelectFSs_impl<T extends FeatureStructure>
implements SelectFSs<T> {
    private static final boolean IS_UNORDERED = true;
    private static final boolean IS_ORDERED = false;
    private static final boolean IS_UNAMBIGUOUS = false;
    private static final boolean IS_NOT_STRICT = false;
    private CASImpl view;
    private JCasImpl jcas;
    private LowLevelIndex<T> index;
    private TypeImpl ti;
    private int shift;
    private int limit = -1;
    private FeatureStructure[] sourceFSArray = null;
    private FSList sourceFSList = null;
    private boolean isTypePriority = false;
    private boolean isSkipSameBeginEndType = false;
    private boolean isNonOverlapping = false;
    private boolean isIncludeAnnotBeyondBounds = false;
    private boolean isAllViews = false;
    private boolean isNullOK = false;
    private boolean isUnordered = false;
    private boolean isBackwards = false;
    private boolean isFollowing = false;
    private boolean isPreceding = false;
    private boolean isAltSource = false;
    private Subiterator.BoundsUse boundsUse = null;
    private TOP startingFs = null;
    private AnnotationFS boundingFs = null;
    private boolean noResult = false;

    public SelectFSs_impl(CAS cas) {
        this.view = (CASImpl)cas.getLowLevelCAS();
        this.jcas = (JCasImpl)this.view.getJCas();
    }

    public SelectFSs_impl(FSArray source) {
        this(source._casView);
        this.isAltSource = true;
        this.sourceFSArray = source._getTheArray();
    }

    public SelectFSs_impl(FeatureStructure[] source, CAS cas) {
        this(cas);
        this.isAltSource = true;
        this.sourceFSArray = source;
    }

    public SelectFSs_impl(FSList source) {
        this(source._casView);
        this.isAltSource = true;
        this.sourceFSList = source;
    }

    public SelectFSs_impl<T> index(String indexName) {
        this.index = this.view.indexRepository.getIndex(indexName);
        return this;
    }

    public SelectFSs_impl<T> index(FSIndex<T> aIndex) {
        this.index = (LowLevelIndex)aIndex;
        return this;
    }

    public <N extends T> SelectFSs_impl<N> anyType() {
        this.ti = null;
        return this;
    }

    public <N extends T> SelectFSs_impl<N> type(Type uimaType) {
        Type type;
        if (uimaType == null) {
            throw new IllegalArgumentException("Must specify a type");
        }
        if (this.view.getTypeSystemImpl() != ((TypeImpl)uimaType).getTypeSystem() && (type = this.view.getTypeSystem().getType(uimaType.getName())) == null) {
            throw new IllegalArgumentException("Undefined type: [" + uimaType.getName() + "]");
        }
        this.ti = (TypeImpl)uimaType;
        return this;
    }

    public <N extends T> SelectFSs_impl<N> type(String fullyQualifiedTypeName) {
        if (fullyQualifiedTypeName == null) {
            throw new IllegalArgumentException("Must specify a type");
        }
        TypeImpl type = this.view.getTypeSystemImpl().getType(fullyQualifiedTypeName);
        if (type == null) {
            throw new IllegalArgumentException("Undefined type: [" + fullyQualifiedTypeName + "]");
        }
        this.ti = type;
        return this;
    }

    public <N extends T> SelectFSs_impl<N> type(int jcasClass_dot_type) {
        this.ti = (TypeImpl)this.view.getJCas().getCasType(jcasClass_dot_type);
        return this;
    }

    public <N extends T> SelectFSs_impl<N> type(Class<N> jcasClass_dot_class) {
        if (jcasClass_dot_class == null) {
            throw new IllegalArgumentException("Must specify a type");
        }
        this.ti = (TypeImpl)this.view.getJCasImpl().getCasType(jcasClass_dot_class);
        return this;
    }

    @Override
    public SelectFSs<T> typePriority() {
        this.isTypePriority = true;
        return this;
    }

    @Override
    public SelectFSs<T> typePriority(boolean aTypePriority) {
        this.isTypePriority = aTypePriority;
        return this;
    }

    boolean usesTypePriority() {
        return this.isTypePriority;
    }

    @Override
    public SelectFSs<T> skipWhenSameBeginEndType() {
        this.isSkipSameBeginEndType = true;
        return this;
    }

    @Override
    public SelectFSs<T> useAnnotationEquals(boolean useAnnotationEquals) {
        this.isSkipSameBeginEndType = useAnnotationEquals;
        return this;
    }

    @Override
    public SelectFSs_impl<T> nonOverlapping() {
        this.isNonOverlapping = true;
        return this;
    }

    @Override
    public SelectFSs_impl<T> nonOverlapping(boolean bNonOverlapping) {
        this.isNonOverlapping = bNonOverlapping;
        return this;
    }

    @Override
    public SelectFSs_impl<T> includeAnnotationsWithEndBeyondBounds() {
        this.isIncludeAnnotBeyondBounds = true;
        return this;
    }

    @Override
    public SelectFSs_impl<T> includeAnnotationsWithEndBeyondBounds(boolean includeAnnotationsWithEndBeyondBounds) {
        this.isIncludeAnnotBeyondBounds = includeAnnotationsWithEndBeyondBounds;
        return this;
    }

    @Override
    public SelectFSs_impl<T> allViews() {
        this.isAllViews = true;
        return this;
    }

    @Override
    public SelectFSs_impl<T> allViews(boolean bAllViews) {
        this.isAllViews = bAllViews;
        return this;
    }

    @Override
    public SelectFSs_impl<T> nullOK() {
        this.isNullOK = true;
        return this;
    }

    @Override
    public SelectFSs_impl<T> nullOK(boolean bNullOk) {
        this.isNullOK = bNullOk;
        return this;
    }

    @Override
    public SelectFSs_impl<T> orderNotNeeded() {
        this.isUnordered = true;
        return this;
    }

    @Override
    public SelectFSs_impl<T> orderNotNeeded(boolean bUnordered) {
        this.isUnordered = bUnordered;
        return this;
    }

    @Override
    public SelectFSs_impl<T> backwards() {
        this.isBackwards = true;
        return this;
    }

    @Override
    public SelectFSs_impl<T> backwards(boolean bBackwards) {
        this.isBackwards = bBackwards;
        return this;
    }

    @Override
    public SelectFSs_impl<T> shifted(int shiftAmount) {
        this.shift = shiftAmount;
        return this;
    }

    @Override
    public SelectFSs_impl<T> startAt(FeatureStructure fs) {
        this.startingFs = (TOP)fs;
        return this;
    }

    @Override
    public SelectFSs_impl<T> startAt(TOP fs) {
        this.startingFs = fs;
        return this;
    }

    @Override
    public SelectFSs_impl<T> startAt(int begin) {
        this.isTypePriority = false;
        this.startingFs = this.makePosAnnot(begin, Integer.MAX_VALUE);
        return this;
    }

    @Override
    public SelectFSs_impl<T> startAt(int begin, int end) {
        this.startingFs = this.makePosAnnot(begin, end);
        return this;
    }

    @Override
    public SelectFSs_impl<T> startAt(TOP fs, int offset) {
        this.startingFs = fs;
        this.shift = offset;
        return this;
    }

    @Override
    public SelectFSs_impl<T> startAt(FeatureStructure fs, int offset) {
        this.startingFs = (TOP)fs;
        this.shift = offset;
        return this;
    }

    @Override
    public SelectFSs_impl<T> startAt(int begin, int end, int offset) {
        this.startingFs = this.makePosAnnot(begin, end);
        this.shift = offset;
        return this;
    }

    @Override
    public SelectFSs_impl<T> limit(int alimit) {
        if (alimit < 0) {
            throw new IllegalArgumentException("limit argument must be >= 0, but was " + alimit);
        }
        this.limit = alimit;
        return this;
    }

    @Override
    public SelectFSs_impl<T> coveredBy(AnnotationFS fs) {
        this.boundsUse = Subiterator.BoundsUse.coveredBy;
        this.boundingFs = fs;
        return this;
    }

    @Override
    public SelectFSs_impl<T> coveredBy(int begin, int end) {
        this.boundsUse = Subiterator.BoundsUse.coveredBy;
        this.boundingFs = this.makePosAnnot(begin, end);
        return this;
    }

    @Override
    public SelectFSs_impl<T> covering(AnnotationFS fs) {
        this.boundsUse = Subiterator.BoundsUse.covering;
        this.boundingFs = fs;
        return this;
    }

    @Override
    public SelectFSs_impl<T> covering(int begin, int end) {
        this.boundsUse = Subiterator.BoundsUse.covering;
        this.boundingFs = this.makePosAnnot(begin, end);
        return this;
    }

    @Override
    public SelectFSs_impl<T> between(AnnotationFS fs1, AnnotationFS fs2) {
        int end;
        boolean reverse = fs1.getEnd() > fs2.getBegin();
        int begin = (reverse ? fs2 : fs1).getEnd();
        if (begin > (end = (reverse ? fs1 : fs2).getBegin())) {
            this.noResult = true;
            return this;
        }
        return this.coveredBy(begin, end);
    }

    @Override
    public SelectFSs<T> at(AnnotationFS fs) {
        this.boundsUse = Subiterator.BoundsUse.sameBeginEnd;
        this.boundingFs = fs;
        return this;
    }

    @Override
    public SelectFSs<T> at(int begin, int end) {
        return this.at(this.makePosAnnot(begin, end));
    }

    private String maybeMsgPosition() {
        StringBuilder sb = new StringBuilder();
        if (this.startingFs != null) {
            if (this.startingFs instanceof Annotation) {
                Annotation a = (Annotation)this.startingFs;
                sb.append(" at position begin: ").append(a.getBegin()).append(", end: ").append(a.getEnd());
            } else {
                sb.append(" at moveTo position given by Feature Structure:\n");
                this.startingFs.prettyPrint(2, 2, sb, false);
                sb.append("\n ");
            }
        }
        if (this.shift != 0) {
            sb.append(" shifted by: ").append(this.shift);
        }
        return sb.toString();
    }

    private void prepareTerminalOp() {
        boolean isUseAnnotationIndex;
        if (this.boundsUse == null) {
            this.boundsUse = Subiterator.BoundsUse.notBounded;
        }
        this.maybeValidateAltSource();
        boolean bl = isUseAnnotationIndex = this.index != null && this.index instanceof AnnotationIndex || this.isNonOverlapping || this.isTypePriority || this.isIncludeAnnotBeyondBounds || this.boundsUse != Subiterator.BoundsUse.notBounded || this.isFollowing || this.isPreceding;
        if (isUseAnnotationIndex) {
            this.forceAnnotationIndex();
        }
        if (this.ti == null) {
            if (this.index != null) {
                this.ti = (TypeImpl)this.index.getType();
            }
        } else if (this.index != null) {
            if (((TypeImpl)this.index.getType()).subsumes(this.ti)) {
                this.index = this.index.getSubIndex(this.ti);
            }
        } else if (this.ti.isAnnotationType() && !this.isAltSource) {
            this.forceAnnotationIndex();
        }
        if (isUseAnnotationIndex && null == this.ti) {
            this.ti = (TypeImpl)this.view.getAnnotationType();
        }
        if (this.ti == null) {
            this.ti = this.view.getTypeSystemImpl().getTopType();
        }
        if (this.boundsUse == Subiterator.BoundsUse.covering) {
            this.isIncludeAnnotBeyondBounds = true;
        }
        boolean orderingNeeded = !this.isUnordered || this.shift != 0 || this.boundsUse != Subiterator.BoundsUse.notBounded || this.isFollowing || this.isPreceding;
        boolean bl2 = this.isUnordered = !orderingNeeded;
        if ((this.isFollowing || this.isPreceding || this.boundsUse != Subiterator.BoundsUse.notBounded) && this.shift < 0) {
            this.shift = 0;
        }
    }

    private void maybeValidateAltSource() {
        if (!this.isAltSource) {
            return;
        }
        if (this.index != null || this.boundsUse != Subiterator.BoundsUse.notBounded || this.isAllViews || this.isFollowing || this.isPreceding || this.startingFs != null) {
            throw new CASRuntimeException("SELECT_ALT_SRC_INVALID", new Object[0]);
        }
    }

    private void incr(FSIterator<T> it) {
        it.moveToNext();
    }

    @Override
    public FSIterator<T> fsIterator() {
        if (this.isFollowing && this.isBackwards) {
            this.isBackwards = false;
            return this.make_or_copy_snapshot(this.fsIterator1(), false);
        }
        if (this.isPreceding) {
            boolean bkwd = this.isBackwards;
            this.isBackwards = true;
            return this.make_or_copy_snapshot(this.fsIterator1(), bkwd);
        }
        return this.fsIterator1();
    }

    private LowLevelIterator<T> make_or_copy_snapshot(LowLevelIterator<T> baseIterator, boolean bkwd) {
        FeatureStructure[] a = this.asArray(baseIterator, FeatureStructure.class);
        LowLevelIterator it = new FsIterator_subtypes_snapshot(a, this.index, false, baseIterator.getComparator());
        if (!bkwd) {
            it = new FsIterator_backwards(it);
        }
        return this.limit == -1 ? it : new FsIterator_limited(it, this.limit);
    }

    private LowLevelIterator<T> fsIterator1() {
        this.prepareTerminalOp();
        SelectFSIterator it = new SelectFSIterator(() -> {
            LowLevelIterator<T> baseIt = this.isAllViews ? this.createFsIterator_for_all_views() : this.plainFsIterator(this.index, this.view);
            baseIt = this.maybeWrapBackwards(baseIt);
            this.maybePosition(baseIt);
            this.maybeShift(baseIt);
            return baseIt;
        });
        return this.maybeLimit(it);
    }

    private FsIterator_aggregation_common<T> createFsIterator_for_all_views() {
        int nbrViews = this.view.getNumberOfViews();
        LowLevelIterator[] ita = new LowLevelIterator[nbrViews];
        for (int i = 1; i <= nbrViews; ++i) {
            CASImpl v = i == 1 ? this.view.getInitialView() : (CASImpl)this.view.getView(i);
            LowLevelIndex<T> index_local = this.getIndexForView(v);
            ita[i - 1] = this.plainFsIterator(index_local, v);
        }
        return new FsIterator_aggregation_common(ita, null, null);
    }

    private LowLevelIndex<T> getIndexForView(CASImpl v) {
        if (this.index == null) {
            return null;
        }
        FSIndexRepositoryImpl ir = (FSIndexRepositoryImpl)v.getIndexRepository();
        if (this.index instanceof FsIndex_iicp) {
            FsIndex_iicp idx = (FsIndex_iicp)this.index;
            return ir.getIndexBySpec(idx.getTypeCode(), idx.getIndexingStrategy(), idx.getComparatorImplForIndexSpecs());
        }
        FsIndex_singletype idx = (FsIndex_singletype)this.index;
        return ir.getIndexBySpec(idx.getTypeCode(), idx.getIndexingStrategy(), idx.getComparatorImplForIndexSpecs());
    }

    private LowLevelIterator<T> plainFsIterator(LowLevelIndex<T> idx, CASImpl v) {
        FsIndex_annotation ai;
        if (null == idx) {
            if (this.isAltSource) {
                return this.altSourceIterator();
            }
            return v.indexRepository.getAllIndexedFS(this.ti);
        }
        boolean isSortedIndex = idx.getIndexingStrategy() == 0;
        boolean isAnnotationIndex = idx instanceof AnnotationIndex;
        FsIndex_annotation fsIndex_annotation = ai = isAnnotationIndex ? (FsIndex_annotation)idx : null;
        if (this.boundsUse == Subiterator.BoundsUse.notBounded && (!this.isFollowing && !this.isPreceding || !this.isNonOverlapping && (this.isFollowing || this.isPreceding))) {
            int startingFSEnd;
            int startingFSStart;
            LowLevelIterator<T> it;
            if (this.noResult) {
                return LowLevelIterator.FS_ITERATOR_LOW_LEVEL_EMPTY;
            }
            if (!isSortedIndex) {
                return idx.iterator();
            }
            LowLevelIterator<T> lowLevelIterator = isAnnotationIndex ? ai.iterator(!this.isNonOverlapping, false, this.isUnordered, !this.isTypePriority) : (it = idx.iterator(this.isUnordered, !this.isTypePriority));
            if (this.isPreceding) {
                startingFSStart = ((Annotation)this.startingFs).getBegin();
                startingFSEnd = ((Annotation)this.startingFs).getEnd();
                it = new FilteredIterator<T>(it, fs -> fs._id() != this.startingFs._id && AnnotationPredicates.preceding((Annotation)fs, startingFSStart, startingFSEnd));
            }
            if (this.isFollowing) {
                startingFSStart = ((Annotation)this.startingFs).getBegin();
                startingFSEnd = ((Annotation)this.startingFs).getEnd();
                it = new FilteredIterator<T>(it, fs -> fs._id() != this.startingFs._id && AnnotationPredicates.following((Annotation)fs, startingFSStart, startingFSEnd));
            }
            return it;
        }
        Annotation secondaryBoundingFs = null;
        boolean isIncludeZeroWidthAtBegin = true;
        boolean isIncludeZeroWidthAtEnd = true;
        if (this.isPreceding) {
            this.isIncludeAnnotBeyondBounds = false;
            this.boundsUse = Subiterator.BoundsUse.coveredBy;
            this.boundingFs = this.makePosAnnot(0, ((Annotation)this.startingFs).getBegin());
            secondaryBoundingFs = (Annotation)this.startingFs;
            isIncludeZeroWidthAtEnd = true;
        }
        if (this.isFollowing) {
            this.isIncludeAnnotBeyondBounds = false;
            this.boundsUse = Subiterator.BoundsUse.coveredBy;
            this.boundingFs = this.makePosAnnot(((Annotation)this.startingFs).getEnd(), Integer.MAX_VALUE);
            secondaryBoundingFs = (Annotation)this.startingFs;
            isIncludeZeroWidthAtEnd = true;
        }
        return new Subiterator<T>(idx.iterator(this.isUnordered, !this.isTypePriority), this.boundingFs, secondaryBoundingFs, !this.isNonOverlapping, !this.isIncludeAnnotBeyondBounds, this.boundsUse, this.isTypePriority, this.isSkipSameBeginEndType, false, isIncludeZeroWidthAtBegin, isIncludeZeroWidthAtEnd);
    }

    private LowLevelIterator<T> maybeWrapBackwards(LowLevelIterator<T> it) {
        if (this.isBackwards) {
            it = new FsIterator_backwards<T>(it);
        }
        return it;
    }

    private LowLevelIterator<T> altSourceIterator() {
        FeatureStructure[] filtered;
        if (this.sourceFSList != null) {
            ArrayList filteredItems = new ArrayList();
            FSList fsl = this.sourceFSList;
            while (!(fsl instanceof EmptyFSList)) {
                NonEmptyFSList nefsl = (NonEmptyFSList)fsl;
                Object item = nefsl.getHead();
                if ((this.isNullOK || null != item) && this.ti.subsumes((TypeImpl)item.getType())) {
                    filteredItems.add(item);
                }
                fsl = nefsl.getTail();
            }
            filtered = filteredItems.toArray((FeatureStructure[])Array.newInstance(FeatureStructure.class, filteredItems.size()));
        } else {
            boolean noTypeFilter;
            boolean bl = noTypeFilter = this.ti == this.view.getTypeSystemImpl().topType;
            if (!this.isNullOK && noTypeFilter) {
                return new FsIterator_subtypes_snapshot(this.sourceFSArray, null, true, null);
            }
            ArrayList<FeatureStructure> filteredItems = new ArrayList<FeatureStructure>();
            boolean noNullsWereFiltered = true;
            for (FeatureStructure item : this.sourceFSArray) {
                if (!this.isNullOK && null == item) {
                    noNullsWereFiltered = false;
                    continue;
                }
                if (!noTypeFilter && !this.ti.subsumes((TypeImpl)item.getType())) continue;
                filteredItems.add(item);
            }
            if (noTypeFilter && !noNullsWereFiltered) {
                return new FsIterator_subtypes_snapshot(this.sourceFSArray, null, true, null);
            }
            filtered = filteredItems.toArray((FeatureStructure[])Array.newInstance(FeatureStructure.class, filteredItems.size()));
        }
        return new FsIterator_subtypes_snapshot(filtered, null, true, null);
    }

    @Override
    public Iterator<T> iterator() {
        return this.fsIterator();
    }

    @Override
    public ArrayList<T> asList() {
        return this.asArrayList((LowLevelIterator)this.fsIterator());
    }

    private ArrayList<T> asArrayList(LowLevelIterator<T> it) {
        ArrayList al = new ArrayList();
        it.getArrayList(al);
        return al;
    }

    @Override
    public T[] asArray(Class<? super T> clazz) {
        return this.asArray((LowLevelIterator)this.fsIterator(), clazz);
    }

    private T[] asArray(LowLevelIterator<T> it, Class<? super T> clazz) {
        ArrayList<FeatureStructure> a = this.asArrayList(it);
        FeatureStructure[] r = (FeatureStructure[])Array.newInstance(clazz, a.size());
        return a.toArray(r);
    }

    private Annotation makePosAnnot(int begin, int end) {
        if (end < begin) {
            throw new IllegalArgumentException("End value must be >= Begin value");
        }
        try (AutoCloseableNoException c = ((CASImpl)this.jcas.getCas()).ll_forceEnableV2IdRefs(false);){
            Annotation annotation = new Annotation(this.jcas, begin, end);
            return annotation;
        }
    }

    @Override
    public Spliterator<T> spliterator() {
        return new Spliterator<T>(){
            private final FSIterator<T> it;
            private final FSIndex<T> localIndex;
            private final Comparator<? super T> comparator;
            private final int characteristics;
            {
                this.it = SelectFSs_impl.this.fsIterator();
                this.localIndex = SelectFSs_impl.this.index;
                this.comparator = this.localIndex != null && this.localIndex.getIndexingStrategy() == 0 ? (Comparator)((Object)this.localIndex) : null;
                int c = 1281;
                if (!SelectFSs_impl.this.isAltSource && SelectFSs_impl.this.boundsUse == Subiterator.BoundsUse.notBounded && !SelectFSs_impl.this.isNonOverlapping) {
                    c |= 0x4040;
                }
                switch (null == this.localIndex ? -1 : this.localIndex.getIndexingStrategy()) {
                    case 0: {
                        c |= 0x14;
                        break;
                    }
                    case 1: {
                        c |= 0x10;
                        break;
                    }
                }
                this.characteristics = c;
            }

            @Override
            public boolean tryAdvance(Consumer<? super T> action) {
                if (this.it.isValid()) {
                    action.accept(this.it.getNvc());
                    SelectFSs_impl.this.incr(this.it);
                    return true;
                }
                return false;
            }

            @Override
            public Spliterator<T> trySplit() {
                return null;
            }

            @Override
            public long estimateSize() {
                return (this.characteristics & 0x40) == 64 && this.localIndex != null ? (long)this.localIndex.size() : Long.MAX_VALUE;
            }

            @Override
            public int characteristics() {
                return this.characteristics;
            }

            @Override
            public Comparator<? super T> getComparator() {
                if (this.comparator != null) {
                    return this.comparator;
                }
                if ((this.characteristics & 4) == 4) {
                    return null;
                }
                throw new IllegalStateException();
            }
        };
    }

    @Override
    public T get() {
        return this.getNullChk();
    }

    private T getNullChk() {
        FSIterator<T> it = this.fsIterator();
        if (it.isValid()) {
            return it.getNvc();
        }
        if (!this.isNullOK) {
            throw new CASRuntimeException("SELECT_GET_NO_INSTANCES", this.ti.getName(), this.maybeMsgPosition());
        }
        return null;
    }

    @Override
    public T single() {
        T v = this.singleOrNull();
        if (v == null && !this.isNullOK) {
            throw new CASRuntimeException("SELECT_GET_NO_INSTANCES", this.ti.getName(), this.maybeMsgPosition());
        }
        return v;
    }

    @Override
    public T singleOrNull() {
        FSIterator<T> it = this.fsIterator();
        if (it.isValid()) {
            T v = it.getNvc();
            if (this.shift >= 0) {
                it.moveToNext();
            } else {
                it.moveToPrevious();
            }
            if (it.isValid()) {
                throw new CASRuntimeException("SELECT_GET_TOO_MANY_INSTANCES", this.ti.getName(), this.maybeMsgPosition());
            }
            return v;
        }
        return null;
    }

    @Override
    public T get(int offset) {
        this.shift = offset;
        return this.getNullChk();
    }

    @Override
    public T single(int offset) {
        this.shift = offset;
        return this.single();
    }

    @Override
    public T singleOrNull(int offset) {
        this.shift = offset;
        return this.singleOrNull();
    }

    @Override
    public T get(TOP fs) {
        this.startAt(fs);
        return this.getNullChk();
    }

    @Override
    public T get(FeatureStructure fs) {
        this.startAt(fs);
        return this.getNullChk();
    }

    @Override
    public T single(TOP fs) {
        this.startAt(fs);
        return this.single();
    }

    @Override
    public T single(FeatureStructure fs) {
        this.startAt(fs);
        return this.single();
    }

    @Override
    public T singleOrNull(TOP fs) {
        this.startAt(fs);
        return this.singleOrNull();
    }

    @Override
    public T singleOrNull(FeatureStructure fs) {
        this.startAt(fs);
        return this.singleOrNull();
    }

    @Override
    public T get(TOP fs, int offset) {
        this.startAt(fs, offset);
        return this.getNullChk();
    }

    @Override
    public T get(FeatureStructure fs, int offset) {
        this.startAt(fs, offset);
        return this.getNullChk();
    }

    @Override
    public T single(TOP fs, int offset) {
        this.startAt(fs, offset);
        return this.single();
    }

    @Override
    public T single(FeatureStructure fs, int offset) {
        this.startAt(fs, offset);
        return this.single();
    }

    @Override
    public T singleOrNull(TOP fs, int offset) {
        this.startAt(fs, offset);
        return this.singleOrNull();
    }

    @Override
    public T singleOrNull(FeatureStructure fs, int offset) {
        this.startAt(fs, offset);
        return this.singleOrNull();
    }

    @Override
    public T get(int begin, int end) {
        this.startAt(begin, end);
        return this.getNullChk();
    }

    @Override
    public T single(int begin, int end) {
        this.startAt(begin, end);
        return this.single();
    }

    @Override
    public T singleOrNull(int begin, int end) {
        this.startAt(begin, end);
        return this.singleOrNull();
    }

    @Override
    public T get(int begin, int end, int offset) {
        this.startAt(begin, end, offset);
        return this.getNullChk();
    }

    @Override
    public T single(int begin, int end, int offset) {
        this.startAt(begin, end, offset);
        return this.single();
    }

    @Override
    public T singleOrNull(int begin, int end, int offset) {
        this.startAt(begin, end, offset);
        return this.singleOrNull();
    }

    private FSIterator<T> maybePosition(FSIterator<T> it) {
        if (!it.isValid() || this.startingFs == null || this.boundsUse != Subiterator.BoundsUse.notBounded) {
            return it;
        }
        if (this.isFollowing) {
            Annotation start = (Annotation)this.startingFs;
            if (start.getBegin() == start.getEnd()) {
                it.moveTo(this.makePosAnnot(start.getBegin(), Integer.MAX_VALUE));
            } else {
                int aBegin;
                it.moveTo(this.startingFs);
                int begin = ((Annotation)this.startingFs).getBegin();
                int end = ((Annotation)this.startingFs).getEnd();
                while (it.isValid() && ((aBegin = ((Annotation)it.get()).getBegin()) < end || aBegin == begin)) {
                    it.moveToNext();
                }
            }
        } else if (this.isPreceding) {
            Annotation start = (Annotation)this.startingFs;
            it.moveTo(this.makePosAnnot(start.getBegin(), start.getBegin()));
            int begin = start.getBegin();
            while (it.isValid() && ((Annotation)it.get()).getEnd() > begin) {
                it.moveToPrevious();
            }
        } else {
            it.moveTo(this.startingFs);
        }
        return it;
    }

    private FSIterator<T> maybeShift(FSIterator<T> it) {
        if (this.shift != 0) {
            int ps = Math.abs(this.shift);
            for (int i = 0; i < ps; ++i) {
                if (this.shift < 0) {
                    it.moveToPrevious();
                    continue;
                }
                it.moveToNext();
            }
        }
        return it;
    }

    private LowLevelIterator<T> maybeLimit(LowLevelIterator<T> it) {
        return this.limit == -1 ? it : new FsIterator_limited(it, this.limit);
    }

    @Override
    public SelectFSs<T> following(Annotation fs) {
        return this.following(fs, 0);
    }

    @Override
    public SelectFSs<T> following(int position) {
        return this.following(position, 0);
    }

    @Override
    public SelectFSs<T> following(Annotation fs, int offset) {
        return this.commonFollowing(fs, offset);
    }

    @Override
    public SelectFSs<T> following(int position, int offset) {
        return this.commonFollowing(this.makePosAnnot(position, position), offset);
    }

    @Override
    public SelectFSs<T> preceding(Annotation fs) {
        return this.preceding(fs, 0);
    }

    @Override
    public SelectFSs<T> preceding(int position) {
        return this.preceding(position, 0);
    }

    @Override
    public SelectFSs<T> preceding(Annotation annotation, int offset) {
        return this.commonPreceding(annotation, offset);
    }

    @Override
    public SelectFSs<T> preceding(int position, int offset) {
        return this.commonPreceding(this.makePosAnnot(position, Integer.MAX_VALUE), offset);
    }

    private SelectFSs<T> commonFollowing(Annotation annotation, int offset) {
        this.startingFs = annotation;
        this.shift = offset;
        this.isFollowing = true;
        return this;
    }

    private SelectFSs<T> commonPreceding(Annotation annotation, int offset) {
        this.startingFs = annotation;
        this.shift = offset;
        this.isPreceding = true;
        return this;
    }

    private void forceAnnotationIndex() {
        if (this.index == null) {
            this.index = (LowLevelIndex)((Object)(this.ti == null ? this.view.getAnnotationIndex() : this.view.getAnnotationIndex(this.ti)));
        } else if (!(this.index instanceof AnnotationIndex)) {
            throw new CASRuntimeException("ANNOTATION_INDEX_REQUIRED", this.index);
        }
    }

    private Stream<T> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    @Override
    public Stream<T> filter(Predicate<? super T> predicate) {
        return this.stream().filter(predicate);
    }

    @Override
    public <R> Stream<R> map(Function<? super T, ? extends R> mapper) {
        return this.stream().map(mapper);
    }

    @Override
    public IntStream mapToInt(ToIntFunction<? super T> mapper) {
        return this.stream().mapToInt(mapper);
    }

    @Override
    public LongStream mapToLong(ToLongFunction<? super T> mapper) {
        return this.stream().mapToLong(mapper);
    }

    @Override
    public DoubleStream mapToDouble(ToDoubleFunction<? super T> mapper) {
        return this.stream().mapToDouble(mapper);
    }

    @Override
    public <R> Stream<R> flatMap(Function<? super T, ? extends Stream<? extends R>> mapper) {
        return this.stream().flatMap(mapper);
    }

    @Override
    public IntStream flatMapToInt(Function<? super T, ? extends IntStream> mapper) {
        return this.stream().flatMapToInt(mapper);
    }

    @Override
    public LongStream flatMapToLong(Function<? super T, ? extends LongStream> mapper) {
        return this.stream().flatMapToLong(mapper);
    }

    @Override
    public DoubleStream flatMapToDouble(Function<? super T, ? extends DoubleStream> mapper) {
        return this.stream().flatMapToDouble(mapper);
    }

    @Override
    public Stream<T> distinct() {
        return this.stream().distinct();
    }

    @Override
    public Stream<T> sorted() {
        return this.stream().sorted();
    }

    @Override
    public Stream<T> sorted(Comparator<? super T> comparator) {
        return this.stream().sorted(comparator);
    }

    @Override
    public Stream<T> peek(Consumer<? super T> action) {
        return this.stream().peek(action);
    }

    @Override
    public Stream<T> limit(long maxSize) {
        return this.stream().limit(maxSize);
    }

    @Override
    public Stream<T> skip(long n) {
        return this.stream().skip(n);
    }

    @Override
    public void forEach(Consumer<? super T> action) {
        this.stream().forEach(action);
    }

    @Override
    public void forEachOrdered(Consumer<? super T> action) {
        this.stream().forEachOrdered(action);
    }

    @Override
    public Object[] toArray() {
        return this.stream().toArray();
    }

    @Override
    public <A> A[] toArray(IntFunction<A[]> generator) {
        return this.stream().toArray(generator);
    }

    @Override
    public T reduce(T identity, BinaryOperator<T> accumulator) {
        return (T)((FeatureStructure)this.stream().reduce(identity, accumulator));
    }

    @Override
    public Optional<T> reduce(BinaryOperator<T> accumulator) {
        return this.stream().reduce(accumulator);
    }

    @Override
    public <U> U reduce(U identity, BiFunction<U, ? super T, U> accumulator, BinaryOperator<U> combiner) {
        return this.stream().reduce(identity, accumulator, combiner);
    }

    @Override
    public <R> R collect(Supplier<R> supplier, BiConsumer<R, ? super T> accumulator, BiConsumer<R, R> combiner) {
        return this.stream().collect(supplier, accumulator, combiner);
    }

    @Override
    public <R, A> R collect(Collector<? super T, A, R> collector) {
        return this.stream().collect(collector);
    }

    @Override
    public Optional<T> min(Comparator<? super T> comparator) {
        return this.stream().min(comparator);
    }

    @Override
    public Optional<T> max(Comparator<? super T> comparator) {
        return this.stream().max(comparator);
    }

    @Override
    public long count() {
        return this.stream().count();
    }

    @Override
    public boolean anyMatch(Predicate<? super T> predicate) {
        return this.stream().anyMatch(predicate);
    }

    @Override
    public boolean allMatch(Predicate<? super T> predicate) {
        return this.stream().allMatch(predicate);
    }

    @Override
    public boolean noneMatch(Predicate<? super T> predicate) {
        return this.stream().noneMatch(predicate);
    }

    @Override
    public Optional<T> findFirst() {
        return this.stream().findFirst();
    }

    @Override
    public Optional<T> findAny() {
        return this.stream().findAny();
    }

    @Override
    public boolean isParallel() {
        return this.stream().isParallel();
    }

    @Override
    public Stream<T> sequential() {
        return (Stream)this.stream().sequential();
    }

    @Override
    public Stream<T> parallel() {
        return (Stream)this.stream().parallel();
    }

    @Override
    public Stream<T> onClose(Runnable closeHandler) {
        return (Stream)this.stream().onClose(closeHandler);
    }

    @Override
    public void close() {
        this.stream().close();
    }

    @Override
    public Stream<T> unordered() {
        return (Stream)this.stream().unordered();
    }

    @Override
    public boolean isEmpty() {
        if (this.limit == 0) {
            return true;
        }
        return this.fsIterator().size() == 0;
    }

    private final class SelectFSIterator
    implements LowLevelIterator<T> {
        private Supplier<LowLevelIterator<T>> iteratorSupplier;
        private LowLevelIterator<T> it;

        private SelectFSIterator(Supplier<LowLevelIterator<T>> aIteratorSupplier) {
            this.iteratorSupplier = aIteratorSupplier;
            this.it = this.iteratorSupplier.get();
        }

        @Override
        public boolean isValid() {
            return this.it.isValid();
        }

        @Override
        public T getNvc() {
            return this.it.getNvc();
        }

        @Override
        public void moveToNextNvc() {
            this.it.moveToNextNvc();
        }

        @Override
        public void moveToPreviousNvc() {
            this.it.moveToPreviousNvc();
        }

        @Override
        public void moveToFirst() {
            this.it = this.iteratorSupplier.get();
        }

        @Override
        public void moveToLast() {
            this.it.moveToLast();
        }

        @Override
        public void moveTo(FeatureStructure aFs) {
            this.it.moveTo(aFs);
        }

        @Override
        public FSIterator<T> copy() {
            return this.it.copy();
        }

        @Override
        public int ll_indexSizeMaybeNotCurrent() {
            return this.it.ll_indexSizeMaybeNotCurrent();
        }

        @Override
        public LowLevelIndex<T> ll_getIndex() {
            return this.it.ll_getIndex();
        }

        @Override
        public int ll_maxAnnotSpan() {
            return this.it.ll_maxAnnotSpan();
        }

        @Override
        public boolean isIndexesHaveBeenUpdated() {
            return this.it.isIndexesHaveBeenUpdated();
        }

        @Override
        public boolean maybeReinitIterator() {
            return this.it.maybeReinitIterator();
        }

        @Override
        public void moveToFirstNoReinit() {
            this.moveToFirst();
        }

        @Override
        public void moveToLastNoReinit() {
            this.it.moveToLastNoReinit();
        }

        @Override
        public void moveToNoReinit(FeatureStructure aFs) {
            this.it.moveToNoReinit(aFs);
        }

        @Override
        public Comparator<TOP> getComparator() {
            return this.it.getComparator();
        }
    }
}

