/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.coordinator;

import com.google.protobuf.Empty;
import io.grpc.Context;
import io.grpc.Status;
import io.grpc.stub.StreamObserver;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.stream.Collectors;
import org.apache.uniffle.common.PartitionRange;
import org.apache.uniffle.common.ReconfigurableRegistry;
import org.apache.uniffle.common.RemoteStorageInfo;
import org.apache.uniffle.common.ServerStatus;
import org.apache.uniffle.common.rpc.ClientContextServerInterceptor;
import org.apache.uniffle.common.storage.StorageInfoUtils;
import org.apache.uniffle.coordinator.AccessManager;
import org.apache.uniffle.coordinator.CoordinatorConf;
import org.apache.uniffle.coordinator.CoordinatorServer;
import org.apache.uniffle.coordinator.ServerNode;
import org.apache.uniffle.coordinator.access.AccessCheckResult;
import org.apache.uniffle.coordinator.access.AccessInfo;
import org.apache.uniffle.coordinator.audit.CoordinatorRpcAuditContext;
import org.apache.uniffle.coordinator.conf.RssClientConfFetchInfo;
import org.apache.uniffle.coordinator.strategy.assignment.PartitionRangeAssignment;
import org.apache.uniffle.coordinator.util.CoordinatorUtils;
import org.apache.uniffle.proto.CoordinatorServerGrpc;
import org.apache.uniffle.proto.RssProtos;
import org.apache.uniffle.shaded.guava.collect.Sets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoordinatorGrpcService
extends CoordinatorServerGrpc.CoordinatorServerImplBase {
    private static final Logger LOG = LoggerFactory.getLogger(CoordinatorGrpcService.class);
    private static final Logger AUDIT_LOGGER = LoggerFactory.getLogger((String)"COORDINATOR_RPC_AUDIT_LOG");
    private final CoordinatorServer coordinatorServer;
    private boolean isRpcAuditLogEnabled;
    private List<String> rpcAuditExcludeOpList;

    public CoordinatorGrpcService(CoordinatorServer coordinatorServer) {
        this.coordinatorServer = coordinatorServer;
        this.isRpcAuditLogEnabled = (Boolean)coordinatorServer.getCoordinatorConf().getReconfigurableConf(CoordinatorConf.COORDINATOR_RPC_AUDIT_LOG_ENABLED).get();
        this.rpcAuditExcludeOpList = (List)coordinatorServer.getCoordinatorConf().getReconfigurableConf(CoordinatorConf.COORDINATOR_RPC_AUDIT_LOG_EXCLUDE_LIST).get();
        ReconfigurableRegistry.register(Sets.newHashSet(CoordinatorConf.COORDINATOR_RPC_AUDIT_LOG_ENABLED.key(), CoordinatorConf.COORDINATOR_RPC_AUDIT_LOG_EXCLUDE_LIST.key()), (conf, changedProperties) -> {
            if (changedProperties == null || conf == null) {
                return;
            }
            if (changedProperties.contains(CoordinatorConf.COORDINATOR_RPC_AUDIT_LOG_ENABLED.key())) {
                this.isRpcAuditLogEnabled = conf.getBoolean(CoordinatorConf.COORDINATOR_RPC_AUDIT_LOG_ENABLED);
            }
            if (changedProperties.contains(CoordinatorConf.COORDINATOR_RPC_AUDIT_LOG_EXCLUDE_LIST.key())) {
                this.rpcAuditExcludeOpList = (List)conf.get(CoordinatorConf.COORDINATOR_RPC_AUDIT_LOG_EXCLUDE_LIST);
            }
        });
    }

    public void getShuffleServerList(Empty request, StreamObserver<RssProtos.GetShuffleServerListResponse> responseObserver) {
        RssProtos.GetShuffleServerListResponse response = RssProtos.GetShuffleServerListResponse.newBuilder().addAllServers((Iterable)this.coordinatorServer.getClusterManager().list().stream().map(ServerNode::convertToGrpcProto).collect(Collectors.toList())).build();
        responseObserver.onNext((Object)response);
        responseObserver.onCompleted();
    }

    public void getShuffleServerNum(Empty request, StreamObserver<RssProtos.GetShuffleServerNumResponse> responseObserver) {
        int num = this.coordinatorServer.getClusterManager().getNodesNum();
        RssProtos.GetShuffleServerNumResponse response = RssProtos.GetShuffleServerNumResponse.newBuilder().setNum(num).build();
        responseObserver.onNext((Object)response);
        responseObserver.onCompleted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getShuffleAssignments(RssProtos.GetShuffleServerRequest request, StreamObserver<RssProtos.GetShuffleAssignmentsResponse> responseObserver) {
        try (CoordinatorRpcAuditContext auditContext = this.createAuditContext("getShuffleAssignments");){
            String appId = request.getApplicationId();
            int shuffleId = request.getShuffleId();
            int partitionNum = request.getPartitionNum();
            int partitionNumPerRange = request.getPartitionNumPerRange();
            int replica = request.getDataReplica();
            HashSet<String> requiredTags = Sets.newHashSet(request.getRequireTagsList());
            int requiredShuffleServerNumber = request.getAssignmentShuffleServerNumber();
            int estimateTaskConcurrency = request.getEstimateTaskConcurrency();
            HashSet<String> faultyServerIds = new HashSet<String>((Collection<String>)request.getFaultyServerIdsList());
            auditContext.withAppId(appId);
            auditContext.withArgs(String.format("shuffleId=%d, partitionNum=%d, partitionNumPerRange=%d, replica=%d, requiredTags=%s, requiredShuffleServerNumber=%d, faultyServerIds=%s", shuffleId, partitionNum, partitionNumPerRange, replica, requiredTags, requiredShuffleServerNumber, faultyServerIds));
            LOG.info("Request of getShuffleAssignments for appId[{}], shuffleId[{}], partitionNum[{}], partitionNumPerRange[{}], replica[{}], requiredTags[{}], requiredShuffleServerNumber[{}], faultyServerIds[{}]", new Object[]{appId, shuffleId, partitionNum, partitionNumPerRange, replica, requiredTags, requiredShuffleServerNumber, faultyServerIds.size()});
            RssProtos.GetShuffleAssignmentsResponse response = null;
            try {
                if (!this.coordinatorServer.getClusterManager().isReadyForServe()) {
                    throw new Exception("Coordinator is out-of-service when in starting.");
                }
                PartitionRangeAssignment pra = this.coordinatorServer.getAssignmentStrategy().assign(partitionNum, partitionNumPerRange, replica, requiredTags, requiredShuffleServerNumber, estimateTaskConcurrency, faultyServerIds);
                response = CoordinatorUtils.toGetShuffleAssignmentsResponse(pra);
                this.logAssignmentResult(appId, shuffleId, pra);
                responseObserver.onNext((Object)response);
            }
            catch (Exception e) {
                LOG.error("Errors on getting shuffle assignments for app: {}, shuffleId: {}, partitionNum: {}, partitionNumPerRange: {}, replica: {}, requiredTags: {}", new Object[]{appId, shuffleId, partitionNum, partitionNumPerRange, replica, requiredTags, e});
                response = RssProtos.GetShuffleAssignmentsResponse.newBuilder().setStatus(RssProtos.StatusCode.INTERNAL_ERROR).setRetMsg(e.getMessage()).build();
                responseObserver.onNext((Object)response);
            }
            finally {
                if (response != null) {
                    auditContext.withStatusCode(response.getStatus());
                }
                responseObserver.onCompleted();
            }
        }
    }

    public void heartbeat(RssProtos.ShuffleServerHeartBeatRequest request, StreamObserver<RssProtos.ShuffleServerHeartBeatResponse> responseObserver) {
        try (CoordinatorRpcAuditContext auditContext = this.createAuditContext("heartbeat");){
            ServerNode serverNode = this.toServerNode(request);
            auditContext.withArgs("serverNode=" + serverNode.getId());
            this.coordinatorServer.getClusterManager().add(serverNode);
            RssProtos.ShuffleServerHeartBeatResponse response = RssProtos.ShuffleServerHeartBeatResponse.newBuilder().setRetMsg("").setStatus(RssProtos.StatusCode.SUCCESS).build();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Got heartbeat from {}", (Object)serverNode);
            }
            auditContext.withStatusCode(response.getStatus());
            responseObserver.onNext((Object)response);
            responseObserver.onCompleted();
        }
    }

    public void checkServiceAvailable(Empty request, StreamObserver<RssProtos.CheckServiceAvailableResponse> responseObserver) {
        try (CoordinatorRpcAuditContext auditContext = this.createAuditContext("checkServiceAvailable");){
            RssProtos.CheckServiceAvailableResponse response = RssProtos.CheckServiceAvailableResponse.newBuilder().setAvailable(this.coordinatorServer.getClusterManager().getNodesNum() > 0).build();
            auditContext.withStatusCode(RssProtos.StatusCode.SUCCESS);
            responseObserver.onNext((Object)response);
            responseObserver.onCompleted();
        }
    }

    public void reportClientOperation(RssProtos.ReportShuffleClientOpRequest request, StreamObserver<RssProtos.ReportShuffleClientOpResponse> responseObserver) {
        try (CoordinatorRpcAuditContext auditContext = this.createAuditContext("reportClientOperation");){
            String clientHost = request.getClientHost();
            int clientPort = request.getClientPort();
            RssProtos.ShuffleServerId shuffleServer = request.getServer();
            String operation = request.getOperation();
            auditContext.withArgs(String.format("%s:%s->%s->%s", clientHost, clientPort, operation, shuffleServer));
            LOG.info(clientHost + ":" + clientPort + "->" + operation + "->" + shuffleServer);
            RssProtos.ReportShuffleClientOpResponse response = RssProtos.ReportShuffleClientOpResponse.newBuilder().setRetMsg("").setStatus(RssProtos.StatusCode.SUCCESS).build();
            auditContext.withStatusCode(response.getStatus());
            responseObserver.onNext((Object)response);
            responseObserver.onCompleted();
        }
    }

    public void appHeartbeat(RssProtos.AppHeartBeatRequest request, StreamObserver<RssProtos.AppHeartBeatResponse> responseObserver) {
        try (CoordinatorRpcAuditContext auditContext = this.createAuditContext("appHeartbeat");){
            String appId = request.getAppId();
            auditContext.withAppId(appId);
            this.coordinatorServer.getApplicationManager().refreshAppId(appId);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Got heartbeat from application: {}", (Object)appId);
            }
            RssProtos.AppHeartBeatResponse response = RssProtos.AppHeartBeatResponse.newBuilder().setRetMsg("").setStatus(RssProtos.StatusCode.SUCCESS).build();
            if (Context.current().isCancelled()) {
                responseObserver.onError((Throwable)Status.CANCELLED.withDescription("Cancelled by client").asRuntimeException());
                auditContext.withStatusCode("CANCELLED");
                LOG.warn("Cancelled by client {} for after deadline.", (Object)appId);
                return;
            }
            auditContext.withStatusCode(response.getStatus());
            responseObserver.onNext((Object)response);
            responseObserver.onCompleted();
        }
    }

    public void registerApplicationInfo(RssProtos.ApplicationInfoRequest request, StreamObserver<RssProtos.ApplicationInfoResponse> responseObserver) {
        try (CoordinatorRpcAuditContext auditContext = this.createAuditContext("registerApplicationInfo");){
            String appId = request.getAppId();
            String user = request.getUser();
            auditContext.withAppId(appId).withArgs("user=" + user);
            this.coordinatorServer.getApplicationManager().registerApplicationInfo(appId, user, request.getVersion(), request.getGitCommitId());
            if (LOG.isDebugEnabled()) {
                LOG.debug("Got a registered application info: {}", (Object)appId);
            }
            RssProtos.ApplicationInfoResponse response = RssProtos.ApplicationInfoResponse.newBuilder().setRetMsg("").setStatus(RssProtos.StatusCode.SUCCESS).build();
            if (Context.current().isCancelled()) {
                responseObserver.onError((Throwable)Status.CANCELLED.withDescription("Cancelled by client").asRuntimeException());
                auditContext.withStatusCode("CANCELLED");
                LOG.warn("Cancelled by client {} for after deadline.", (Object)appId);
                return;
            }
            auditContext.withStatusCode(response.getStatus());
            responseObserver.onNext((Object)response);
            responseObserver.onCompleted();
        }
    }

    public void accessCluster(RssProtos.AccessClusterRequest request, StreamObserver<RssProtos.AccessClusterResponse> responseObserver) {
        try (CoordinatorRpcAuditContext auditContext = this.createAuditContext("accessCluster");){
            RssProtos.StatusCode statusCode = RssProtos.StatusCode.SUCCESS;
            AccessManager accessManager = this.coordinatorServer.getAccessManager();
            AccessInfo accessInfo = new AccessInfo(request.getAccessId(), Sets.newHashSet(request.getTagsList()), request.getExtraPropertiesMap(), request.getUser());
            auditContext.withArgs("accessInfo=" + accessInfo);
            AccessCheckResult result = accessManager.handleAccessRequest(accessInfo);
            if (!result.isSuccess()) {
                statusCode = RssProtos.StatusCode.ACCESS_DENIED;
            }
            RssProtos.AccessClusterResponse response = RssProtos.AccessClusterResponse.newBuilder().setStatus(statusCode).setRetMsg(result.getMsg()).setUuid(result.getUuid()).build();
            if (Context.current().isCancelled()) {
                responseObserver.onError((Throwable)Status.CANCELLED.withDescription("Cancelled by client").asRuntimeException());
                auditContext.withStatusCode("CANCELLED");
                LOG.warn("Cancelled by client {} for after deadline.", (Object)accessInfo);
                return;
            }
            auditContext.withStatusCode(response.getStatus());
            responseObserver.onNext((Object)response);
            responseObserver.onCompleted();
        }
    }

    public void fetchClientConf(Empty empty, StreamObserver<RssProtos.FetchClientConfResponse> responseObserver) {
        try (CoordinatorRpcAuditContext auditContext = this.createAuditContext("fetchClientConf");){
            this.fetchClientConfImpl(RssClientConfFetchInfo.EMPTY_CLIENT_CONF_FETCH_INFO, responseObserver);
            auditContext.withStatusCode(RssProtos.StatusCode.SUCCESS);
        }
    }

    public void fetchClientConfV2(RssProtos.FetchClientConfRequest request, StreamObserver<RssProtos.FetchClientConfResponse> responseObserver) {
        try (CoordinatorRpcAuditContext auditContext = this.createAuditContext("fetchClientConfV2");){
            this.fetchClientConfImpl(RssClientConfFetchInfo.fromProto(request), responseObserver);
            auditContext.withStatusCode(RssProtos.StatusCode.SUCCESS);
        }
    }

    private void fetchClientConfImpl(RssClientConfFetchInfo rssClientConfFetchInfo, StreamObserver<RssProtos.FetchClientConfResponse> responseObserver) {
        RssProtos.FetchClientConfResponse.Builder builder = RssProtos.FetchClientConfResponse.newBuilder().setStatus(RssProtos.StatusCode.SUCCESS);
        boolean dynamicConfEnabled = this.coordinatorServer.getCoordinatorConf().getBoolean(CoordinatorConf.COORDINATOR_DYNAMIC_CLIENT_CONF_ENABLED);
        if (dynamicConfEnabled) {
            Map<String, String> clientConfigs = this.coordinatorServer.getClientConfApplyManager().apply(rssClientConfFetchInfo);
            for (Map.Entry<String, String> kv : clientConfigs.entrySet()) {
                builder.addClientConf(RssProtos.ClientConfItem.newBuilder().setKey(kv.getKey()).setValue(kv.getValue()).build());
            }
        }
        RssProtos.FetchClientConfResponse response = builder.build();
        if (Context.current().isCancelled()) {
            responseObserver.onError((Throwable)Status.CANCELLED.withDescription("Cancelled by client").asRuntimeException());
            LOG.warn("Fetch client conf cancelled by client for after deadline.");
            return;
        }
        responseObserver.onNext((Object)response);
        responseObserver.onCompleted();
    }

    public void fetchRemoteStorage(RssProtos.FetchRemoteStorageRequest request, StreamObserver<RssProtos.FetchRemoteStorageResponse> responseObserver) {
        try (CoordinatorRpcAuditContext auditContext = this.createAuditContext("fetchRemoteStorage");){
            RssProtos.FetchRemoteStorageResponse response;
            RssProtos.StatusCode status = RssProtos.StatusCode.SUCCESS;
            String appId = request.getAppId();
            auditContext.withAppId(appId);
            try {
                RssProtos.RemoteStorage.Builder rsBuilder = RssProtos.RemoteStorage.newBuilder();
                RemoteStorageInfo rsInfo = this.coordinatorServer.getApplicationManager().pickRemoteStorage(appId);
                if (rsInfo == null) {
                    LOG.error("Remote storage of {} do not exist.", (Object)appId);
                } else {
                    rsBuilder.setPath(rsInfo.getPath());
                    for (Map.Entry entry : rsInfo.getConfItems().entrySet()) {
                        rsBuilder.addRemoteStorageConf(RssProtos.RemoteStorageConfItem.newBuilder().setKey((String)entry.getKey()).setValue((String)entry.getValue()).build());
                    }
                }
                response = RssProtos.FetchRemoteStorageResponse.newBuilder().setStatus(status).setRemoteStorage(rsBuilder.build()).build();
            }
            catch (Exception e) {
                status = RssProtos.StatusCode.INTERNAL_ERROR;
                response = RssProtos.FetchRemoteStorageResponse.newBuilder().setStatus(status).build();
                LOG.error("Error happened when get remote storage for appId[{}]", (Object)appId, (Object)e);
            }
            if (Context.current().isCancelled()) {
                responseObserver.onError((Throwable)Status.CANCELLED.withDescription("Cancelled by client").asRuntimeException());
                auditContext.withStatusCode("CANCELLED");
                LOG.warn("Fetch client conf cancelled by client for after deadline.");
                return;
            }
            auditContext.withStatusCode(response.getStatus());
            responseObserver.onNext((Object)response);
            responseObserver.onCompleted();
        }
    }

    private void logAssignmentResult(String appId, int shuffleId, PartitionRangeAssignment pra) {
        SortedMap<PartitionRange, List<ServerNode>> assignments = pra.getAssignments();
        if (assignments != null) {
            HashSet<String> nodeIds = Sets.newHashSet();
            for (Map.Entry<PartitionRange, List<ServerNode>> entry : assignments.entrySet()) {
                for (ServerNode node : entry.getValue()) {
                    nodeIds.add(node.getId());
                }
            }
            if (!nodeIds.isEmpty()) {
                LOG.info("Shuffle Servers of assignment for appId[{}], shuffleId[{}] are {}", new Object[]{appId, shuffleId, nodeIds});
            }
        }
    }

    private ServerNode toServerNode(RssProtos.ShuffleServerHeartBeatRequest request) {
        ServerStatus serverStatus = request.hasStatus() ? ServerStatus.fromProto((RssProtos.ServerStatus)request.getStatus()) : ServerStatus.ACTIVE;
        boolean isHealthy = true;
        if (request.hasIsHealthy()) {
            isHealthy = request.getIsHealthy().getValue();
            serverStatus = isHealthy ? ServerStatus.ACTIVE : ServerStatus.UNHEALTHY;
        }
        return new ServerNode(request.getServerId().getId(), request.getServerId().getIp(), request.getServerId().getPort(), request.getUsedMemory(), request.getPreAllocatedMemory(), request.getAvailableMemory(), request.getEventNumInFlush(), Sets.newHashSet(request.getTagsList()), serverStatus, StorageInfoUtils.fromProto((Map)request.getStorageInfoMap()), request.getServerId().getNettyPort(), request.getServerId().getJettyPort(), request.getStartTimeMs(), request.getVersion(), request.getGitCommitId(), request.getApplicationInfoList(), request.getDisplayMetricsMap());
    }

    private CoordinatorRpcAuditContext createAuditContext(String command) {
        Logger auditLogger = null;
        if (this.isRpcAuditLogEnabled && !this.rpcAuditExcludeOpList.contains(command)) {
            auditLogger = AUDIT_LOGGER;
        }
        CoordinatorRpcAuditContext auditContext = new CoordinatorRpcAuditContext(auditLogger);
        if (auditLogger != null) {
            auditContext.withCommand(command).withFrom(ClientContextServerInterceptor.getIpAddress()).withCreationTimeNs(System.nanoTime());
        }
        return auditContext;
    }
}

