/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.coordinator;

import io.prometheus.client.CollectorRegistry;
import java.util.function.Consumer;
import org.apache.hadoop.conf.Configuration;
import org.apache.uniffle.common.Arguments;
import org.apache.uniffle.common.ReconfigurableConfManager;
import org.apache.uniffle.common.config.RssBaseConf;
import org.apache.uniffle.common.config.RssConf;
import org.apache.uniffle.common.exception.RssException;
import org.apache.uniffle.common.metrics.GRPCMetrics;
import org.apache.uniffle.common.metrics.JvmMetrics;
import org.apache.uniffle.common.metrics.MetricReporter;
import org.apache.uniffle.common.metrics.MetricReporterFactory;
import org.apache.uniffle.common.rpc.ServerInterface;
import org.apache.uniffle.common.security.SecurityConfig;
import org.apache.uniffle.common.security.SecurityContextFactory;
import org.apache.uniffle.common.util.Constants;
import org.apache.uniffle.common.util.RssUtils;
import org.apache.uniffle.common.web.CoalescedCollectorRegistry;
import org.apache.uniffle.common.web.JettyServer;
import org.apache.uniffle.coordinator.AccessManager;
import org.apache.uniffle.coordinator.ApplicationManager;
import org.apache.uniffle.coordinator.ClusterManager;
import org.apache.uniffle.coordinator.ClusterManagerFactory;
import org.apache.uniffle.coordinator.CoordinatorConf;
import org.apache.uniffle.coordinator.CoordinatorFactory;
import org.apache.uniffle.coordinator.conf.DynamicClientConfService;
import org.apache.uniffle.coordinator.conf.RssClientConfApplyManager;
import org.apache.uniffle.coordinator.metric.CoordinatorGrpcMetrics;
import org.apache.uniffle.coordinator.metric.CoordinatorMetrics;
import org.apache.uniffle.coordinator.strategy.assignment.AssignmentStrategy;
import org.apache.uniffle.coordinator.strategy.assignment.AssignmentStrategyFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

public class CoordinatorServer {
    private static final Logger LOG = LoggerFactory.getLogger(CoordinatorServer.class);
    private final CoordinatorConf coordinatorConf;
    private final long startTimeMs = System.currentTimeMillis();
    private JettyServer jettyServer;
    private int jettyPort;
    private ServerInterface server;
    private ClusterManager clusterManager;
    private AssignmentStrategy assignmentStrategy;
    private RssClientConfApplyManager clientConfApplyManager;
    private AccessManager accessManager;
    private ApplicationManager applicationManager;
    private GRPCMetrics grpcMetrics;
    private MetricReporter metricReporter;
    private String id;
    private int rpcListenPort;

    public CoordinatorServer(CoordinatorConf coordinatorConf) throws Exception {
        this.coordinatorConf = coordinatorConf;
        try {
            this.initialization();
        }
        catch (Exception e) {
            LOG.error("Errors on initializing coordinator server.", (Throwable)e);
            throw e;
        }
    }

    public static void main(String[] args) throws Exception {
        Arguments arguments = new Arguments();
        CommandLine commandLine = new CommandLine((Object)arguments);
        commandLine.parseArgs(args);
        String configFile = arguments.getConfigFile();
        LOG.info("Start to init coordinator server using config {}", (Object)configFile);
        CoordinatorConf coordinatorConf = new CoordinatorConf(configFile);
        ReconfigurableConfManager.init((RssConf)coordinatorConf, (String)configFile);
        CoordinatorServer coordinatorServer = new CoordinatorServer(coordinatorConf);
        coordinatorServer.start();
        coordinatorServer.blockUntilShutdown();
    }

    public void start() throws Exception {
        LOG.info("{} version: {}", (Object)this.getClass().getSimpleName(), (Object)Constants.VERSION_AND_REVISION_SHORT);
        this.jettyPort = this.jettyServer.start();
        this.rpcListenPort = this.server.start();
        if (this.metricReporter != null) {
            this.metricReporter.start();
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                LOG.info("*** shutting down gRPC server since JVM is shutting down");
                try {
                    CoordinatorServer.this.stopServer();
                }
                catch (Exception e) {
                    LOG.error(e.getMessage());
                }
                LOG.info("*** server shut down");
            }
        });
    }

    public void stopServer() throws Exception {
        if (this.jettyServer != null) {
            this.jettyServer.stop();
        }
        if (this.applicationManager != null) {
            this.applicationManager.close();
        }
        if (this.clusterManager != null) {
            this.clusterManager.close();
        }
        if (this.accessManager != null) {
            this.accessManager.close();
        }
        if (this.clientConfApplyManager != null) {
            this.clientConfApplyManager.close();
        }
        if (this.metricReporter != null) {
            this.metricReporter.stop();
            LOG.info("Metric Reporter Stopped!");
        }
        SecurityContextFactory.get().getSecurityContext().close();
        this.server.stop();
    }

    private void initialization() throws Exception {
        String ip = RssUtils.getHostIp();
        if (ip == null) {
            throw new RssException("Couldn't acquire host Ip");
        }
        int port = this.coordinatorConf.getInteger(CoordinatorConf.RPC_SERVER_PORT);
        this.id = ip + "-" + port;
        LOG.info("Start to initialize coordinator {}", (Object)this.id);
        this.registerMetrics();
        this.coordinatorConf.setString("coordinator.id", this.id);
        this.applicationManager = new ApplicationManager(this.coordinatorConf);
        SecurityConfig securityConfig = null;
        if (this.coordinatorConf.getBoolean(RssBaseConf.RSS_SECURITY_HADOOP_KERBEROS_ENABLE)) {
            securityConfig = SecurityConfig.newBuilder().krb5ConfPath(this.coordinatorConf.getString(RssBaseConf.RSS_SECURITY_HADOOP_KRB5_CONF_FILE)).keytabFilePath(this.coordinatorConf.getString(RssBaseConf.RSS_SECURITY_HADOOP_KERBEROS_KEYTAB_FILE)).principal(this.coordinatorConf.getString(RssBaseConf.RSS_SECURITY_HADOOP_KERBEROS_PRINCIPAL)).reloginIntervalSec(this.coordinatorConf.getLong(RssBaseConf.RSS_SECURITY_HADOOP_KERBEROS_RELOGIN_INTERVAL_SEC)).build();
        }
        SecurityContextFactory.get().init(securityConfig);
        Configuration hadoopConf = new Configuration();
        ClusterManagerFactory clusterManagerFactory = new ClusterManagerFactory(this.coordinatorConf, hadoopConf);
        this.clusterManager = clusterManagerFactory.getClusterManager();
        Consumer[] consumerArray = new Consumer[1];
        consumerArray[0] = this.applicationManager::refreshRemoteStorages;
        DynamicClientConfService dynamicClientConfService = new DynamicClientConfService(this.coordinatorConf, hadoopConf, consumerArray);
        this.clientConfApplyManager = new RssClientConfApplyManager(this.coordinatorConf, dynamicClientConfService);
        AssignmentStrategyFactory assignmentStrategyFactory = new AssignmentStrategyFactory(this.coordinatorConf, this.clusterManager);
        this.assignmentStrategy = assignmentStrategyFactory.getAssignmentStrategy();
        this.accessManager = new AccessManager(this.coordinatorConf, this.clusterManager, this.applicationManager.getQuotaManager(), hadoopConf);
        CoordinatorFactory coordinatorFactory = new CoordinatorFactory(this);
        this.server = coordinatorFactory.getServer();
        this.jettyServer = new JettyServer((RssBaseConf)this.coordinatorConf);
        this.jettyServer.registerInstance(RssBaseConf.REST_AUTHORIZATION_CREDENTIALS.key(), (Object)this.coordinatorConf.getString(RssBaseConf.REST_AUTHORIZATION_CREDENTIALS));
        this.jettyServer.addResourcePackages(new String[]{"org.apache.uniffle.coordinator.web.resource", "org.apache.uniffle.common.web.resource"});
        this.jettyServer.registerInstance(CoordinatorServer.class, (Object)this);
        this.jettyServer.registerInstance(ClusterManager.class, (Object)this.clusterManager);
        this.jettyServer.registerInstance(AccessManager.class, (Object)this.accessManager);
        this.jettyServer.registerInstance(ApplicationManager.class, (Object)this.applicationManager);
        this.jettyServer.registerInstance(CollectorRegistry.class.getCanonicalName() + "#server", (Object)CoordinatorMetrics.getCollectorRegistry());
        this.jettyServer.registerInstance(CollectorRegistry.class.getCanonicalName() + "#grpc", (Object)this.grpcMetrics.getCollectorRegistry());
        this.jettyServer.registerInstance(CollectorRegistry.class.getCanonicalName() + "#jvm", (Object)JvmMetrics.getCollectorRegistry());
        this.jettyServer.registerInstance(CollectorRegistry.class.getCanonicalName() + "#all", (Object)new CoalescedCollectorRegistry(new CollectorRegistry[]{CoordinatorMetrics.getCollectorRegistry(), this.grpcMetrics.getCollectorRegistry(), JvmMetrics.getCollectorRegistry()}));
    }

    private void registerMetrics() throws Exception {
        LOG.info("Register metrics");
        CollectorRegistry coordinatorCollectorRegistry = new CollectorRegistry(true);
        CoordinatorMetrics.register(coordinatorCollectorRegistry);
        this.grpcMetrics = new CoordinatorGrpcMetrics((RssConf)this.coordinatorConf);
        this.grpcMetrics.register(new CollectorRegistry(true));
        boolean verbose = this.coordinatorConf.getBoolean(CoordinatorConf.RSS_JVM_METRICS_VERBOSE_ENABLE);
        CollectorRegistry jvmCollectorRegistry = new CollectorRegistry(true);
        JvmMetrics.register((CollectorRegistry)jvmCollectorRegistry, (boolean)verbose);
        this.metricReporter = MetricReporterFactory.getMetricReporter((RssConf)this.coordinatorConf, (String)this.id);
        if (this.metricReporter != null) {
            this.metricReporter.addCollectorRegistry(CoordinatorMetrics.getCollectorRegistry());
            this.metricReporter.addCollectorRegistry(this.grpcMetrics.getCollectorRegistry());
            this.metricReporter.addCollectorRegistry(JvmMetrics.getCollectorRegistry());
        }
    }

    public ClusterManager getClusterManager() {
        return this.clusterManager;
    }

    public AssignmentStrategy getAssignmentStrategy() {
        return this.assignmentStrategy;
    }

    public CoordinatorConf getCoordinatorConf() {
        return this.coordinatorConf;
    }

    public ApplicationManager getApplicationManager() {
        return this.applicationManager;
    }

    public AccessManager getAccessManager() {
        return this.accessManager;
    }

    public RssClientConfApplyManager getClientConfApplyManager() {
        return this.clientConfApplyManager;
    }

    public GRPCMetrics getGrpcMetrics() {
        return this.grpcMetrics;
    }

    protected void blockUntilShutdown() throws InterruptedException {
        this.server.blockUntilShutdown();
    }

    public long getStartTimeMs() {
        return this.startTimeMs;
    }

    public int getRpcListenPort() {
        return this.rpcListenPort;
    }

    public int getJettyPort() {
        return this.jettyPort;
    }
}

