/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.common.netty.protocol;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import org.apache.uniffle.common.ReadSegment;
import org.apache.uniffle.common.netty.protocol.GetLocalShuffleDataV2Request;
import org.apache.uniffle.common.netty.protocol.Message;
import org.apache.uniffle.common.util.ByteBufUtils;

public class GetLocalShuffleDataV3Request
extends GetLocalShuffleDataV2Request {
    private final List<ReadSegment> nextReadSegments;
    private final long taskAttemptId;

    public GetLocalShuffleDataV3Request(long requestId, String appId, int shuffleId, int partitionId, int partitionNumPerRange, int partitionNum, long offset, int length, int storageId, List<ReadSegment> nextReadSegments, long timestamp, long taskAttemptId) {
        super(requestId, appId, shuffleId, partitionId, partitionNumPerRange, partitionNum, offset, length, storageId, timestamp);
        this.nextReadSegments = nextReadSegments;
        this.taskAttemptId = taskAttemptId;
    }

    @Override
    public Message.Type type() {
        return Message.Type.GET_LOCAL_SHUFFLE_DATA_V3_REQUEST;
    }

    @Override
    public int encodedLength() {
        return super.encodedLength() + 4 + 16 * this.nextReadSegments.size() + 8;
    }

    @Override
    public void encode(ByteBuf buf) {
        super.encode(buf);
        buf.writeInt(this.nextReadSegments.size());
        for (ReadSegment segment : this.nextReadSegments) {
            buf.writeLong(segment.getOffset());
            buf.writeLong(segment.getLength());
        }
        buf.writeLong(this.taskAttemptId);
    }

    public static GetLocalShuffleDataV3Request decode(ByteBuf byteBuf) {
        long requestId = byteBuf.readLong();
        String appId = ByteBufUtils.readLengthAndString(byteBuf);
        int shuffleId = byteBuf.readInt();
        int partitionId = byteBuf.readInt();
        int partitionNumPerRange = byteBuf.readInt();
        int partitionNum = byteBuf.readInt();
        long offset = byteBuf.readLong();
        int length = byteBuf.readInt();
        long timestamp = byteBuf.readLong();
        int storageId = byteBuf.readInt();
        int readSegmentCount = byteBuf.readInt();
        ArrayList<ReadSegment> readSegments = new ArrayList<ReadSegment>(readSegmentCount);
        for (int i = 0; i < readSegmentCount; ++i) {
            readSegments.add(new ReadSegment(byteBuf.readLong(), byteBuf.readLong()));
        }
        long taskAttemptId = byteBuf.readLong();
        return new GetLocalShuffleDataV3Request(requestId, appId, shuffleId, partitionId, partitionNumPerRange, partitionNum, offset, length, storageId, readSegments, timestamp, taskAttemptId);
    }

    @Override
    public String getOperationType() {
        return "getLocalShuffleDataV3";
    }
}

