/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.client.response;

import java.io.IOException;
import org.apache.uniffle.client.response.ClientResponse;
import org.apache.uniffle.common.exception.RssException;
import org.apache.uniffle.common.rpc.StatusCode;
import org.apache.uniffle.common.util.RssUtils;
import org.apache.uniffle.proto.RssProtos;
import org.roaringbitmap.longlong.Roaring64NavigableMap;

public class RssGetShuffleResultResponse
extends ClientResponse {
    private Roaring64NavigableMap blockIdBitmap;

    public RssGetShuffleResultResponse(StatusCode statusCode, byte[] serializedBitmap) throws IOException {
        super(statusCode);
        this.blockIdBitmap = RssUtils.deserializeBitMap((byte[])serializedBitmap);
    }

    public Roaring64NavigableMap getBlockIdBitmap() {
        return this.blockIdBitmap;
    }

    public static RssGetShuffleResultResponse fromProto(RssProtos.GetShuffleResultResponse rpcResponse) {
        try {
            return new RssGetShuffleResultResponse(StatusCode.fromProto((RssProtos.StatusCode)rpcResponse.getStatus()), rpcResponse.getSerializedBitmap().toByteArray());
        }
        catch (Exception e) {
            throw new RssException((Throwable)e);
        }
    }

    public static RssGetShuffleResultResponse fromProto(RssProtos.GetShuffleResultForMultiPartResponse rpcResponse) {
        try {
            return new RssGetShuffleResultResponse(StatusCode.fromProto((RssProtos.StatusCode)rpcResponse.getStatus()), rpcResponse.getSerializedBitmap().toByteArray());
        }
        catch (Exception e) {
            throw new RssException((Throwable)e);
        }
    }
}

