/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.shuffle;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.spark.ShuffleDependency;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkEnv;
import org.apache.spark.TaskContext;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.executor.ShuffleWriteMetrics;
import org.apache.spark.rdd.DeterministicLevel;
import org.apache.spark.shuffle.RssShuffleHandle;
import org.apache.spark.shuffle.RssSparkConfig;
import org.apache.spark.shuffle.RssSparkShuffleUtils;
import org.apache.spark.shuffle.ShuffleBlockResolver;
import org.apache.spark.shuffle.ShuffleHandle;
import org.apache.spark.shuffle.ShuffleReader;
import org.apache.spark.shuffle.ShuffleWriter;
import org.apache.spark.shuffle.handle.MutableShuffleHandleInfo;
import org.apache.spark.shuffle.handle.ShuffleHandleInfoBase;
import org.apache.spark.shuffle.handle.SimpleShuffleHandleInfo;
import org.apache.spark.shuffle.handle.StageAttemptShuffleHandleInfo;
import org.apache.spark.shuffle.reader.RssShuffleReader;
import org.apache.spark.shuffle.writer.RssShuffleWriter;
import org.apache.spark.storage.BlockManagerId;
import org.apache.uniffle.client.api.ShuffleWriteClient;
import org.apache.uniffle.client.factory.ShuffleClientFactory;
import org.apache.uniffle.client.util.ClientUtils;
import org.apache.uniffle.common.RemoteStorageInfo;
import org.apache.uniffle.common.ShuffleServerInfo;
import org.apache.uniffle.common.exception.RssException;
import org.apache.uniffle.common.exception.RssFetchFailedException;
import org.apache.uniffle.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.uniffle.shaded.com.google.common.collect.Sets;
import org.apache.uniffle.shaded.org.roaringbitmap.longlong.Roaring64NavigableMap;
import org.apache.uniffle.shuffle.RssShuffleClientFactory;
import org.apache.uniffle.shuffle.manager.RssShuffleManagerBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Option;
import scala.Tuple2;
import scala.collection.Iterator;

public class RssShuffleManager
extends RssShuffleManagerBase {
    private static final Logger LOG = LoggerFactory.getLogger(RssShuffleManager.class);

    public RssShuffleManager(SparkConf sparkConf, boolean isDriver) {
        super(sparkConf, isDriver);
    }

    public <K, V, C> ShuffleHandle registerShuffle(int shuffleId, int numMaps, ShuffleDependency<K, V, C> dependency) {
        if (dependency.partitioner().numPartitions() > this.blockIdLayout.maxNumPartitions) {
            throw new RssException("Cannot register shuffle with " + dependency.partitioner().numPartitions() + " partitions because the configured block id layout supports at most " + this.blockIdLayout.maxNumPartitions + " partitions.");
        }
        if (!SparkEnv.get().serializer().supportsRelocationOfSerializedObjects()) {
            throw new IllegalArgumentException("Can't use serialized shuffle for shuffleId: " + shuffleId + ", because the serializer: " + SparkEnv.get().serializer().getClass().getName() + " does not support object relocation.");
        }
        if ("".equals(this.appId)) {
            this.appId = SparkEnv.get().conf().getAppId() + "_" + this.uuid;
            this.dataPusher.setRssAppId(this.appId);
            LOG.info("Generate application id used in rss: " + this.appId);
        }
        if (this.rssStageRetryEnabled) {
            this.shuffleIdMappingManager.recordShuffleIdDeterminate(shuffleId, dependency.rdd().getOutputDeterministicLevel() != DeterministicLevel.INDETERMINATE());
        }
        if (dependency.partitioner().numPartitions() == 0) {
            this.shuffleIdToPartitionNum.putIfAbsent(shuffleId, 0);
            this.shuffleIdToNumMapTasks.computeIfAbsent(shuffleId, key -> dependency.rdd().partitions().length);
            LOG.info("RegisterShuffle with ShuffleId[{}], partitionNum is 0, return the empty RssShuffleHandle directly", (Object)shuffleId);
            Broadcast<SimpleShuffleHandleInfo> hdlInfoBd = RssSparkShuffleUtils.broadcastShuffleHdlInfo(RssSparkShuffleUtils.getActiveSparkContext(), shuffleId, Collections.emptyMap(), RemoteStorageInfo.EMPTY_REMOTE_STORAGE);
            return new RssShuffleHandle<K, V, C>(shuffleId, this.appId, dependency.rdd().getNumPartitions(), dependency, hdlInfoBd);
        }
        String storageType = this.sparkConf.get(RssSparkConfig.RSS_STORAGE_TYPE.key());
        RemoteStorageInfo defaultRemoteStorage = RssShuffleManager.getDefaultRemoteStorageInfo(this.sparkConf);
        RemoteStorageInfo remoteStorage = ClientUtils.fetchRemoteStorage(this.appId, defaultRemoteStorage, this.dynamicConfEnabled, storageType, this.shuffleWriteClient);
        Set<String> assignmentTags = RssSparkShuffleUtils.getAssignmentTags(this.sparkConf);
        ClientUtils.validateClientType(this.clientType);
        assignmentTags.add(this.clientType);
        int requiredShuffleServerNumber = RssSparkShuffleUtils.getRequiredShuffleServerNumber(this.sparkConf);
        int estimateTaskConcurrency = RssSparkShuffleUtils.estimateTaskConcurrency(this.sparkConf);
        Map<Integer, List<ShuffleServerInfo>> partitionToServers = this.requestShuffleAssignment(shuffleId, dependency.partitioner().numPartitions(), 1, requiredShuffleServerNumber, estimateTaskConcurrency, this.rssStageResubmitManager.getServerIdBlackList());
        this.startHeartbeat();
        this.shuffleIdToPartitionNum.computeIfAbsent(shuffleId, key -> dependency.partitioner().numPartitions());
        this.shuffleIdToNumMapTasks.computeIfAbsent(shuffleId, key -> dependency.rdd().partitions().length);
        if (this.shuffleManagerRpcServiceEnabled && this.rssStageRetryForWriteFailureEnabled) {
            MutableShuffleHandleInfo handleInfo = new MutableShuffleHandleInfo(shuffleId, partitionToServers, remoteStorage);
            StageAttemptShuffleHandleInfo stageAttemptShuffleHandleInfo = new StageAttemptShuffleHandleInfo(shuffleId, remoteStorage, handleInfo);
            this.shuffleHandleInfoManager.register(shuffleId, stageAttemptShuffleHandleInfo);
        } else if (this.shuffleManagerRpcServiceEnabled && this.partitionReassignEnabled) {
            MutableShuffleHandleInfo shuffleHandleInfo = new MutableShuffleHandleInfo(shuffleId, partitionToServers, remoteStorage);
            this.shuffleHandleInfoManager.register(shuffleId, shuffleHandleInfo);
        }
        Broadcast<SimpleShuffleHandleInfo> hdlInfoBd = RssSparkShuffleUtils.broadcastShuffleHdlInfo(RssSparkShuffleUtils.getActiveSparkContext(), shuffleId, partitionToServers, remoteStorage);
        LOG.info("RegisterShuffle with ShuffleId[" + shuffleId + "], partitionNum[" + partitionToServers.size() + "], server:{}", partitionToServers);
        return new RssShuffleHandle<K, V, C>(shuffleId, this.appId, numMaps, dependency, hdlInfoBd);
    }

    public <K, V> ShuffleWriter<K, V> getWriter(ShuffleHandle handle, int mapId, TaskContext context) {
        if (handle instanceof RssShuffleHandle) {
            RssShuffleHandle rssHandle = (RssShuffleHandle)handle;
            this.appId = rssHandle.getAppId();
            this.dataPusher.setRssAppId(this.appId);
            int shuffleId = rssHandle.getShuffleId();
            String taskId = "" + context.taskAttemptId() + "_" + context.attemptNumber();
            ShuffleWriteMetrics writeMetrics = context.taskMetrics().shuffleWriteMetrics();
            return new RssShuffleWriter(rssHandle.getAppId(), shuffleId, taskId, this.getTaskAttemptIdForBlockId(context.partitionId(), context.attemptNumber()), writeMetrics, this, this.sparkConf, this.shuffleWriteClient, this.managerClientSupplier, rssHandle, this::markFailedTask, context);
        }
        throw new RssException("Unexpected ShuffleHandle:" + handle.getClass().getName());
    }

    public <K, C> ShuffleReader<K, C> getReader(ShuffleHandle handle, int startPartition, int endPartition, TaskContext context) {
        if (handle instanceof RssShuffleHandle) {
            RssShuffleHandle rssShuffleHandle = (RssShuffleHandle)handle;
            int partitionNumPerRange = (Integer)this.sparkConf.get(RssSparkConfig.RSS_PARTITION_NUM_PER_RANGE);
            int partitionNum = rssShuffleHandle.getDependency().partitioner().numPartitions();
            int shuffleId = rssShuffleHandle.getShuffleId();
            long start = System.currentTimeMillis();
            Roaring64NavigableMap taskIdBitmap = this.getExpectedTasks(shuffleId, startPartition, endPartition);
            LOG.info("Get taskId cost " + (System.currentTimeMillis() - start) + " ms, and request expected blockIds from " + taskIdBitmap.getLongCardinality() + " tasks for shuffleId[" + shuffleId + "], partitionId[" + startPartition + "]");
            start = System.currentTimeMillis();
            ShuffleHandleInfoBase shuffleHandleInfo = this.shuffleManagerRpcServiceEnabled && this.rssStageRetryForWriteFailureEnabled ? this.getRemoteShuffleHandleInfoWithStageRetry(context.stageId(), context.stageAttemptNumber(), shuffleId, false) : (this.shuffleManagerRpcServiceEnabled && this.partitionReassignEnabled ? this.getRemoteShuffleHandleInfoWithBlockRetry(context.stageId(), context.stageAttemptNumber(), shuffleId, false) : new SimpleShuffleHandleInfo(shuffleId, rssShuffleHandle.getPartitionToServers(), rssShuffleHandle.getRemoteStorage()));
            Map<Integer, List<ShuffleServerInfo>> partitionToServers = shuffleHandleInfo.getAllPartitionServersForReader();
            Roaring64NavigableMap blockIdBitmap = this.getShuffleResult(this.clientType, Sets.newHashSet((Iterable)partitionToServers.get(startPartition)), rssShuffleHandle.getAppId(), shuffleId, startPartition, context.stageAttemptNumber());
            LOG.info("Get shuffle blockId cost " + (System.currentTimeMillis() - start) + " ms, and get " + blockIdBitmap.getLongCardinality() + " blockIds for shuffleId[" + shuffleId + "], partitionId[" + startPartition + "]");
            RemoteStorageInfo shuffleRemoteStorageInfo = rssShuffleHandle.getRemoteStorage();
            LOG.info("Shuffle reader using remote storage {}", (Object)shuffleRemoteStorageInfo);
            String shuffleRemoteStoragePath = shuffleRemoteStorageInfo.getPath();
            Configuration readerHadoopConf = RssSparkShuffleUtils.getRemoteStorageHadoopConf(this.sparkConf, shuffleRemoteStorageInfo);
            return new RssShuffleReader(startPartition, endPartition, context, rssShuffleHandle, shuffleRemoteStoragePath, readerHadoopConf, partitionNumPerRange, partitionNum, blockIdBitmap, taskIdBitmap, RssSparkConfig.toRssConf(this.sparkConf), partitionToServers, this.managerClientSupplier);
        }
        throw new RssException("Unexpected ShuffleHandle:" + handle.getClass().getName());
    }

    public <K, C> ShuffleReader<K, C> getReader(ShuffleHandle handle, int startPartition, int endPartition, TaskContext context, int startMapId, int endMapId) {
        return null;
    }

    public ShuffleBlockResolver shuffleBlockResolver() {
        throw new RssException("RssShuffleManager.shuffleBlockResolver is not implemented");
    }

    private Roaring64NavigableMap getExpectedTasks(int shuffleId, int startPartition, int endPartition) {
        Roaring64NavigableMap taskIdBitmap = Roaring64NavigableMap.bitmapOf(new long[0]);
        Iterator mapStatusIter = SparkEnv.get().mapOutputTracker().getMapSizesByExecutorId(shuffleId, startPartition, endPartition).toIterator();
        while (mapStatusIter.hasNext()) {
            Tuple2 tuple2 = (Tuple2)mapStatusIter.next();
            Option topologyInfo = ((BlockManagerId)tuple2._1()).topologyInfo();
            if (topologyInfo.isDefined()) {
                taskIdBitmap.addLong(Long.parseLong((String)((BlockManagerId)tuple2._1()).topologyInfo().get()));
                continue;
            }
            throw new RssException("Can't get expected taskAttemptId");
        }
        LOG.info("Got result from MapStatus for expected tasks " + taskIdBitmap.getLongCardinality());
        return taskIdBitmap;
    }

    @VisibleForTesting
    public void setAppId(String appId) {
        this.appId = appId;
    }

    @Override
    public String getAppId() {
        return this.appId;
    }

    private Roaring64NavigableMap getShuffleResult(String clientType, Set<ShuffleServerInfo> shuffleServerInfoSet, String appId, int shuffleId, int partitionId, int stageAttemptId) {
        try {
            return this.shuffleWriteClient.getShuffleResult(clientType, shuffleServerInfoSet, appId, shuffleId, partitionId);
        }
        catch (RssFetchFailedException e) {
            throw RssSparkShuffleUtils.reportRssFetchFailedException(this.managerClientSupplier, e, this.sparkConf, appId, shuffleId, stageAttemptId, Sets.newHashSet(partitionId));
        }
    }

    private ShuffleServerInfo assignShuffleServer(int shuffleId, String faultyShuffleServerId) {
        HashSet<String> faultyServerIds = Sets.newHashSet(faultyShuffleServerId);
        faultyServerIds.addAll(this.rssStageResubmitManager.getServerIdBlackList());
        Map<Integer, List<ShuffleServerInfo>> partitionToServers = this.requestShuffleAssignment(shuffleId, 1, 1, 1, 1, faultyServerIds);
        if (partitionToServers.get(0) != null && partitionToServers.get(0).size() == 1) {
            return partitionToServers.get(0).get(0);
        }
        return null;
    }

    @Override
    protected ShuffleWriteClient createShuffleWriteClient() {
        int unregisterThreadPoolSize = (Integer)this.sparkConf.get(RssSparkConfig.RSS_CLIENT_UNREGISTER_THREAD_POOL_SIZE);
        int unregisterTimeoutSec = (Integer)this.sparkConf.get(RssSparkConfig.RSS_CLIENT_UNREGISTER_TIMEOUT_SEC);
        int unregisterRequestTimeoutSec = (Integer)this.sparkConf.get(RssSparkConfig.RSS_CLIENT_UNREGISTER_REQUEST_TIMEOUT_SEC);
        long retryIntervalMax = (Long)this.sparkConf.get(RssSparkConfig.RSS_CLIENT_RETRY_INTERVAL_MAX);
        int heartBeatThreadNum = (Integer)this.sparkConf.get(RssSparkConfig.RSS_CLIENT_HEARTBEAT_THREAD_NUM);
        int retryMax = (Integer)this.sparkConf.get(RssSparkConfig.RSS_CLIENT_RETRY_MAX);
        return RssShuffleClientFactory.getInstance().createShuffleWriteClient((RssShuffleClientFactory.ExtendWriteClientBuilder)((RssShuffleClientFactory.ExtendWriteClientBuilder)((RssShuffleClientFactory.ExtendWriteClientBuilder)((RssShuffleClientFactory.ExtendWriteClientBuilder)((RssShuffleClientFactory.ExtendWriteClientBuilder)((RssShuffleClientFactory.ExtendWriteClientBuilder)((RssShuffleClientFactory.ExtendWriteClientBuilder)((RssShuffleClientFactory.ExtendWriteClientBuilder)((RssShuffleClientFactory.ExtendWriteClientBuilder)((RssShuffleClientFactory.ExtendWriteClientBuilder)((RssShuffleClientFactory.ExtendWriteClientBuilder)((RssShuffleClientFactory.ExtendWriteClientBuilder)((RssShuffleClientFactory.ExtendWriteClientBuilder)((RssShuffleClientFactory.ExtendWriteClientBuilder)((ShuffleClientFactory.WriteClientBuilder)((RssShuffleClientFactory.ExtendWriteClientBuilder)RssShuffleClientFactory.newWriteBuilder().blockIdSelfManagedEnabled(this.blockIdSelfManagedEnabled)).managerClientSupplier(this.managerClientSupplier)).clientType(this.clientType)).retryMax(retryMax)).retryIntervalMax(retryIntervalMax)).heartBeatThreadNum(heartBeatThreadNum)).replica(this.dataReplica)).replicaWrite(this.dataReplicaWrite)).replicaRead(this.dataReplicaRead)).replicaSkipEnabled(this.dataReplicaSkipEnabled)).dataTransferPoolSize(this.dataTransferPoolSize)).dataCommitPoolSize(this.dataCommitPoolSize)).unregisterThreadPoolSize(unregisterThreadPoolSize)).unregisterTimeSec(unregisterTimeoutSec)).unregisterRequestTimeSec(unregisterRequestTimeoutSec)).rssConf(this.rssConf));
    }

    @Override
    protected void checkSupported(SparkConf sparkConf) {
        if (sparkConf.getBoolean("spark.sql.adaptive.enabled", false)) {
            throw new IllegalArgumentException("Spark2 doesn't support AQE, spark.sql.adaptive.enabled should be false.");
        }
    }
}

