/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.common;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.uniffle.shaded.com.google.common.base.Joiner;
import org.apache.uniffle.shaded.com.google.common.base.Objects;
import org.apache.uniffle.shaded.com.google.common.collect.Maps;
import org.apache.uniffle.shaded.org.apache.commons.lang3.ArrayUtils;
import org.apache.uniffle.shaded.org.apache.commons.lang3.StringUtils;

public class RemoteStorageInfo
implements Serializable {
    private static final long serialVersionUID = 0L;
    public static final RemoteStorageInfo EMPTY_REMOTE_STORAGE = new RemoteStorageInfo("", "");
    private final String path;
    private final Map<String, String> confItems;

    public RemoteStorageInfo(String path) {
        this(path, Maps.newHashMap());
    }

    public RemoteStorageInfo(String path, Map<String, String> confItems) {
        this.path = path;
        this.confItems = confItems == null ? Maps.newHashMap() : confItems;
    }

    public RemoteStorageInfo(String path, String confString) {
        this.path = path;
        this.confItems = RemoteStorageInfo.parseRemoteStorageConf(confString);
    }

    public static Map<String, String> parseRemoteStorageConf(String confString) {
        Object[] items;
        HashMap<String, String> confItems = Maps.newHashMap();
        if (!StringUtils.isEmpty(confString) && !ArrayUtils.isEmpty(items = confString.split(","))) {
            for (Object item : items) {
                String[] kv = ((String)item).split("=");
                if (kv.length != 2) continue;
                confItems.put(kv[0], kv[1]);
            }
        }
        return confItems;
    }

    public String getPath() {
        return this.path;
    }

    public Map<String, String> getConfItems() {
        return this.confItems;
    }

    public boolean isEmpty() {
        return StringUtils.isEmpty(this.path);
    }

    public String getConfString() {
        if (this.confItems.isEmpty()) {
            return "";
        }
        return this.confItems.entrySet().stream().map(e -> String.join((CharSequence)"=", (CharSequence)e.getKey(), (CharSequence)e.getValue())).collect(Collectors.joining(","));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RemoteStorageInfo that = (RemoteStorageInfo)o;
        if (!Objects.equal(this.path, that.path)) {
            return false;
        }
        if (this.confItems.size() != that.confItems.size()) {
            return false;
        }
        for (Map.Entry<String, String> entry : this.confItems.entrySet()) {
            if (!that.confItems.containsKey(entry.getKey())) {
                return false;
            }
            String value = that.confItems.get(entry.getKey());
            if (Objects.equal(entry.getValue(), value)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        if (this.isEmpty()) {
            return "Empty Remote Storage";
        }
        if (this.confItems == null) {
            return String.join((CharSequence)",", this.path, "null conf");
        }
        if (this.confItems.isEmpty()) {
            return String.join((CharSequence)",", this.path, "empty conf");
        }
        return String.join((CharSequence)",", this.path, Joiner.on(",").withKeyValueSeparator("=").join(this.confItems));
    }

    public int hashCode() {
        return Objects.hashCode(this.path, this.confItems);
    }
}

