/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.shaded.org.roaringbitmap.art;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.uniffle.shaded.org.roaringbitmap.art.Art;
import org.apache.uniffle.shaded.org.roaringbitmap.art.BackwardShuttle;
import org.apache.uniffle.shaded.org.roaringbitmap.art.Containers;
import org.apache.uniffle.shaded.org.roaringbitmap.art.ForwardShuttle;
import org.apache.uniffle.shaded.org.roaringbitmap.art.LeafNode;
import org.apache.uniffle.shaded.org.roaringbitmap.art.Shuttle;

public class LeafNodeIterator
implements Iterator<LeafNode> {
    private Shuttle shuttle;
    private boolean hasCurrent;
    private LeafNode current;
    private boolean calledHasNext;
    private boolean isEmpty;

    public LeafNodeIterator(Art art, Containers containers) {
        this(art, false, containers);
    }

    public LeafNodeIterator(Art art, boolean reverse, Containers containers) {
        this.isEmpty = art.isEmpty();
        if (this.isEmpty) {
            return;
        }
        this.shuttle = !reverse ? new ForwardShuttle(art, containers) : new BackwardShuttle(art, containers);
        this.shuttle.initShuttle();
        this.calledHasNext = false;
    }

    public LeafNodeIterator(Art art, boolean reverse, Containers containers, long from) {
        this.isEmpty = art.isEmpty();
        if (this.isEmpty) {
            return;
        }
        this.shuttle = !reverse ? new ForwardShuttle(art, containers) : new BackwardShuttle(art, containers);
        this.shuttle.initShuttleFrom(from);
        this.calledHasNext = false;
    }

    private boolean advance() {
        boolean hasLeafNode = this.shuttle.moveToNextLeaf();
        if (hasLeafNode) {
            this.hasCurrent = true;
            this.current = this.shuttle.getCurrentLeafNode();
        } else {
            this.hasCurrent = false;
            this.current = null;
        }
        return hasLeafNode;
    }

    @Override
    public boolean hasNext() {
        if (this.isEmpty) {
            return false;
        }
        if (!this.calledHasNext) {
            this.calledHasNext = true;
            return this.advance();
        }
        return this.hasCurrent;
    }

    @Override
    public LeafNode next() {
        if (!this.calledHasNext) {
            this.hasNext();
        }
        if (!this.hasCurrent) {
            throw new NoSuchElementException();
        }
        this.calledHasNext = false;
        return this.current;
    }

    @Override
    public void remove() {
        this.shuttle.remove();
    }

    public void seek(long boundval) {
        this.shuttle.initShuttleFrom(boundval);
        this.calledHasNext = false;
    }

    public LeafNode peekNext() {
        if (!this.calledHasNext) {
            this.hasNext();
        }
        if (!this.hasCurrent) {
            throw new NoSuchElementException();
        }
        return this.current;
    }
}

