/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.common;

import java.util.ArrayList;
import java.util.List;
import org.apache.uniffle.common.rpc.StatusCode;
import org.apache.uniffle.proto.RssProtos;

public class ReceivingFailureServer {
    private String serverId;
    private StatusCode statusCode;

    private ReceivingFailureServer() {
    }

    public ReceivingFailureServer(String serverId, StatusCode statusCode) {
        this.serverId = serverId;
        this.statusCode = statusCode;
    }

    public String getServerId() {
        return this.serverId;
    }

    public StatusCode getStatusCode() {
        return this.statusCode;
    }

    public String toString() {
        return "ReceivingFailureServer{serverId='" + this.serverId + '\'' + ", statusCode=" + (Object)((Object)this.statusCode) + '}';
    }

    public static List<ReceivingFailureServer> fromProto(RssProtos.ReceivingFailureServers proto) {
        ArrayList<ReceivingFailureServer> servers = new ArrayList<ReceivingFailureServer>();
        for (RssProtos.ReceivingFailureServer protoServer : proto.getServerList()) {
            ReceivingFailureServer server = new ReceivingFailureServer();
            server.serverId = protoServer.getServerId();
            server.statusCode = StatusCode.fromProto(protoServer.getStatusCode());
            servers.add(server);
        }
        return servers;
    }

    public static RssProtos.ReceivingFailureServers toProto(List<ReceivingFailureServer> servers) {
        ArrayList<RssProtos.ReceivingFailureServer> protoServers = new ArrayList<RssProtos.ReceivingFailureServer>();
        for (ReceivingFailureServer server : servers) {
            protoServers.add(RssProtos.ReceivingFailureServer.newBuilder().setServerId(server.serverId).setStatusCode(server.statusCode.toProto()).build());
        }
        return RssProtos.ReceivingFailureServers.newBuilder().addAllServer(protoServers).build();
    }

    public static RssProtos.ReceivingFailureServer toProto(ReceivingFailureServer server) {
        return RssProtos.ReceivingFailureServer.newBuilder().setServerId(server.serverId).setStatusCode(server.statusCode.toProto()).build();
    }
}

