/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.common.compression;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.uniffle.common.compression.Codec;
import org.apache.uniffle.common.exception.RssException;
import org.xerial.snappy.Snappy;

public class SnappyCodec
extends Codec {
    public static SnappyCodec getInstance() {
        return LazyHolder.INSTANCE;
    }

    @Override
    public void decompress(ByteBuffer src, int uncompressedLen, ByteBuffer dest, int destOffset) {
        try {
            if (!src.isDirect() && !dest.isDirect()) {
                int size = Snappy.uncompress((byte[])src.array(), (int)src.position(), (int)(src.limit() - src.position()), (byte[])dest.array(), (int)destOffset);
                if (size != uncompressedLen) {
                    throw new RssException("This should not happen that the decompressed data size is not equals to original size.");
                }
                return;
            }
            if (src.isDirect() && dest.isDirect()) {
                if (destOffset != 0) {
                    throw new RssException("Snappy decompression does not support non-zero offset for destination direct ByteBuffer");
                }
                int size = Snappy.uncompress((ByteBuffer)src, (ByteBuffer)dest);
                if (size != uncompressedLen) {
                    throw new RssException("This should not happen that the decompressed data size is not equals to original size.");
                }
                return;
            }
        }
        catch (IOException e) {
            throw new RssException("Failed to uncompress by Snappy", e);
        }
        throw new IllegalStateException("Snappy only supports the same type of bytebuffer decompression.");
    }

    @Override
    public byte[] compress(byte[] src) {
        try {
            return Snappy.compress((byte[])src);
        }
        catch (IOException e) {
            throw new RssException("Failed to uncompress by Snappy", e);
        }
    }

    @Override
    public int compress(ByteBuffer src, ByteBuffer dest) {
        try {
            if (src.isDirect() && dest.isDirect()) {
                int destOff = dest.position();
                int compressedSize = Snappy.compress((ByteBuffer)src.duplicate(), (ByteBuffer)dest.duplicate());
                dest.position(destOff + compressedSize);
                return compressedSize;
            }
            if (!src.isDirect() && !dest.isDirect()) {
                int destOff = dest.position();
                int compressedSize = Snappy.compress((byte[])src.array(), (int)src.position(), (int)(src.limit() - src.position()), (byte[])dest.array(), (int)dest.position());
                dest.position(destOff + compressedSize);
                return compressedSize;
            }
        }
        catch (Exception e) {
            throw new RssException("Failed to compress by Snappy", e);
        }
        throw new IllegalStateException("Snappy only supports the same type of bytebuffer compression.");
    }

    @Override
    public int maxCompressedLength(int sourceLength) {
        return Snappy.maxCompressedLength((int)sourceLength);
    }

    private static class LazyHolder {
        static final SnappyCodec INSTANCE = new SnappyCodec();

        private LazyHolder() {
        }
    }
}

