/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.common.config;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.uniffle.common.config.ConfigOption;
import org.apache.uniffle.common.config.ConfigUtils;
import org.apache.uniffle.common.config.FallbackKey;
import org.apache.uniffle.shaded.org.apache.commons.lang3.StringUtils;

public class ConfigOptions {
    private ConfigOptions() {
    }

    public static OptionBuilder key(String key) {
        Objects.requireNonNull(key);
        return new OptionBuilder(key);
    }

    public static class ListConfigOptionBuilder<E> {
        private static final String LIST_SPLITTER = ",";
        private final String key;
        private final Class<E> clazz;
        private final Function<Object, E> atomicConverter;
        private Function<Object, List<E>> asListConverter;

        public ListConfigOptionBuilder(String key, Class<E> clazz, Function<Object, E> atomicConverter) {
            this.key = key;
            this.clazz = clazz;
            this.atomicConverter = atomicConverter;
            this.asListConverter = v -> {
                if (v instanceof List) {
                    return (List)v;
                }
                String trimmedVal = v.toString().trim();
                if (StringUtils.isEmpty(trimmedVal)) {
                    return Collections.emptyList();
                }
                return Arrays.stream(trimmedVal.split(LIST_SPLITTER)).map(atomicConverter::apply).collect(Collectors.toList());
            };
        }

        public ListConfigOptionBuilder<E> checkValue(Function<E, Boolean> checkValueFunc, String errMsg) {
            Function listConverFunc = this.asListConverter;
            Function<Object, List> newConverter = v -> {
                List list = (List)listConverFunc.apply(v);
                if (list.stream().anyMatch(x -> (Boolean)checkValueFunc.apply(x) == false)) {
                    throw new IllegalArgumentException(errMsg);
                }
                return list;
            };
            this.asListConverter = newConverter;
            return this;
        }

        @SafeVarargs
        public final ConfigOption<List<E>> defaultValues(E ... values) {
            return new ConfigOption<List<E>>(this.key, this.clazz, "", Arrays.asList(values), this.asListConverter, new FallbackKey[0]);
        }

        public ConfigOption<List<E>> noDefaultValue() {
            return new ConfigOption<List<E>>(this.key, this.clazz, "", null, this.asListConverter, new FallbackKey[0]);
        }
    }

    public static class TypedConfigOptionBuilder<T> {
        private final String key;
        private final Class<T> clazz;
        private final Function<Object, T> converter;

        TypedConfigOptionBuilder(String key, Class<T> clazz) {
            this.key = key;
            this.clazz = clazz;
            this.converter = v -> {
                try {
                    return ConfigUtils.convertValue(v, clazz);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(String.format("Could not parse value '%s' for key '%s'.", v.toString(), key), e);
                }
            };
        }

        TypedConfigOptionBuilder(String key, Class<T> clazz, Function<Object, T> converter) {
            this.key = key;
            this.clazz = clazz;
            this.converter = converter;
        }

        public ListConfigOptionBuilder<T> asList() {
            return new ListConfigOptionBuilder<T>(this.key, this.clazz, this.converter);
        }

        public TypedConfigOptionBuilder<T> checkValue(Function<T, Boolean> checkValue, String errMsg) {
            Function<Object, Object> newConverter = v -> {
                T newValue = this.converter.apply(v);
                if (!((Boolean)checkValue.apply(newValue)).booleanValue()) {
                    throw new IllegalArgumentException(errMsg);
                }
                return newValue;
            };
            return new TypedConfigOptionBuilder<Object>(this.key, this.clazz, newConverter);
        }

        public ConfigOption<T> defaultValue(T value) {
            return new ConfigOption<T>(this.key, this.clazz, "", value, this.converter, new FallbackKey[0]);
        }

        public ConfigOption<T> noDefaultValue() {
            return new ConfigOption<Object>(this.key, this.clazz, "", null, this.converter, new FallbackKey[0]);
        }
    }

    public static final class OptionBuilder {
        private final String key;

        OptionBuilder(String key) {
            this.key = key;
        }

        public TypedConfigOptionBuilder<Boolean> booleanType() {
            return new TypedConfigOptionBuilder<Boolean>(this.key, Boolean.class);
        }

        public TypedConfigOptionBuilder<Integer> intType() {
            return new TypedConfigOptionBuilder<Integer>(this.key, Integer.class);
        }

        public TypedConfigOptionBuilder<Long> longType() {
            return new TypedConfigOptionBuilder<Long>(this.key, Long.class);
        }

        public TypedConfigOptionBuilder<Float> floatType() {
            return new TypedConfigOptionBuilder<Float>(this.key, Float.class);
        }

        public TypedConfigOptionBuilder<Double> doubleType() {
            return new TypedConfigOptionBuilder<Double>(this.key, Double.class);
        }

        public TypedConfigOptionBuilder<String> stringType() {
            return new TypedConfigOptionBuilder<String>(this.key, String.class);
        }

        public <T extends Enum<T>> TypedConfigOptionBuilder<T> enumType(Class<T> enumClass) {
            return new TypedConfigOptionBuilder<T>(this.key, enumClass);
        }
    }
}

