/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.shaded.jackson.databind.ser.std;

import java.io.IOException;
import java.lang.reflect.Type;
import org.apache.uniffle.shaded.jackson.annotation.JsonFormat;
import org.apache.uniffle.shaded.jackson.core.JsonGenerator;
import org.apache.uniffle.shaded.jackson.core.JsonParser;
import org.apache.uniffle.shaded.jackson.databind.BeanProperty;
import org.apache.uniffle.shaded.jackson.databind.JavaType;
import org.apache.uniffle.shaded.jackson.databind.JsonMappingException;
import org.apache.uniffle.shaded.jackson.databind.JsonNode;
import org.apache.uniffle.shaded.jackson.databind.JsonSerializer;
import org.apache.uniffle.shaded.jackson.databind.SerializerProvider;
import org.apache.uniffle.shaded.jackson.databind.annotation.JacksonStdImpl;
import org.apache.uniffle.shaded.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import org.apache.uniffle.shaded.jackson.databind.jsontype.TypeSerializer;
import org.apache.uniffle.shaded.jackson.databind.ser.ContextualSerializer;
import org.apache.uniffle.shaded.jackson.databind.ser.std.StdScalarSerializer;

@JacksonStdImpl
public final class BooleanSerializer
extends StdScalarSerializer<Object>
implements ContextualSerializer {
    private static final long serialVersionUID = 1L;
    protected final boolean _forPrimitive;

    public BooleanSerializer(boolean forPrimitive) {
        super(forPrimitive ? Boolean.TYPE : Boolean.class, false);
        this._forPrimitive = forPrimitive;
    }

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider serializers, BeanProperty property) throws JsonMappingException {
        JsonFormat.Shape shape;
        JsonFormat.Value format = this.findFormatOverrides(serializers, property, Boolean.class);
        if (format != null && (shape = format.getShape()).isNumeric()) {
            return new AsNumber(this._forPrimitive);
        }
        return this;
    }

    @Override
    public void serialize(Object value, JsonGenerator g2, SerializerProvider provider) throws IOException {
        g2.writeBoolean(Boolean.TRUE.equals(value));
    }

    @Override
    public final void serializeWithType(Object value, JsonGenerator g2, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        g2.writeBoolean(Boolean.TRUE.equals(value));
    }

    @Override
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
        return this.createSchemaNode("boolean", !this._forPrimitive);
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        visitor.expectBooleanFormat(typeHint);
    }

    static final class AsNumber
    extends StdScalarSerializer<Object>
    implements ContextualSerializer {
        private static final long serialVersionUID = 1L;
        protected final boolean _forPrimitive;

        public AsNumber(boolean forPrimitive) {
            super(forPrimitive ? Boolean.TYPE : Boolean.class, false);
            this._forPrimitive = forPrimitive;
        }

        @Override
        public void serialize(Object value, JsonGenerator g2, SerializerProvider provider) throws IOException {
            g2.writeNumber(Boolean.FALSE.equals(value) ? 0 : 1);
        }

        @Override
        public final void serializeWithType(Object value, JsonGenerator g2, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
            g2.writeBoolean(Boolean.TRUE.equals(value));
        }

        @Override
        public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
            this.visitIntFormat(visitor, typeHint, JsonParser.NumberType.INT);
        }

        @Override
        public JsonSerializer<?> createContextual(SerializerProvider serializers, BeanProperty property) throws JsonMappingException {
            JsonFormat.Shape shape;
            JsonFormat.Value format = this.findFormatOverrides(serializers, property, Boolean.class);
            if (format != null && !(shape = format.getShape()).isNumeric()) {
                return new BooleanSerializer(this._forPrimitive);
            }
            return this;
        }
    }
}

