/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.common.future;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import org.apache.uniffle.common.exception.RssException;
import org.apache.uniffle.common.future.CompletableFutureExtension;
import org.apache.uniffle.common.util.ThreadUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompletableFutureUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(CompletableFutureUtils.class);

    public static <T> T withTimeoutCancel(Supplier<T> supplier, long timeoutMills) throws Exception {
        return CompletableFutureUtils.withTimeoutCancel(supplier, timeoutMills, "");
    }

    public static <T> T withTimeoutCancel(Supplier<T> supplier, long timeoutMills, String operationName) throws Exception {
        CompletableFuture<T> future = CompletableFuture.supplyAsync(supplier, Executors.newSingleThreadExecutor(ThreadUtils.getThreadFactory(operationName)));
        future.exceptionally(throwable -> {
            throw new RssException((Throwable)throwable);
        });
        CompletableFuture<T> extended = CompletableFutureExtension.orTimeout(future, timeoutMills, TimeUnit.MILLISECONDS);
        try {
            return extended.get();
        }
        catch (Exception e) {
            if (e instanceof ExecutionException) {
                Throwable internalThrowable = e.getCause();
                if (internalThrowable instanceof TimeoutException) {
                    LOGGER.error("The operation of [{}] haven't finished in the {}(millis). Drop this execution!", (Object)operationName, (Object)timeoutMills);
                    throw new TimeoutException();
                }
                if (internalThrowable instanceof Exception) {
                    throw (Exception)internalThrowable;
                }
            }
            throw e;
        }
    }
}

