/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.storage.handler.impl;

import java.util.Collection;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import org.apache.hadoop.conf.Configuration;
import org.apache.uniffle.common.ShufflePartitionedBlock;
import org.apache.uniffle.common.config.RssBaseConf;
import org.apache.uniffle.common.exception.RssException;
import org.apache.uniffle.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.uniffle.storage.handler.api.ShuffleWriteHandler;
import org.apache.uniffle.storage.handler.impl.HadoopShuffleWriteHandler;
import org.apache.uniffle.storage.util.ShuffleStorageUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PooledHadoopShuffleWriteHandler
implements ShuffleWriteHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(PooledHadoopShuffleWriteHandler.class);
    private final LinkedBlockingDeque<ShuffleWriteHandler> queue;
    private final int maxConcurrency;
    private final String basePath;
    private Function<Integer, ShuffleWriteHandler> createWriterFunc;
    private AtomicInteger initializedHandlerCntRef = new AtomicInteger(0);

    @VisibleForTesting
    public PooledHadoopShuffleWriteHandler(LinkedBlockingDeque<ShuffleWriteHandler> queue) {
        this.queue = queue;
        this.maxConcurrency = queue.size();
        this.basePath = "";
    }

    @VisibleForTesting
    public PooledHadoopShuffleWriteHandler(LinkedBlockingDeque<ShuffleWriteHandler> queue, int maxConcurrency, Function<Integer, ShuffleWriteHandler> createWriterFunc) {
        this.queue = queue;
        this.maxConcurrency = maxConcurrency;
        this.basePath = "";
        this.createWriterFunc = createWriterFunc;
    }

    public PooledHadoopShuffleWriteHandler(RssBaseConf rssBaseConf, String appId, int shuffleId, int startPartition, int endPartition, String storageBasePath, String fileNamePrefix, Configuration hadoopConf, String user, int concurrency) {
        this.maxConcurrency = concurrency;
        this.queue = new LinkedBlockingDeque(this.maxConcurrency);
        this.basePath = ShuffleStorageUtils.getFullShuffleDataFolder(storageBasePath, ShuffleStorageUtils.getShuffleDataPath(appId, shuffleId, startPartition, endPartition));
        this.createWriterFunc = index -> {
            try {
                return new HadoopShuffleWriteHandler(rssBaseConf, appId, shuffleId, startPartition, endPartition, storageBasePath, fileNamePrefix + "_" + index, hadoopConf, user);
            }
            catch (Exception e) {
                throw new RssException("Errors on initializing Hadoop FS writer handler.", e);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(Collection<ShufflePartitionedBlock> shuffleBlocks) throws Exception {
        if (this.queue.isEmpty() && this.initializedHandlerCntRef.get() < this.maxConcurrency) {
            PooledHadoopShuffleWriteHandler pooledHadoopShuffleWriteHandler = this;
            synchronized (pooledHadoopShuffleWriteHandler) {
                if (this.initializedHandlerCntRef.get() < this.maxConcurrency) {
                    this.queue.add(this.createWriterFunc.apply(this.initializedHandlerCntRef.get()));
                    this.initializedHandlerCntRef.addAndGet(1);
                }
            }
        }
        if (this.queue.isEmpty()) {
            LOGGER.warn("No free Hadoop FS writer handler, it will wait. storage path: {}", (Object)this.basePath);
        }
        ShuffleWriteHandler writeHandler = this.queue.take();
        try {
            writeHandler.write(shuffleBlocks);
        }
        finally {
            this.queue.addFirst(writeHandler);
        }
    }

    @VisibleForTesting
    protected int getInitializedHandlerCnt() {
        return this.initializedHandlerCntRef.get();
    }
}

