/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.common;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.security.PrivilegedExceptionAction;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.tez.common.GetShuffleServerRequest;
import org.apache.tez.common.GetShuffleServerResponse;
import org.apache.tez.common.TezRemoteShuffleUmbilicalProtocol;
import org.apache.tez.common.security.TokenCache;
import org.apache.tez.dag.api.TezException;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.apache.uniffle.common.ShuffleServerInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UmbilicalUtils {
    private static final Logger LOG = LoggerFactory.getLogger(UmbilicalUtils.class);

    private UmbilicalUtils() {
    }

    private static Map<Integer, List<ShuffleServerInfo>> doRequestShuffleServer(ApplicationId applicationId, final Configuration conf, TezTaskAttemptID taskAttemptId, int shuffleId) throws IOException, InterruptedException, TezException {
        String host = conf.get("tez.rss.am.shuffle.manager.address");
        int port = conf.getInt("tez.rss.am.shuffle.manager.port", -1);
        final InetSocketAddress address = NetUtils.createSocketAddrForHost((String)host, (int)port);
        UserGroupInformation taskOwner = UserGroupInformation.createRemoteUser((String)applicationId.toString());
        Credentials credentials = UserGroupInformation.getCurrentUser().getCredentials();
        Token jobToken = TokenCache.getSessionToken((Credentials)credentials);
        SecurityUtil.setTokenService((Token)jobToken, (InetSocketAddress)address);
        taskOwner.addToken(jobToken);
        TezRemoteShuffleUmbilicalProtocol umbilical = (TezRemoteShuffleUmbilicalProtocol)taskOwner.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<TezRemoteShuffleUmbilicalProtocol>(){

            @Override
            public TezRemoteShuffleUmbilicalProtocol run() throws Exception {
                return (TezRemoteShuffleUmbilicalProtocol)RPC.getProxy(TezRemoteShuffleUmbilicalProtocol.class, (long)31L, (InetSocketAddress)address, (Configuration)conf);
            }
        });
        GetShuffleServerRequest request = new GetShuffleServerRequest(taskAttemptId, 200, 200, shuffleId);
        GetShuffleServerResponse response = umbilical.getShuffleAssignments(request);
        Map<Integer, List<ShuffleServerInfo>> partitionToServers = response.getShuffleAssignmentsInfoWritable().getShuffleAssignmentsInfo().getPartitionToServers();
        LOG.info("RequestShuffleServer applicationId:{}, taskAttemptId:{}, host:{}, port:{}, shuffleId:{}, worker:{}", new Object[]{applicationId, taskAttemptId, host, port, shuffleId, partitionToServers});
        return partitionToServers;
    }

    public static Map<Integer, List<ShuffleServerInfo>> requestShuffleServer(ApplicationId applicationId, Configuration conf, TezTaskAttemptID taskAttemptId, int shuffleId) {
        try {
            return UmbilicalUtils.doRequestShuffleServer(applicationId, conf, taskAttemptId, shuffleId);
        }
        catch (IOException | InterruptedException | TezException e) {
            LOG.error("Failed to requestShuffleServer, applicationId:{}, taskAttemptId:{}, shuffleId:{}, worker:{}", new Object[]{applicationId, taskAttemptId, shuffleId, e});
            return null;
        }
    }
}

