/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.common;

import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.uniffle.proto.RssProtos;
import org.apache.uniffle.shaded.com.google.common.annotations.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShuffleServerInfo
implements Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ShuffleServerInfo.class);
    private static final String DELIMITER = "-";
    private static final long serialVersionUID = 0L;
    private String id;
    private String host;
    private int grpcPort;
    private int nettyPort = -1;

    @VisibleForTesting
    public ShuffleServerInfo(String host, int port) {
        this.id = host + DELIMITER + port;
        this.host = host;
        this.grpcPort = port;
    }

    @VisibleForTesting
    public ShuffleServerInfo(String host, int grpcPort, int nettyPort) {
        this.id = host + DELIMITER + grpcPort + DELIMITER + nettyPort;
        this.host = host;
        this.grpcPort = grpcPort;
        this.nettyPort = nettyPort;
    }

    public ShuffleServerInfo(String id, String host, int port) {
        this.id = id;
        this.host = host;
        this.grpcPort = port;
    }

    public ShuffleServerInfo(String id, String host, int grpcPort, int nettyPort) {
        this.id = id;
        this.host = host;
        this.grpcPort = grpcPort;
        this.nettyPort = nettyPort;
    }

    public String getId() {
        return this.id;
    }

    public String getHost() {
        return this.host;
    }

    public int getGrpcPort() {
        return this.grpcPort;
    }

    public int getNettyPort() {
        return this.nettyPort;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ShuffleServerInfo) {
            return this.id.equals(((ShuffleServerInfo)obj).getId()) && this.host.equals(((ShuffleServerInfo)obj).getHost()) && this.grpcPort == ((ShuffleServerInfo)obj).getGrpcPort() && this.nettyPort == ((ShuffleServerInfo)obj).getNettyPort();
        }
        return false;
    }

    public String toString() {
        if (this.nettyPort > 0) {
            return "ShuffleServerInfo{host[" + this.host + "], grpc port[" + this.grpcPort + "], netty port[" + this.nettyPort + "]}";
        }
        return "ShuffleServerInfo{host[" + this.host + "], grpc port[" + this.grpcPort + "]}";
    }

    public static ShuffleServerInfo convertFromShuffleServerId(RssProtos.ShuffleServerId shuffleServerId) {
        ShuffleServerInfo shuffleServerInfo = new ShuffleServerInfo(shuffleServerId.getId(), shuffleServerId.getIp(), shuffleServerId.getPort(), shuffleServerId.getNettyPort());
        return shuffleServerInfo;
    }

    public static RssProtos.ShuffleServerId convertToShuffleServerId(ShuffleServerInfo shuffleServerInfo) {
        RssProtos.ShuffleServerId shuffleServerId = RssProtos.ShuffleServerId.newBuilder().setId(shuffleServerInfo.getId()).setIp(shuffleServerInfo.getHost()).setPort(shuffleServerInfo.grpcPort).setNettyPort(shuffleServerInfo.nettyPort).build();
        return shuffleServerId;
    }

    public static List<ShuffleServerInfo> fromProto(List<RssProtos.ShuffleServerId> servers) {
        return servers.stream().map(server -> ShuffleServerInfo.convertFromShuffleServerId(server)).collect(Collectors.toList());
    }

    public static List<RssProtos.ShuffleServerId> toProto(List<ShuffleServerInfo> shuffleServerInfos) {
        return shuffleServerInfos.stream().map(server -> ShuffleServerInfo.convertToShuffleServerId(server)).collect(Collectors.toList());
    }

    public static ShuffleServerInfo from(String serverId) {
        if (serverId == null || serverId.isEmpty()) {
            LOGGER.warn("Server id is null or empty");
            return null;
        }
        String[] parts = serverId.split(DELIMITER);
        if (parts.length == 2) {
            return new ShuffleServerInfo(parts[0], Integer.parseInt(parts[1]));
        }
        if (parts.length == 3) {
            return new ShuffleServerInfo(parts[0], Integer.parseInt(parts[1]), Integer.parseInt(parts[2]));
        }
        LOGGER.warn("Server id is invalid. {}", (Object)serverId);
        return null;
    }
}

