/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.common.compression;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.uniffle.common.compression.Codec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatisticsCodec
extends Codec {
    private static final Logger LOGGER = LoggerFactory.getLogger(StatisticsCodec.class);
    private final Codec codec;
    private final List<CodecCost> compressCosts;

    StatisticsCodec(Codec codec) {
        LOGGER.info("Statistic codec is enabled");
        this.codec = codec;
        this.compressCosts = Collections.synchronizedList(new ArrayList());
    }

    @Override
    public void decompress(ByteBuffer src, int uncompressedLen, ByteBuffer dest, int destOffset) {
        this.codec.decompress(src, uncompressedLen, dest, destOffset);
    }

    @Override
    public byte[] compress(byte[] src) {
        long start = System.currentTimeMillis();
        byte[] result = this.codec.compress(src);
        this.compressCosts.add(new CodecCost(src.length, result.length, System.currentTimeMillis() - start));
        return result;
    }

    @Override
    public int compress(ByteBuffer src, ByteBuffer dest) {
        return this.codec.compress(src, dest);
    }

    @Override
    public int maxCompressedLength(int sourceLength) {
        return this.codec.maxCompressedLength(sourceLength);
    }

    public void statistics() {
        if (this.compressCosts.isEmpty()) {
            return;
        }
        this.compressCosts.sort(Comparator.comparingInt(c -> ((CodecCost)c).sourceByteSize));
        LOGGER.info("Statistics of compression({}): \n-------------------------------------------\nMinimum: {} \nP25: {} \nMedian: {} \nP75: {} \nP90: {} \nMaximum: {}\n-------------------------------------------", new Object[]{this.compressCosts.size(), this.compressCosts.get(0), this.percentile(this.compressCosts, 0.25), this.percentile(this.compressCosts, 0.5), this.percentile(this.compressCosts, 0.75), this.percentile(this.compressCosts, 0.9), this.compressCosts.get(this.compressCosts.size() - 1)});
    }

    private CodecCost percentile(List<CodecCost> values, double percentile) {
        if (values.isEmpty()) {
            return null;
        }
        int index = (int)Math.ceil(percentile * (double)values.size()) - 1;
        index = Math.min(Math.max(index, 0), values.size() - 1);
        return values.get(index);
    }

    static class CodecCost {
        private int sourceByteSize;
        private int targetByteSize;
        private long duration;

        CodecCost(int sourceByteSize, int targetByteSize, long duration) {
            this.sourceByteSize = sourceByteSize;
            this.targetByteSize = targetByteSize;
            this.duration = duration;
        }

        public String toString() {
            return "CodecCost{sourceByteSize=" + this.sourceByteSize + ", targetByteSize=" + this.targetByteSize + ", durationMillis=" + this.duration + '}';
        }
    }
}

