/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.common;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Objects;

public class ShufflePartitionedBlock {
    private int dataLength;
    private long crc;
    private long blockId;
    private int uncompressLength;
    private ByteBuf data;
    private long taskAttemptId;

    public ShufflePartitionedBlock(int dataLength, int uncompressLength, long crc, long blockId, long taskAttemptId, byte[] data) {
        this(dataLength, uncompressLength, crc, blockId, taskAttemptId, data == null ? Unpooled.EMPTY_BUFFER : Unpooled.wrappedBuffer((byte[])data));
    }

    public ShufflePartitionedBlock(int dataLength, int uncompressLength, long crc, long blockId, long taskAttemptId, ByteBuf data) {
        this.dataLength = dataLength;
        this.crc = crc;
        this.blockId = blockId;
        this.uncompressLength = uncompressLength;
        this.taskAttemptId = taskAttemptId;
        this.data = data;
    }

    public boolean isOnLAB() {
        return false;
    }

    public long getEncodedLength() {
        return this.dataLength + 24 + 8;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShufflePartitionedBlock that = (ShufflePartitionedBlock)o;
        return this.blockId == that.blockId;
    }

    public int hashCode() {
        return Objects.hash(this.blockId);
    }

    public int getDataLength() {
        return this.dataLength;
    }

    public void setDataLength(int dataLength) {
        this.dataLength = dataLength;
    }

    public long getCrc() {
        return this.crc;
    }

    public void setCrc(long crc) {
        this.crc = crc;
    }

    public long getBlockId() {
        return this.blockId;
    }

    public void setBlockId(long blockId) {
        this.blockId = blockId;
    }

    public ByteBuf getData() {
        return this.data;
    }

    public void setData(ByteBuf data) {
        this.data = data;
    }

    public int getUncompressLength() {
        return this.uncompressLength;
    }

    public long getTaskAttemptId() {
        return this.taskAttemptId;
    }

    public void setTaskAttemptId(long taskAttemptId) {
        this.taskAttemptId = taskAttemptId;
    }

    public String toString() {
        return "ShufflePartitionedBlock{blockId[" + this.blockId + "], length[" + this.dataLength + "], uncompressLength[" + this.uncompressLength + "], crc[" + this.crc + "], taskAttemptId[" + this.taskAttemptId + "]}";
    }
}

