/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.common.serializer;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.uniffle.common.config.RssBaseConf;
import org.apache.uniffle.common.config.RssConf;
import org.apache.uniffle.common.exception.RssException;
import org.apache.uniffle.common.serializer.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerializerFactory {
    private static final Logger LOG = LoggerFactory.getLogger(SerializerFactory.class);
    private List<Serializer> serializers = new ArrayList<Serializer>();
    RssConf conf;

    public SerializerFactory(RssConf conf) {
        this.conf = conf;
        for (String serializerName : StringUtils.split((String)conf.get(RssBaseConf.RSS_IO_SERIALIZATIONS), (String)",")) {
            this.add(conf, serializerName);
        }
    }

    private void add(RssConf conf, String serializerName) {
        try {
            Class sClass = ClassUtils.getClass((String)serializerName);
            Constructor constructor = sClass.getConstructor(RssConf.class);
            Serializer serializer = (Serializer)constructor.newInstance(conf);
            this.serializers.add(serializer);
        }
        catch (Exception e) {
            LOG.warn("Construct Serialization fail, caused by ", (Throwable)e);
            throw new RssException(e);
        }
    }

    public Serializer getSerializer(Class c) {
        for (Serializer serializer : this.serializers) {
            if (!serializer.accept(c)) continue;
            return serializer;
        }
        return null;
    }
}

