/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.common.web.resource;

import java.util.HashSet;
import java.util.Map;
import javax.servlet.ServletContext;
import org.apache.hbase.thirdparty.javax.ws.rs.Consumes;
import org.apache.hbase.thirdparty.javax.ws.rs.POST;
import org.apache.hbase.thirdparty.javax.ws.rs.Path;
import org.apache.hbase.thirdparty.javax.ws.rs.core.Context;
import org.apache.uniffle.common.ReconfigurableRegistry;
import org.apache.uniffle.common.config.RssConf;
import org.apache.uniffle.common.web.resource.Authorization;
import org.apache.uniffle.common.web.resource.ConfVO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/conf/ops")
public class ConfOpsResource {
    private static final Logger LOG = LoggerFactory.getLogger(ConfOpsResource.class);
    private static final String WARNING_MSG = "temporarily effective until restart";
    public static final String SERVLET_CONTEXT_ATTR_CONF = "_servlet_context_attr_conf_";
    @Context
    protected ServletContext servletContext;

    @Authorization
    @POST
    @Path(value="/temp/update")
    @Consumes(value={"application/json"})
    public String update(ConfVO updateConfigs) {
        RssConf conf;
        LOG.info("Dynamic updating {}", (Object)updateConfigs);
        String ret = "Nothing changed";
        if (updateConfigs != null && (conf = (RssConf)this.servletContext.getAttribute(SERVLET_CONTEXT_ATTR_CONF)) != null) {
            HashSet<String> changedProperties = new HashSet<String>();
            for (Map.Entry<String, String> entry : updateConfigs.getUpdate().entrySet()) {
                conf.setString(entry.getKey(), entry.getValue());
                changedProperties.add(entry.getKey());
            }
            for (String key : updateConfigs.getDelete()) {
                conf.remove(key);
                changedProperties.add(key);
            }
            ReconfigurableRegistry.update(conf, changedProperties);
            ret = "temporarily effective until restart: Update successfully";
        }
        return ret;
    }
}

