/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.cli;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.gson.Gson;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.lang3.StringUtils;
import org.apache.uniffle.AbstractCustomCommandLine;
import org.apache.uniffle.UniffleCliArgsException;
import org.apache.uniffle.api.AdminRestApi;
import org.apache.uniffle.cli.CLIContentUtils;
import org.apache.uniffle.common.Application;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UniffleCLI
extends AbstractCustomCommandLine {
    private static final Logger LOG = LoggerFactory.getLogger(UniffleCLI.class);
    private static final int EXIT_SUCCESS = 0;
    private static final int EXIT_ERROR = 1;
    private final Options allOptions = new Options();
    private final Option uniffleClientCli;
    private final Option uniffleAdminCli;
    private final Option uniffleApplicationCli;
    private final Option uniffleApplicationRegex;
    private final Option uniffleApplicationListCli;
    private final Option uniffleApplicationPageSize;
    private final Option uniffleApplicationCurrentPage;
    private final Option uniffleApplicationHbTimeRange;
    private final Option uniffleOutFormat;
    private final Option uniffleOutPutFile;
    private final Option help;
    private static final List<String> APPLICATIONS_HEADER = Arrays.asList("ApplicationId", "User", "Registration Time", "Last HeartBeatTime", "RemoteStoragePath");

    public UniffleCLI(String shortPrefix, String longPrefix) {
        this.uniffleClientCli = new Option(shortPrefix + "c", longPrefix + "cli", true, "This is an client cli command that will print args.");
        this.uniffleAdminCli = new Option(shortPrefix + "a", longPrefix + "admin", true, "This is an admin command that will print args.");
        this.uniffleApplicationCli = new Option(shortPrefix + "app", longPrefix + "applications", false, "The command will be used to print a list of applications.");
        this.uniffleApplicationListCli = new Option(null, longPrefix + "app-list", true, "We can provide an application query list.");
        this.uniffleApplicationRegex = new Option(null, longPrefix + "appId-regex", true, "ApplicationId Regex filter expression.");
        this.uniffleApplicationPageSize = new Option(null, longPrefix + "app-pageSize", true, "Application pagination page number");
        this.uniffleApplicationCurrentPage = new Option(null, longPrefix + "app-currentPage", true, "Application pagination current page");
        this.uniffleApplicationHbTimeRange = new Option(null, longPrefix + "app-heartbeatTimeRange", true, "Application Heartbeat TimeRange");
        this.uniffleOutFormat = new Option(shortPrefix + "o", longPrefix + "output-format", true, "We can use the -o|--output-format json option to output application information to json.We currently only support output in Json format");
        this.uniffleOutPutFile = new Option(shortPrefix + "f", longPrefix + "file", true, "We can use the -f|--file to output information to file");
        this.help = new Option(shortPrefix + "h", longPrefix + "help", false, "Help for the Uniffle CLI.");
        this.allOptions.addOption(this.uniffleClientCli);
        this.allOptions.addOption(this.uniffleAdminCli);
        this.allOptions.addOption(this.uniffleApplicationCli);
        this.allOptions.addOption(this.uniffleApplicationListCli);
        this.allOptions.addOption(this.uniffleApplicationRegex);
        this.allOptions.addOption(this.uniffleApplicationPageSize);
        this.allOptions.addOption(this.uniffleApplicationCurrentPage);
        this.allOptions.addOption(this.coordinatorHost);
        this.allOptions.addOption(this.coordinatorPort);
        this.allOptions.addOption(this.uniffleOutFormat);
        this.allOptions.addOption(this.uniffleOutPutFile);
        this.allOptions.addOption(this.uniffleApplicationHbTimeRange);
        this.allOptions.addOption(this.ssl);
        this.allOptions.addOption(this.help);
    }

    public int run(String[] args) throws UniffleCliArgsException, JsonProcessingException {
        CommandLine cmd = this.parseCommandLineOptions(args, true);
        if (args.length < 1) {
            this.printUsage();
            return 1;
        }
        if (cmd.hasOption(this.help.getOpt())) {
            this.printUsage();
            return 0;
        }
        if (cmd.hasOption(this.uniffleClientCli.getOpt())) {
            String cliArgs = cmd.getOptionValue(this.uniffleClientCli.getOpt());
            System.out.println("uniffle-client-cli : " + cliArgs);
            return 0;
        }
        if (cmd.hasOption(this.uniffleAdminCli.getOpt())) {
            String cliArgs = cmd.getOptionValue(this.uniffleAdminCli.getOpt());
            System.out.println("uniffle-admin-cli : " + cliArgs);
            return 0;
        }
        if (cmd.hasOption(this.coordinatorHost.getOpt()) && cmd.hasOption(this.coordinatorPort.getOpt())) {
            this.getUniffleRestClient(cmd);
            if (cmd.hasOption(this.uniffleApplicationCli.getLongOpt())) {
                LOG.info("uniffle-client-cli : get applications");
                if (cmd.hasOption(this.uniffleOutFormat.getOpt())) {
                    String outPutFormat = cmd.getOptionValue(this.uniffleOutFormat.getOpt()).trim();
                    if (StringUtils.isBlank((CharSequence)outPutFormat)) {
                        System.out.println("output format is not null.");
                        return 1;
                    }
                    if (!StringUtils.equalsAnyIgnoreCase((CharSequence)outPutFormat, (CharSequence[])new CharSequence[]{"json"})) {
                        System.out.println("The output currently supports only JSON format.");
                        return 1;
                    }
                    String json = this.getApplicationsJson(cmd);
                    if (StringUtils.isBlank((CharSequence)json)) {
                        System.out.println("no output result.");
                        return 1;
                    }
                    System.out.println("application: " + json);
                    if (cmd.hasOption(this.uniffleOutPutFile.getOpt())) {
                        String uniffleOutPutFile = cmd.getOptionValue(this.uniffleOutFormat.getOpt()).trim();
                        if (StringUtils.isBlank((CharSequence)uniffleOutPutFile)) {
                            System.out.println("The output file cannot be empty.");
                            return 1;
                        }
                        try (FileOutputStream fos = new FileOutputStream(uniffleOutPutFile);
                             OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, StandardCharsets.UTF_8);){
                            osw.write(json);
                            System.out.println("applications json data has been written to the file(" + uniffleOutPutFile + ").");
                        }
                        catch (IOException e) {
                            System.out.println("An error occurred while writing the applications json data to the file(" + uniffleOutPutFile + ").");
                            return 1;
                        }
                    }
                    return 0;
                }
                try (PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)System.out, StandardCharsets.UTF_8));){
                    CLIContentUtils formattingCLIUtils = new CLIContentUtils("Uniffle Applications").addHeaders(APPLICATIONS_HEADER);
                    List<Application> applications = this.getApplications(cmd);
                    if (applications != null) {
                        applications.forEach(app -> formattingCLIUtils.addLine(app.getApplicationId(), app.getUser(), app.getRegistrationTime(), app.getLastHeartBeatTime(), app.getRemoteStoragePath()));
                    }
                    writer.print(formattingCLIUtils.render());
                    writer.flush();
                    int n = 0;
                    return n;
                }
            }
        }
        return 1;
    }

    @Override
    public void addRunOptions(Options baseOptions) {
        for (Object option : this.allOptions.getOptions()) {
            baseOptions.addOption((Option)option);
        }
    }

    @Override
    public void addGeneralOptions(Options baseOptions) {
        super.addGeneralOptions(baseOptions);
        baseOptions.addOption(this.help);
    }

    private List<Application> getApplications(CommandLine cmd) throws UniffleCliArgsException, JsonProcessingException {
        if (this.client == null) {
            throw new UniffleCliArgsException("Missing Coordinator host address and grpc port parameters.");
        }
        String applications = null;
        if (cmd.hasOption(this.uniffleApplicationListCli.getLongOpt())) {
            applications = cmd.getOptionValue(this.uniffleApplicationListCli.getLongOpt()).trim();
        }
        String applicationIdRegex = null;
        if (cmd.hasOption(this.uniffleApplicationRegex.getLongOpt())) {
            applicationIdRegex = cmd.getOptionValue(this.uniffleApplicationRegex.getLongOpt()).trim();
        }
        String pageSize = null;
        if (cmd.hasOption(this.uniffleApplicationPageSize.getLongOpt())) {
            pageSize = cmd.getOptionValue(this.uniffleApplicationPageSize.getLongOpt()).trim();
        }
        String currentPage = null;
        if (cmd.hasOption(this.uniffleApplicationCurrentPage.getLongOpt())) {
            currentPage = cmd.getOptionValue(this.uniffleApplicationCurrentPage.getLongOpt()).trim();
        }
        String heartBeatTimeRange = null;
        if (cmd.hasOption(this.uniffleApplicationHbTimeRange.getLongOpt())) {
            heartBeatTimeRange = cmd.getOptionValue(this.uniffleApplicationHbTimeRange.getLongOpt()).trim();
        }
        AdminRestApi adminRestApi = new AdminRestApi(this.client);
        return adminRestApi.getApplications(applications, applicationIdRegex, pageSize, currentPage, heartBeatTimeRange);
    }

    private String getApplicationsJson(CommandLine cmd) throws UniffleCliArgsException, JsonProcessingException {
        List<Application> applications = this.getApplications(cmd);
        Gson gson = new Gson();
        return gson.toJson(applications);
    }

    public static void main(String[] args) {
        int retCode;
        try {
            UniffleCLI cli = new UniffleCLI("", "");
            retCode = cli.run(args);
        }
        catch (UniffleCliArgsException e) {
            retCode = AbstractCustomCommandLine.handleCliArgsException(e, LOG);
        }
        catch (Exception e) {
            retCode = AbstractCustomCommandLine.handleError(e, LOG);
        }
        System.exit(retCode);
    }
}

