/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.server;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.uniffle.common.AuditType;
import org.apache.uniffle.common.ShuffleDataDistributionType;
import org.apache.uniffle.common.ShufflePartitionedBlock;
import org.apache.uniffle.common.config.RssBaseConf;
import org.apache.uniffle.common.config.RssConf;
import org.apache.uniffle.common.function.ConsumerWithException;
import org.apache.uniffle.common.util.JavaUtils;
import org.apache.uniffle.common.util.RssUtils;
import org.apache.uniffle.server.DefaultFlushEventHandler;
import org.apache.uniffle.server.FlushEventHandler;
import org.apache.uniffle.server.ShuffleDataFlushEvent;
import org.apache.uniffle.server.ShuffleServer;
import org.apache.uniffle.server.ShuffleServerConf;
import org.apache.uniffle.server.ShuffleServerMetrics;
import org.apache.uniffle.server.ShuffleTaskInfo;
import org.apache.uniffle.server.flush.EventDiscardException;
import org.apache.uniffle.server.flush.EventInvalidException;
import org.apache.uniffle.server.flush.EventRetryException;
import org.apache.uniffle.server.storage.StorageManager;
import org.apache.uniffle.shaded.guava.annotations.VisibleForTesting;
import org.apache.uniffle.storage.common.Storage;
import org.apache.uniffle.storage.handler.api.ShuffleWriteHandlerWrapper;
import org.apache.uniffle.storage.request.CreateShuffleWriteHandlerRequest;
import org.apache.uniffle.storage.util.StorageType;
import org.roaringbitmap.longlong.Roaring64NavigableMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShuffleFlushManager {
    private static final Logger LOG = LoggerFactory.getLogger(ShuffleFlushManager.class);
    private static final Logger AUDIT_LOGGER = LoggerFactory.getLogger((String)"SHUFFLE_SERVER_STORAGE_AUDIT_LOG");
    private static final String AUDIT_DATE_PATTERN = "yyyy-MM-dd HH:mm:ss";
    public static final AtomicLong ATOMIC_EVENT_ID = new AtomicLong(0L);
    private final ShuffleServer shuffleServer;
    private final List<String> storageBasePaths;
    private final String storageType;
    private final int storageDataReplica;
    private final ShuffleServerConf shuffleServerConf;
    private final boolean storageTypeWithMemory;
    private Configuration hadoopConf;
    private Map<String, Map<Integer, Roaring64NavigableMap>> committedBlockIds = JavaUtils.newConcurrentMap();
    private final int retryMax;
    private final StorageManager storageManager;
    private final long pendingEventTimeoutSec;
    private FlushEventHandler eventHandler;
    private boolean isStorageAuditLogEnabled;

    public ShuffleFlushManager(ShuffleServerConf shuffleServerConf, ShuffleServer shuffleServer, StorageManager storageManager) {
        this.shuffleServer = shuffleServer;
        this.shuffleServerConf = shuffleServerConf;
        this.storageManager = storageManager;
        this.initHadoopConf();
        this.retryMax = shuffleServerConf.getInteger(ShuffleServerConf.SERVER_WRITE_RETRY_MAX);
        this.storageType = ((org.apache.uniffle.common.StorageType)shuffleServerConf.get(RssBaseConf.RSS_STORAGE_TYPE)).name();
        this.storageDataReplica = (Integer)shuffleServerConf.get(RssBaseConf.RSS_STORAGE_DATA_REPLICA);
        this.storageBasePaths = RssUtils.getConfiguredLocalDirs((RssConf)shuffleServerConf);
        this.pendingEventTimeoutSec = shuffleServerConf.getLong(ShuffleServerConf.PENDING_EVENT_TIMEOUT_SEC);
        this.eventHandler = new DefaultFlushEventHandler(shuffleServerConf, storageManager, shuffleServer, (ConsumerWithException<ShuffleDataFlushEvent>)((ConsumerWithException)this::processFlushEvent));
        this.isStorageAuditLogEnabled = this.shuffleServerConf.getBoolean(ShuffleServerConf.SERVER_STORAGE_AUDIT_LOG_ENABLED);
        ShuffleServerMetrics.addLabeledCacheGauge("committed_block_count", () -> this.committedBlockIds.values().stream().flatMap(innerMap -> innerMap.values().stream()).mapToLong(bitmap -> bitmap.getLongCardinality()).sum(), 120000L);
        this.storageTypeWithMemory = StorageType.withMemory((StorageType)StorageType.valueOf((String)this.storageType));
    }

    public void addToFlushQueue(ShuffleDataFlushEvent event) {
        this.eventHandler.handle(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processFlushEvent(ShuffleDataFlushEvent event) throws Exception {
        try {
            ShuffleWriteHandlerWrapper handlerWrapper;
            ShuffleServerMetrics.gaugeWriteHandler.inc();
            if (!event.isValid()) {
                LOG.warn("AppId {} was removed already, event:{} should be dropped", (Object)event.getAppId(), (Object)event);
                throw new EventInvalidException();
            }
            if (this.reachRetryMax(event)) {
                LOG.error("The event:{} has been reached to max retry times, it will be dropped.", (Object)event);
                throw new EventDiscardException();
            }
            Collection<ShufflePartitionedBlock> blocks = event.getShuffleBlocks();
            if (CollectionUtils.isEmpty(blocks)) {
                LOG.info("There is no block to be flushed: {}", (Object)event);
                return;
            }
            Storage storage = event.getUnderStorage();
            if (storage == null) {
                LOG.error("Storage selected is null and this should not happen. event: {}", (Object)event);
                throw new EventDiscardException();
            }
            if (event.isPended() && System.currentTimeMillis() - event.getStartPendingTime() > this.pendingEventTimeoutSec * 1000L) {
                LOG.error("Flush event cannot be flushed for {} sec, the event {} is dropped", (Object)this.pendingEventTimeoutSec, (Object)event);
                throw new EventDiscardException();
            }
            if (!storage.canWrite()) {
                LOG.error("The event: {} is limited to flush due to storage:{} can't write", (Object)event, (Object)storage);
                throw new EventRetryException();
            }
            String user = StringUtils.defaultString((String)this.shuffleServer.getShuffleTaskManager().getUserByAppId(event.getAppId()), (String)"");
            int maxConcurrencyPerPartitionToWrite = this.getMaxConcurrencyPerPartitionWrite(event);
            CreateShuffleWriteHandlerRequest request = new CreateShuffleWriteHandlerRequest((RssBaseConf)this.shuffleServerConf, this.storageType, event.getAppId(), event.getShuffleId(), event.getStartPartition(), event.getEndPartition(), this.storageBasePaths.toArray(new String[this.storageBasePaths.size()]), this.getShuffleServerId(), this.hadoopConf, this.storageDataReplica, user, maxConcurrencyPerPartitionToWrite);
            try {
                handlerWrapper = storage.getOrCreateWriteHandler(request);
            }
            catch (Exception e) {
                LOG.warn("Failed to create write handlerWrapper for event: {}", (Object)event, (Object)e);
                throw new EventRetryException(e);
            }
            long startTime = System.currentTimeMillis();
            boolean writeSuccess = this.storageManager.write(storage, handlerWrapper.getHandler(), event);
            if (!writeSuccess) {
                throw new EventRetryException();
            }
            long endTime = System.currentTimeMillis();
            ShuffleTaskInfo shuffleTaskInfo = this.shuffleServer.getShuffleTaskManager().getShuffleTaskInfo(event.getAppId());
            if (shuffleTaskInfo == null || !this.storageTypeWithMemory) {
                this.updateCommittedBlockIds(event.getAppId(), event.getShuffleId(), event.getShuffleBlocks());
            }
            if (this.isStorageAuditLogEnabled) {
                AUDIT_LOGGER.info(String.format("%s|%s|%d|%s|%s|%s|%d|%s|%s|%d", AuditType.WRITE.getValue(), event.getAppId(), event.getShuffleId(), event.getStartPartition() + "_" + event.getEndPartition(), event.getUnderStorage().getStorageHost(), event.getUnderStorage().getStoragePath(), event.getDataLength(), DateFormatUtils.format((long)startTime, (String)AUDIT_DATE_PATTERN), DateFormatUtils.format((long)endTime, (String)AUDIT_DATE_PATTERN), endTime - startTime));
            }
            if (null != shuffleTaskInfo) {
                String storageHost = event.getUnderStorage().getStorageHost();
                if ("local".equals(storageHost)) {
                    shuffleTaskInfo.addOnLocalFileDataSize(event.getEncodedLength(), handlerWrapper.isNewlyCreated());
                } else {
                    shuffleTaskInfo.addOnHadoopDataSize(event.getEncodedLength(), handlerWrapper.isNewlyCreated());
                }
            }
        }
        finally {
            ShuffleServerMetrics.gaugeWriteHandler.dec();
        }
    }

    private boolean reachRetryMax(ShuffleDataFlushEvent event) {
        return event.getRetryTimes() > this.retryMax;
    }

    private int getMaxConcurrencyPerPartitionWrite(ShuffleDataFlushEvent event) {
        ShuffleTaskInfo taskInfo = this.shuffleServer.getShuffleTaskManager().getShuffleTaskInfo(event.getAppId());
        if (taskInfo == null) {
            LOG.warn("Should not happen that shuffle task info of {} is null.", (Object)event.getAppId());
            return (Integer)this.shuffleServerConf.get(ShuffleServerConf.SERVER_MAX_CONCURRENCY_OF_ONE_PARTITION);
        }
        return taskInfo.getMaxConcurrencyPerPartitionToWrite();
    }

    private String getShuffleServerId() {
        return this.shuffleServerConf.getString("rss.server.id", "shuffleServerId");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCommittedBlockIds(String appId, int shuffleId, Collection<ShufflePartitionedBlock> blocks) {
        Roaring64NavigableMap bitmap;
        if (blocks == null || blocks.size() == 0) {
            return;
        }
        this.committedBlockIds.computeIfAbsent(appId, key -> JavaUtils.newConcurrentMap());
        Map<Integer, Roaring64NavigableMap> shuffleToBlockIds = this.committedBlockIds.get(appId);
        shuffleToBlockIds.computeIfAbsent(shuffleId, key -> Roaring64NavigableMap.bitmapOf((long[])new long[0]));
        Roaring64NavigableMap roaring64NavigableMap = bitmap = shuffleToBlockIds.get(shuffleId);
        synchronized (roaring64NavigableMap) {
            for (ShufflePartitionedBlock spb : blocks) {
                bitmap.addLong(spb.getBlockId());
            }
        }
    }

    public Roaring64NavigableMap getCommittedBlockIds(String appId, Integer shuffleId) {
        Map<Integer, Roaring64NavigableMap> shuffleIdToBlockIds = this.committedBlockIds.get(appId);
        if (shuffleIdToBlockIds == null) {
            LOG.warn("Unexpected value when getCommittedBlockIds for appId[" + appId + "]");
            return Roaring64NavigableMap.bitmapOf((long[])new long[0]);
        }
        Roaring64NavigableMap blockIds = shuffleIdToBlockIds.get(shuffleId);
        if (blockIds == null) {
            LOG.warn("Unexpected value when getCommittedBlockIds for appId[" + appId + "], shuffleId[" + shuffleId + "]");
            return Roaring64NavigableMap.bitmapOf((long[])new long[0]);
        }
        return blockIds;
    }

    public void removeResources(String appId) {
        this.committedBlockIds.remove(appId);
    }

    protected void initHadoopConf() {
        this.hadoopConf = new Configuration();
        for (String key : this.shuffleServerConf.getKeySet()) {
            if (!key.startsWith("rss.server.hadoop")) continue;
            String value = this.shuffleServerConf.getString(key, "");
            String hadoopKey = key.substring("rss.server.hadoop".length() + 1);
            LOG.info("Update hadoop configuration:" + hadoopKey + "=" + value);
            this.hadoopConf.set(hadoopKey, value);
        }
    }

    public int getEventNumInFlush() {
        return this.eventHandler.getEventNumInFlush();
    }

    public Configuration getHadoopConf() {
        return this.hadoopConf;
    }

    public void removeResourcesOfShuffleId(String appId, Collection<Integer> shuffleIds) {
        Optional.ofNullable(this.committedBlockIds.get(appId)).ifPresent(shuffleIdToBlockIds -> shuffleIds.forEach(shuffleIdToBlockIds::remove));
    }

    public ShuffleDataDistributionType getDataDistributionType(String appId) {
        return this.shuffleServer.getShuffleTaskManager().getDataDistributionType(appId);
    }

    @VisibleForTesting
    public FlushEventHandler getEventHandler() {
        return this.eventHandler;
    }
}

