/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.server;

import org.apache.uniffle.common.config.RssConf;
import org.apache.uniffle.common.metrics.NettyMetrics;
import org.apache.uniffle.common.netty.protocol.GetLocalShuffleDataRequest;
import org.apache.uniffle.common.netty.protocol.GetLocalShuffleIndexRequest;
import org.apache.uniffle.common.netty.protocol.GetMemoryShuffleDataRequest;
import org.apache.uniffle.common.netty.protocol.GetSortedShuffleDataRequest;
import org.apache.uniffle.common.netty.protocol.SendShuffleDataRequest;
import org.apache.uniffle.server.ShuffleServerConf;

public class ShuffleServerNettyMetrics
extends NettyMetrics {
    private static final String _TRANSPORT_LATENCY = "_transport_latency";
    private static final String _PROCESS_LATENCY = "_process_latency";
    private static final String _TOTAL = "_total";
    private static final String NETTY_SEND_SHUFFLE_DATA_REQUEST = "netty_send_shuffle_data_request";
    private static final String NETTY_GET_SHUFFLE_DATA_REQUEST = "netty_get_local_shuffle_data_request";
    private static final String NETTY_GET_SHUFFLE_INDEX_REQUEST = "netty_get_local_shuffle_index_request";
    private static final String NETTY_GET_MEMORY_SHUFFLE_DATA_REQUEST = "netty_get_memory_shuffle_data_request";
    private static final String NETTY_GET_SORTED_SHUFFLE_DATA_REQUEST = "netty_get_sorted_shuffle_data_request";

    public ShuffleServerNettyMetrics(ShuffleServerConf shuffleServerConf, String tags) {
        super((RssConf)shuffleServerConf, tags);
    }

    public void registerMetrics() {
        this.gaugeMap.putIfAbsent(SendShuffleDataRequest.class.getName(), this.metricsManager.addLabeledGauge(NETTY_SEND_SHUFFLE_DATA_REQUEST));
        this.gaugeMap.putIfAbsent(GetLocalShuffleDataRequest.class.getName(), this.metricsManager.addLabeledGauge(NETTY_GET_SHUFFLE_DATA_REQUEST));
        this.gaugeMap.putIfAbsent(GetLocalShuffleIndexRequest.class.getName(), this.metricsManager.addLabeledGauge(NETTY_GET_SHUFFLE_INDEX_REQUEST));
        this.gaugeMap.putIfAbsent(GetMemoryShuffleDataRequest.class.getName(), this.metricsManager.addLabeledGauge(NETTY_GET_MEMORY_SHUFFLE_DATA_REQUEST));
        this.gaugeMap.putIfAbsent(GetSortedShuffleDataRequest.class.getName(), this.metricsManager.addLabeledGauge(NETTY_GET_SORTED_SHUFFLE_DATA_REQUEST));
        this.counterMap.putIfAbsent(SendShuffleDataRequest.class.getName(), this.metricsManager.addLabeledCounter("netty_send_shuffle_data_request_total"));
        this.counterMap.putIfAbsent(GetLocalShuffleDataRequest.class.getName(), this.metricsManager.addLabeledCounter("netty_get_local_shuffle_data_request_total"));
        this.counterMap.putIfAbsent(GetLocalShuffleIndexRequest.class.getName(), this.metricsManager.addLabeledCounter("netty_get_local_shuffle_index_request_total"));
        this.counterMap.putIfAbsent(GetMemoryShuffleDataRequest.class.getName(), this.metricsManager.addLabeledCounter("netty_get_memory_shuffle_data_request_total"));
        this.counterMap.putIfAbsent(GetSortedShuffleDataRequest.class.getName(), this.metricsManager.addLabeledCounter("netty_get_sorted_shuffle_data_request_total"));
        this.transportTimeSummaryMap.putIfAbsent(SendShuffleDataRequest.class.getName(), this.metricsManager.addLabeledSummary("netty_send_shuffle_data_request_transport_latency"));
        this.transportTimeSummaryMap.putIfAbsent(GetLocalShuffleDataRequest.class.getName(), this.metricsManager.addLabeledSummary("netty_get_local_shuffle_data_request_transport_latency"));
        this.transportTimeSummaryMap.putIfAbsent(GetLocalShuffleIndexRequest.class.getName(), this.metricsManager.addLabeledSummary("netty_get_local_shuffle_index_request_transport_latency"));
        this.transportTimeSummaryMap.putIfAbsent(GetMemoryShuffleDataRequest.class.getName(), this.metricsManager.addLabeledSummary("netty_get_memory_shuffle_data_request_transport_latency"));
        this.transportTimeSummaryMap.putIfAbsent(GetSortedShuffleDataRequest.class.getName(), this.metricsManager.addLabeledSummary("netty_get_sorted_shuffle_data_request_transport_latency"));
        this.processTimeSummaryMap.putIfAbsent(SendShuffleDataRequest.class.getName(), this.metricsManager.addLabeledSummary("netty_send_shuffle_data_request_process_latency"));
        this.processTimeSummaryMap.putIfAbsent(GetLocalShuffleDataRequest.class.getName(), this.metricsManager.addLabeledSummary("netty_get_local_shuffle_data_request_process_latency"));
        this.processTimeSummaryMap.putIfAbsent(GetLocalShuffleIndexRequest.class.getName(), this.metricsManager.addLabeledSummary("netty_get_local_shuffle_index_request_process_latency"));
        this.processTimeSummaryMap.putIfAbsent(GetMemoryShuffleDataRequest.class.getName(), this.metricsManager.addLabeledSummary("netty_get_memory_shuffle_data_request_process_latency"));
        this.processTimeSummaryMap.putIfAbsent(GetSortedShuffleDataRequest.class.getName(), this.metricsManager.addLabeledSummary("netty_get_sorted_shuffle_data_request_process_latency"));
    }
}

