/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.server.buffer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.uniffle.common.BufferSegment;
import org.apache.uniffle.common.ShuffleDataDistributionType;
import org.apache.uniffle.common.ShufflePartitionedBlock;
import org.apache.uniffle.common.ShufflePartitionedData;
import org.apache.uniffle.common.util.JavaUtils;
import org.apache.uniffle.server.ShuffleDataFlushEvent;
import org.apache.uniffle.server.ShuffleFlushManager;
import org.apache.uniffle.server.buffer.AbstractShuffleBuffer;
import org.apache.uniffle.shaded.guava.collect.Lists;
import org.roaringbitmap.longlong.Roaring64NavigableMap;

public class ShuffleBufferWithSkipList
extends AbstractShuffleBuffer {
    private ConcurrentSkipListMap<Long, ShufflePartitionedBlock> blocksMap = this.newConcurrentSkipListMap();
    private final Map<Long, ConcurrentSkipListMap<Long, ShufflePartitionedBlock>> inFlushBlockMap = JavaUtils.newConcurrentMap();
    private int blockCount;

    private ConcurrentSkipListMap<Long, ShufflePartitionedBlock> newConcurrentSkipListMap() {
        return new ConcurrentSkipListMap<Long, ShufflePartitionedBlock>(Comparator.comparingLong(Long::reverse));
    }

    @Override
    public synchronized long append(ShufflePartitionedData data) {
        if (this.evicted) {
            return -1L;
        }
        long currentEncodedLength = 0L;
        long currentDataLength = 0L;
        for (ShufflePartitionedBlock block : data.getBlockList()) {
            if (!this.blocksMap.containsKey(block.getBlockId())) {
                this.addBlock(block);
                ++this.blockCount;
                currentEncodedLength += block.getEncodedLength();
                currentDataLength += (long)block.getDataLength();
                continue;
            }
            this.releaseBlock(block);
        }
        this.encodedLength += currentEncodedLength;
        this.dataLength += currentDataLength;
        return currentEncodedLength;
    }

    protected void addBlock(ShufflePartitionedBlock block) {
        this.blocksMap.put(block.getBlockId(), block);
    }

    protected void releaseBlock(ShufflePartitionedBlock block) {
        block.getData().release();
    }

    @Override
    public synchronized ShuffleDataFlushEvent toFlushEvent(String appId, int shuffleId, int startPartition, int endPartition, Supplier<Boolean> isValid, ShuffleDataDistributionType dataDistributionType) {
        if (this.blocksMap.isEmpty()) {
            return null;
        }
        Collection<ShufflePartitionedBlock> spBlocks = this.blocksMap.values();
        long eventId = ShuffleFlushManager.ATOMIC_EVENT_ID.getAndIncrement();
        ShuffleDataFlushEvent event = new ShuffleDataFlushEvent(eventId, appId, shuffleId, startPartition, endPartition, this.encodedLength, this.dataLength, spBlocks, isValid, this);
        event.addCleanupCallback(this.createCallbackForFlush(event));
        this.inFlushBlockMap.put(eventId, this.blocksMap);
        this.blocksMap = this.newConcurrentSkipListMap();
        this.blockCount = 0;
        this.inFlushSize.addAndGet(this.encodedLength);
        this.encodedLength = 0L;
        this.dataLength = 0L;
        return event;
    }

    protected Runnable createCallbackForFlush(ShuffleDataFlushEvent event) {
        return () -> {
            this.clearInFlushBuffer(event.getEventId());
            event.getShuffleBlocks().forEach(this::releaseBlock);
            this.inFlushSize.addAndGet(-event.getEncodedLength());
        };
    }

    @Override
    public Set<ShufflePartitionedBlock> getBlocks() {
        return new LinkedHashSet<ShufflePartitionedBlock>(this.blocksMap.values());
    }

    @Override
    public int getBlockCount() {
        return this.blockCount;
    }

    @Override
    public long getInFlushBlockCount() {
        return this.inFlushBlockMap.values().stream().mapToLong(Map::size).sum();
    }

    @Override
    public int getInFlushEventCount() {
        return this.inFlushBlockMap.size();
    }

    @Override
    public synchronized long release() {
        Throwable lastException = null;
        int failedToReleaseSize = 0;
        long releasedSize = 0L;
        this.evicted = true;
        for (ShufflePartitionedBlock spb : this.blocksMap.values()) {
            try {
                this.releaseBlock(spb);
                releasedSize += spb.getEncodedLength();
            }
            catch (Throwable t) {
                lastException = t;
                failedToReleaseSize = (int)((long)failedToReleaseSize + spb.getEncodedLength());
            }
        }
        if (lastException != null) {
            LOG.warn("Failed to release shuffle blocks with size (). Maybe it has been released by others.", (Object)failedToReleaseSize, lastException);
        }
        return releasedSize;
    }

    @Override
    public synchronized void clearInFlushBuffer(long eventId) {
        this.inFlushBlockMap.remove(eventId);
    }

    @Override
    public Map<Long, Set<ShufflePartitionedBlock>> getInFlushBlockMap() {
        return this.inFlushBlockMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> new LinkedHashSet(((ConcurrentSkipListMap)e.getValue()).values())));
    }

    @Override
    protected void updateBufferSegmentsAndResultBlocks(long lastBlockId, long readBufferSize, List<BufferSegment> bufferSegments, List<ShufflePartitionedBlock> resultBlocks, Roaring64NavigableMap expectedTaskIds) {
        long nextBlockId = lastBlockId;
        ArrayList<Long> eventIdList = Lists.newArrayList(this.inFlushBlockMap.keySet());
        List<Long> sortedEventId = this.sortFlushingEventId(eventIdList);
        int offset = 0;
        boolean hasLastBlockId = false;
        if (!this.inFlushBlockMap.isEmpty()) {
            for (Long eventId : sortedEventId) {
                hasLastBlockId = this.updateSegments(offset, this.inFlushBlockMap.get(eventId), readBufferSize, nextBlockId, bufferSegments, resultBlocks, expectedTaskIds);
                if (hasLastBlockId) {
                    nextBlockId = -1L;
                }
                if (!bufferSegments.isEmpty()) {
                    offset = this.calculateDataLength(bufferSegments);
                }
                if ((long)offset < readBufferSize) continue;
                break;
            }
        }
        if (!this.blocksMap.isEmpty() && (long)offset < readBufferSize) {
            hasLastBlockId = this.updateSegments(offset, this.blocksMap, readBufferSize, nextBlockId, bufferSegments, resultBlocks, expectedTaskIds);
        }
        if (!(this.inFlushBlockMap.isEmpty() && this.blocksMap.isEmpty() || offset != 0 || hasLastBlockId)) {
            this.updateBufferSegmentsAndResultBlocks(-1L, readBufferSize, bufferSegments, resultBlocks, expectedTaskIds);
        }
    }

    private boolean updateSegments(int offset, ConcurrentSkipListMap<Long, ShufflePartitionedBlock> cachedBlocks, long readBufferSize, long lastBlockId, List<BufferSegment> bufferSegments, List<ShufflePartitionedBlock> readBlocks, Roaring64NavigableMap expectedTaskIds) {
        NavigableMap<Long, Object> remainingBlocks;
        int currentOffset = offset;
        if (lastBlockId == -1L) {
            remainingBlocks = cachedBlocks;
        } else {
            if (cachedBlocks.get(lastBlockId) == null) {
                return false;
            }
            remainingBlocks = cachedBlocks.tailMap((Object)lastBlockId, false);
        }
        boolean hasLastBlockId = true;
        for (ShufflePartitionedBlock block : remainingBlocks.values()) {
            if (expectedTaskIds != null && !expectedTaskIds.contains(block.getTaskAttemptId())) continue;
            bufferSegments.add(new BufferSegment(block.getBlockId(), (long)currentOffset, block.getDataLength(), block.getUncompressLength(), block.getCrc(), block.getTaskAttemptId()));
            readBlocks.add(block);
            if ((long)(currentOffset += block.getDataLength()) < readBufferSize) continue;
            break;
        }
        return hasLastBlockId;
    }

    public synchronized ShufflePartitionedBlock getBlock(long blockId) {
        ShufflePartitionedBlock block = this.blocksMap.get(blockId);
        if (block == null) {
            for (ConcurrentSkipListMap<Long, ShufflePartitionedBlock> map : this.inFlushBlockMap.values()) {
                if (!map.containsKey(blockId)) continue;
                return map.get(blockId);
            }
        }
        return block;
    }
}

