/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.server.buffer.lab;

import io.netty.buffer.ByteBuf;

public abstract class Chunk {
    protected ByteBuf data;
    protected final int size;
    private final int id;
    private final boolean fromPool;

    public Chunk(int size, int id) {
        this(size, id, false);
    }

    public Chunk(int size, int id, boolean fromPool) {
        this.size = size;
        this.id = id;
        this.fromPool = fromPool;
    }

    int getId() {
        return this.id;
    }

    boolean isFromPool() {
        return this.fromPool;
    }

    public void init() {
        this.allocateDataBuffer();
    }

    abstract void allocateDataBuffer();

    public int getAllocOffset(int size) {
        if (this.data.writerIndex() + size > this.data.capacity()) {
            return -1;
        }
        return this.data.writerIndex();
    }

    void reset() {
        this.data.clear();
    }

    ByteBuf getData() {
        return this.data;
    }
}

