/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.server.merge;

import java.io.IOException;
import java.util.Comparator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.uniffle.common.config.RssConf;
import org.apache.uniffle.common.util.JavaUtils;
import org.apache.uniffle.server.ShuffleServer;
import org.apache.uniffle.server.merge.MergeEventHandler;
import org.apache.uniffle.server.merge.Partition;
import org.apache.uniffle.shaded.guava.annotations.VisibleForTesting;
import org.roaringbitmap.longlong.Roaring64NavigableMap;

public class Shuffle<K, V> {
    final RssConf serverConf;
    final String appId;
    final int shuffleId;
    final Class<K> kClass;
    final Class<V> vClass;
    final Comparator<K> comparator;
    final MergeEventHandler eventHandler;
    final ShuffleServer shuffleServer;
    private final Map<Integer, Partition<K, V>> partitions = JavaUtils.newConcurrentMap();
    final int mergedBlockSize;
    final ClassLoader classLoader;
    boolean direct = false;

    public Shuffle(RssConf rssConf, MergeEventHandler eventHandler, ShuffleServer shuffleServer, String appId, int shuffleId, Class<K> kClass, Class<V> vClass, Comparator<K> comparator, int mergedBlockSize, ClassLoader classLoader) {
        this.serverConf = rssConf;
        this.eventHandler = eventHandler;
        this.shuffleServer = shuffleServer;
        this.appId = appId;
        this.shuffleId = shuffleId;
        this.kClass = kClass;
        this.vClass = vClass;
        this.comparator = comparator;
        this.mergedBlockSize = mergedBlockSize;
        this.classLoader = classLoader;
    }

    public void startSortMerge(int partitionId, Roaring64NavigableMap expectedBlockIdMap) throws IOException {
        AtomicReference exception = new AtomicReference();
        Partition partition = this.partitions.computeIfAbsent(partitionId, key -> {
            try {
                return new Partition(this, partitionId);
            }
            catch (IOException e) {
                exception.set(e);
                return null;
            }
        });
        if (exception.get() != null) {
            throw (IOException)exception.get();
        }
        assert (partition != null);
        partition.startSortMerge(expectedBlockIdMap);
    }

    void cleanup() {
        for (Partition<K, V> partition : this.partitions.values()) {
            partition.cleanup();
        }
        this.partitions.clear();
    }

    public void setDirect(boolean direct) throws IOException {
        this.direct = direct;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @VisibleForTesting
    Partition getPartition(int partition) {
        return this.partitions.get(partition);
    }
}

