/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.server.web.resource;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import org.apache.hbase.thirdparty.javax.ws.rs.GET;
import org.apache.hbase.thirdparty.javax.ws.rs.Path;
import org.apache.hbase.thirdparty.javax.ws.rs.core.Context;
import org.apache.uniffle.common.util.ThreadUtils;
import org.apache.uniffle.common.web.resource.BaseResource;
import org.apache.uniffle.common.web.resource.ConfOpsResource;
import org.apache.uniffle.common.web.resource.MetricResource;
import org.apache.uniffle.common.web.resource.PrometheusMetricResource;
import org.apache.uniffle.common.web.resource.Response;
import org.apache.uniffle.server.ShuffleServer;
import org.apache.uniffle.server.ShuffleServerConf;
import org.apache.uniffle.server.web.vo.ServerConfVO;

@Path(value="/api/shuffleServer")
public class ServerResource
extends BaseResource {
    @Context
    protected ServletContext servletContext;

    @GET
    @Path(value="/conf")
    public Response<List<ServerConfVO>> getShuffleServerConf() {
        return this.execute(() -> {
            ShuffleServerConf serverConf = this.getShuffleServer().getShuffleServerConf();
            Set allEntry = serverConf.getAll();
            ArrayList<ServerConfVO> serverConfVOs = new ArrayList<ServerConfVO>();
            for (Map.Entry stringObjectEntry : allEntry) {
                ServerConfVO result = new ServerConfVO((String)stringObjectEntry.getKey(), String.valueOf(stringObjectEntry.getValue()));
                serverConfVOs.add(result);
            }
            return serverConfVOs;
        });
    }

    @Path(value="/metrics")
    public Class<MetricResource> getMetricResource() {
        return MetricResource.class;
    }

    @Path(value="/prometheus/metrics")
    public Class<PrometheusMetricResource> getPrometheusMetricResource() {
        return PrometheusMetricResource.class;
    }

    @GET
    @Path(value="/stacks")
    public String getShuffleServerStacks() {
        StringBuilder builder = new StringBuilder();
        ThreadUtils.printThreadInfo((StringBuilder)builder, (String)"");
        return builder.toString();
    }

    @Path(value="/conf/ops")
    public Class<ConfOpsResource> getConfOps() {
        return ConfOpsResource.class;
    }

    private ShuffleServer getShuffleServer() {
        return (ShuffleServer)this.servletContext.getAttribute(ShuffleServer.class.getCanonicalName());
    }
}

