/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.client.impl.grpc;

import io.grpc.ManagedChannel;
import io.grpc.netty.shaded.io.grpc.netty.NettyChannelBuilder;
import io.grpc.netty.shaded.io.netty.channel.ChannelOption;
import java.util.concurrent.TimeUnit;
import org.apache.uniffle.common.util.GrpcNettyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GrpcClient {
    private static final Logger logger = LoggerFactory.getLogger(GrpcClient.class);
    protected String host;
    protected int port;
    protected boolean usePlaintext;
    protected int maxRetryAttempts;
    protected ManagedChannel channel;

    protected GrpcClient(String host, int port, int maxRetryAttempts, boolean usePlaintext) {
        this(host, port, maxRetryAttempts, usePlaintext, 0, 0, 0, -1);
    }

    protected GrpcClient(String host, int port, int maxRetryAttempts, boolean usePlaintext, int pageSize, int maxOrder, int smallCacheSize, int nettyEventLoopThreads) {
        this.host = host;
        this.port = port;
        this.maxRetryAttempts = maxRetryAttempts;
        this.usePlaintext = usePlaintext;
        if (nettyEventLoopThreads > 0) {
            System.setProperty("io.grpc.netty.shaded.io.netty.eventLoopThreads", String.valueOf(nettyEventLoopThreads));
        }
        NettyChannelBuilder channelBuilder = NettyChannelBuilder.forAddress((String)host, (int)port).withOption(ChannelOption.ALLOCATOR, (Object)GrpcNettyUtils.getSharedPooledByteBufAllocator((int)pageSize, (int)maxOrder, (int)smallCacheSize));
        if (usePlaintext) {
            channelBuilder.usePlaintext();
        }
        if (maxRetryAttempts > 0) {
            ((NettyChannelBuilder)channelBuilder.enableRetry()).maxRetryAttempts(maxRetryAttempts);
        }
        channelBuilder.maxInboundMessageSize(Integer.MAX_VALUE);
        this.channel = channelBuilder.build();
    }

    protected GrpcClient(ManagedChannel channel) {
        this.channel = channel;
    }

    public void close() {
        try {
            this.channel.shutdown().awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            logger.error("Can't close GRPC client to " + this.host + ":" + this.port);
        }
    }
}

