/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.client.impl.grpc;

import io.grpc.Channel;
import java.util.concurrent.TimeUnit;
import org.apache.uniffle.client.api.ShuffleServerInternalClient;
import org.apache.uniffle.client.impl.grpc.GrpcClient;
import org.apache.uniffle.client.request.RssCancelDecommissionRequest;
import org.apache.uniffle.client.request.RssDecommissionRequest;
import org.apache.uniffle.client.response.RssCancelDecommissionResponse;
import org.apache.uniffle.client.response.RssDecommissionResponse;
import org.apache.uniffle.common.rpc.StatusCode;
import org.apache.uniffle.proto.RssProtos;
import org.apache.uniffle.proto.ShuffleServerInternalGrpc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShuffleServerInternalGrpcClient
extends GrpcClient
implements ShuffleServerInternalClient {
    private static final Logger LOG = LoggerFactory.getLogger(ShuffleServerInternalGrpcClient.class);
    private static final long RPC_TIMEOUT_DEFAULT_MS = 60000L;
    private long rpcTimeout = 60000L;
    private ShuffleServerInternalGrpc.ShuffleServerInternalBlockingStub blockingStub = ShuffleServerInternalGrpc.newBlockingStub((Channel)this.channel);

    public ShuffleServerInternalGrpcClient(String host, int port) {
        this(host, port, 3);
    }

    public ShuffleServerInternalGrpcClient(String host, int port, int maxRetryAttempts) {
        this(host, port, maxRetryAttempts, true);
    }

    public ShuffleServerInternalGrpcClient(String host, int port, int maxRetryAttempts, boolean usePlaintext) {
        super(host, port, maxRetryAttempts, usePlaintext);
    }

    public ShuffleServerInternalGrpc.ShuffleServerInternalBlockingStub getBlockingStub() {
        return (ShuffleServerInternalGrpc.ShuffleServerInternalBlockingStub)this.blockingStub.withDeadlineAfter(this.rpcTimeout, TimeUnit.MILLISECONDS);
    }

    @Override
    public RssDecommissionResponse decommission(RssDecommissionRequest request) {
        RssProtos.DecommissionRequest protoRequest = RssProtos.DecommissionRequest.newBuilder().build();
        RssProtos.DecommissionResponse rpcResponse = this.getBlockingStub().decommission(protoRequest);
        return new RssDecommissionResponse(StatusCode.fromProto((RssProtos.StatusCode)rpcResponse.getStatus()), rpcResponse.getRetMsg());
    }

    @Override
    public RssCancelDecommissionResponse cancelDecommission(RssCancelDecommissionRequest rssCancelDecommissionRequest) {
        RssProtos.CancelDecommissionRequest protoRequest = RssProtos.CancelDecommissionRequest.newBuilder().build();
        RssProtos.CancelDecommissionResponse rpcResponse = this.getBlockingStub().cancelDecommission(protoRequest);
        return new RssCancelDecommissionResponse(StatusCode.fromProto((RssProtos.StatusCode)rpcResponse.getStatus()), rpcResponse.getRetMsg());
    }
}

