/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.storage.handler.impl;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.uniffle.common.filesystem.HadoopFilesystemProvider;
import org.apache.uniffle.storage.api.FileReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HadoopFileReader
implements FileReader,
Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(HadoopFileReader.class);
    private Path path;
    private Configuration hadoopConf;
    private FSDataInputStream fsDataInputStream;
    private FileSystem fileSystem;

    public HadoopFileReader(Path path, Configuration hadoopConf) throws Exception {
        this.path = path;
        this.hadoopConf = hadoopConf;
        this.createStream();
    }

    private void createStream() throws Exception {
        this.fileSystem = HadoopFilesystemProvider.getFilesystem((Path)this.path, (Configuration)this.hadoopConf);
        if (!this.fileSystem.isFile(this.path)) {
            String msg = this.path + " don't exist or is not a file.";
            LOG.error(msg);
            throw new IllegalStateException(msg);
        }
        this.fsDataInputStream = this.fileSystem.open(this.path);
    }

    @Override
    public byte[] read(long offset, int length) {
        try {
            this.fsDataInputStream.seek(offset);
            byte[] buf = new byte[length];
            this.fsDataInputStream.readFully(buf);
            return buf;
        }
        catch (Exception e) {
            LOG.warn("Can't read data for path:" + this.path + " with offset[" + offset + "], length[" + length + "]", (Throwable)e);
            return new byte[0];
        }
    }

    @Override
    public byte[] read() {
        try {
            return IOUtils.toByteArray((InputStream)this.fsDataInputStream);
        }
        catch (IOException e) {
            LOG.error("Fail to read all data from {}", (Object)this.path, (Object)e);
            return new byte[0];
        }
    }

    @Override
    public ByteBuffer readAsByteBuffer(long offset, int length) {
        try {
            this.fsDataInputStream.seek(offset);
            ByteBuffer buffer = ByteBuffer.allocateDirect(length);
            this.readFully(buffer);
            buffer.flip();
            return buffer;
        }
        catch (Exception e) {
            LOG.warn("Can't read buffer data for path:" + this.path + " with offset[" + offset + "], length[" + length + "]", (Throwable)e);
            return ByteBuffer.allocateDirect(0);
        }
    }

    @Override
    public ByteBuffer readAsByteBuffer() {
        try {
            long length = this.getFileLen();
            if (length - this.fsDataInputStream.getPos() > Integer.MAX_VALUE) {
                LOG.warn("File " + this.path + "length is too long");
                return ByteBuffer.allocateDirect(0);
            }
            return this.readAsByteBuffer(this.fsDataInputStream.getPos(), (int)length);
        }
        catch (Exception e) {
            LOG.warn("Can't read buffer data for path:" + this.path, (Throwable)e);
            return ByteBuffer.allocateDirect(0);
        }
    }

    public long getOffset() throws IOException {
        return this.fsDataInputStream.getPos();
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.fsDataInputStream != null) {
            this.fsDataInputStream.close();
        }
    }

    private void readFully(ByteBuffer buffer) throws IOException {
        while (buffer.hasRemaining()) {
            int result = this.fsDataInputStream.read(buffer);
            if (result >= 0) continue;
            return;
        }
    }

    public Path getPath() {
        return this.path;
    }

    public long getFileLen() throws IOException {
        return this.fileSystem.getFileStatus(this.path).getLen();
    }
}

