/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.impl.EndpointKey;
import org.apache.camel.spi.EndpointRegistry;
import org.apache.camel.util.CamelContextHelper;
import org.apache.camel.util.LRUCache;
import org.apache.camel.util.ServiceHelper;

public class DefaultEndpointRegistry
extends LRUCache<EndpointKey, Endpoint>
implements EndpointRegistry<EndpointKey> {
    private static final long serialVersionUID = 1L;
    private ConcurrentMap<EndpointKey, Endpoint> staticMap = new ConcurrentHashMap<EndpointKey, Endpoint>();
    private final CamelContext context;

    public DefaultEndpointRegistry(CamelContext context) {
        super(CamelContextHelper.getMaximumEndpointCacheSize(context), CamelContextHelper.getMaximumEndpointCacheSize(context), false);
        this.context = context;
    }

    public DefaultEndpointRegistry(CamelContext context, Map<EndpointKey, Endpoint> endpoints) {
        this(context);
        this.putAll((Map<? extends EndpointKey, ? extends Endpoint>)endpoints);
    }

    @Override
    public void start() throws Exception {
        this.resetStatistics();
    }

    @Override
    public Endpoint get(Object o) {
        Endpoint answer = (Endpoint)this.staticMap.get(o);
        if (answer == null) {
            answer = (Endpoint)super.get(o);
        } else {
            this.hits.increment();
        }
        return answer;
    }

    @Override
    public Endpoint put(EndpointKey key, Endpoint endpoint) {
        Endpoint answer = (Endpoint)this.staticMap.remove(key);
        if (answer != null) {
            this.staticMap.put(key, endpoint);
            return answer;
        }
        answer = (Endpoint)super.remove(key);
        if (answer != null) {
            super.put(key, endpoint);
            return answer;
        }
        answer = this.context.isSetupRoutes() || this.context.isStartingRoutes() ? this.staticMap.put(key, endpoint) : super.put(key, endpoint);
        return answer;
    }

    @Override
    public void putAll(Map<? extends EndpointKey, ? extends Endpoint> map) {
        for (Map.Entry<? extends EndpointKey, ? extends Endpoint> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public boolean containsKey(Object o) {
        return this.staticMap.containsKey(o) || super.containsKey(o);
    }

    @Override
    public boolean containsValue(Object o) {
        return this.staticMap.containsValue(o) || super.containsValue(o);
    }

    @Override
    public int size() {
        return this.staticMap.size() + super.size();
    }

    @Override
    public int staticSize() {
        return this.staticMap.size();
    }

    @Override
    public int dynamicSize() {
        return super.size();
    }

    @Override
    public boolean isEmpty() {
        return this.staticMap.isEmpty() && super.isEmpty();
    }

    @Override
    public Endpoint remove(Object o) {
        Endpoint answer = (Endpoint)this.staticMap.remove(o);
        if (answer == null) {
            answer = (Endpoint)super.remove(o);
        }
        return answer;
    }

    @Override
    public void clear() {
        this.staticMap.clear();
        super.clear();
    }

    @Override
    public Set<EndpointKey> keySet() {
        LinkedHashSet<EndpointKey> answer = new LinkedHashSet<EndpointKey>();
        answer.addAll(this.staticMap.keySet());
        answer.addAll(super.keySet());
        return answer;
    }

    @Override
    public Collection<Endpoint> values() {
        ArrayList<Endpoint> answer = new ArrayList<Endpoint>();
        answer.addAll(this.staticMap.values());
        answer.addAll(super.values());
        return answer;
    }

    @Override
    public Set<Map.Entry<EndpointKey, Endpoint>> entrySet() {
        LinkedHashSet<Map.Entry<EndpointKey, Endpoint>> answer = new LinkedHashSet<Map.Entry<EndpointKey, Endpoint>>();
        answer.addAll(this.staticMap.entrySet());
        answer.addAll(super.entrySet());
        return answer;
    }

    @Override
    public int getMaximumCacheSize() {
        return super.getMaxCacheSize();
    }

    @Override
    public void purge() {
        super.clear();
    }

    @Override
    public boolean isStatic(String key) {
        return this.staticMap.containsKey(new EndpointKey(key));
    }

    @Override
    public boolean isDynamic(String key) {
        return super.containsKey(new EndpointKey(key));
    }

    @Override
    public void stop() throws Exception {
        ServiceHelper.stopServices(this.staticMap.values());
        ServiceHelper.stopServices(this.values());
        this.purge();
    }

    @Override
    public String toString() {
        return "EndpointRegistry for " + this.context.getName() + ", capacity: " + this.getMaxCacheSize();
    }
}

