/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.persistence.spi;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.UntypedObjectDeserializer;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class PropertyTypedObjectDeserializer
extends UntypedObjectDeserializer {
    private static final long serialVersionUID = -2561171359946902967L;
    private Map<String, Class<? extends Object>> registry = new LinkedHashMap<String, Class<? extends Object>>();
    private Map<String, Set<String>> fieldValuesToMatch = new LinkedHashMap<String, Set<String>>();

    public PropertyTypedObjectDeserializer(JavaType listType, JavaType mapType) {
        super(listType, mapType);
    }

    public void registerMapping(String matchExpression, Class<? extends Object> mappedClass) {
        this.registry.put(matchExpression, mappedClass);
        String[] fieldParts = matchExpression.split("=");
        Set<String> valuesToMatch = this.fieldValuesToMatch.get(fieldParts[0]);
        if (valuesToMatch == null) {
            valuesToMatch = new LinkedHashSet<String>();
        }
        valuesToMatch.add(fieldParts[1]);
        this.fieldValuesToMatch.put(fieldParts[0], valuesToMatch);
    }

    public Object deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        if (jp.currentTokenId() != 1) {
            return super.deserialize(jp, ctxt);
        }
        ObjectCodec codec = jp.getCodec();
        TreeNode treeNode = codec.readTree(jp);
        Class objectClass = null;
        if (treeNode instanceof ObjectNode) {
            ObjectNode root = (ObjectNode)treeNode;
            Iterator elementsIterator = root.fields();
            while (elementsIterator.hasNext()) {
                Map.Entry element = (Map.Entry)elementsIterator.next();
                String name = (String)element.getKey();
                if (!this.fieldValuesToMatch.containsKey(name)) continue;
                Set<String> valuesToMatch = this.fieldValuesToMatch.get(name);
                for (String valueToMatch : valuesToMatch) {
                    if (!((JsonNode)element.getValue()).asText().matches(valueToMatch)) continue;
                    objectClass = this.registry.get(name + "=" + valueToMatch);
                    break;
                }
                if (objectClass == null) continue;
                break;
            }
            if (objectClass == null) {
                objectClass = HashMap.class;
            }
        }
        if (objectClass == null) {
            return super.deserialize(codec.treeAsTokens(treeNode), ctxt);
        }
        return codec.treeToValue(treeNode, objectClass);
    }
}

