/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.rest.endpoints;

import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jws.WebMethod;
import javax.jws.WebService;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.apache.cxf.rs.security.cors.CrossOriginResourceSharing;
import org.apache.unomi.api.BatchUpdate;
import org.apache.unomi.api.Event;
import org.apache.unomi.api.Item;
import org.apache.unomi.api.Metadata;
import org.apache.unomi.api.PartialList;
import org.apache.unomi.api.Persona;
import org.apache.unomi.api.PersonaWithSessions;
import org.apache.unomi.api.Profile;
import org.apache.unomi.api.PropertyType;
import org.apache.unomi.api.Session;
import org.apache.unomi.api.conditions.Condition;
import org.apache.unomi.api.query.Query;
import org.apache.unomi.api.services.EventService;
import org.apache.unomi.api.services.ProfileService;
import org.apache.unomi.api.services.SegmentService;
import org.apache.unomi.persistence.spi.CustomObjectMapper;
import org.apache.unomi.rest.service.impl.LocalizationHelper;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebService
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@CrossOriginResourceSharing(allowAllOrigins=true, allowCredentials=true)
@Path(value="/profiles")
@Component(service={ProfileServiceEndPoint.class}, property={"osgi.jaxrs.resource=true"})
public class ProfileServiceEndPoint {
    private static final Logger logger = LoggerFactory.getLogger((String)ProfileServiceEndPoint.class.getName());
    @Reference
    private ProfileService profileService;
    @Reference
    private EventService eventService;
    @Reference
    private SegmentService segmentService;
    @Reference
    private LocalizationHelper localizationHelper;

    public ProfileServiceEndPoint() {
        logger.info("Initializing profile service endpoint...");
    }

    @WebMethod(exclude=true)
    public void setProfileService(ProfileService profileService) {
        this.profileService = profileService;
    }

    @WebMethod(exclude=true)
    public void setEventService(EventService eventService) {
        this.eventService = eventService;
    }

    @WebMethod(exclude=true)
    public void setSegmentService(SegmentService segmentService) {
        this.segmentService = segmentService;
    }

    @WebMethod(exclude=true)
    public void setLocalizationHelper(LocalizationHelper localizationHelper) {
        this.localizationHelper = localizationHelper;
    }

    @GET
    @Path(value="/count")
    public long getAllProfilesCount() {
        return this.profileService.getAllProfilesCount();
    }

    @POST
    @Path(value="/search")
    public PartialList<Profile> getProfiles(Query query) {
        return this.profileService.search(query, Profile.class);
    }

    @GET
    @Path(value="/export")
    @Produces(value={"text/csv"})
    public Response getExportProfiles(@QueryParam(value="query") String query) {
        try {
            return this.exportProfiles((Query)CustomObjectMapper.getObjectMapper().readValue(query, Query.class));
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return Response.serverError().build();
        }
    }

    @GET
    @Path(value="/export")
    @Produces(value={"text/csv"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response formExportProfiles(@FormParam(value="query") String query) {
        try {
            return this.exportProfiles((Query)CustomObjectMapper.getObjectMapper().readValue(query, Query.class));
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return Response.serverError().build();
        }
    }

    @POST
    @Path(value="/export")
    @Produces(value={"text/csv"})
    public Response exportProfiles(Query query) {
        String toCsv = this.profileService.exportProfilesPropertiesToCsv(query);
        Response.ResponseBuilder response = Response.ok((Object)toCsv);
        response.header("Content-Disposition", (Object)("attachment; filename=Profiles_export_" + new SimpleDateFormat("yyyy-MM-dd-HH-mm").format(new Date()) + ".csv"));
        return response.build();
    }

    @POST
    @Path(value="/batchProfilesUpdate")
    public void batchProfilesUpdate(BatchUpdate update) {
        this.profileService.batchProfilesUpdate(update);
    }

    @GET
    @Path(value="/{profileId}")
    public Profile load(@PathParam(value="profileId") String profileId) {
        return this.profileService.load(profileId);
    }

    @POST
    @Path(value="/")
    public Profile save(Profile profile) {
        Profile savedProfile = this.profileService.saveOrMerge(profile);
        if (savedProfile != null) {
            Event profileUpdated = new Event("profileUpdated", null, savedProfile, null, null, (Item)savedProfile, new Date());
            profileUpdated.setPersistent(false);
            int changes = this.eventService.send(profileUpdated);
            if ((changes & 4) == 4) {
                this.profileService.save(savedProfile);
            }
        }
        return savedProfile;
    }

    @DELETE
    @Path(value="/{profileId}")
    public void delete(@PathParam(value="profileId") String profileId, @QueryParam(value="persona") @DefaultValue(value="false") boolean persona) {
        this.profileService.delete(profileId, persona);
    }

    @GET
    @Path(value="/{profileId}/sessions")
    public PartialList<Session> getProfileSessions(@PathParam(value="profileId") String profileId, @QueryParam(value="q") String query, @QueryParam(value="offset") @DefaultValue(value="0") int offset, @QueryParam(value="size") @DefaultValue(value="50") int size, @QueryParam(value="sort") String sortBy) {
        return this.profileService.getProfileSessions(profileId, query, offset, size, sortBy);
    }

    @GET
    @Path(value="/{profileId}/segments")
    public List<Metadata> getProfileSegments(@PathParam(value="profileId") String profileId) {
        Profile profile = this.profileService.load(profileId);
        return this.segmentService.getSegmentMetadatasForProfile(profile);
    }

    @GET
    @Path(value="/properties/mappings/{fromPropertyTypeId}")
    public String getPropertyTypeMapping(@PathParam(value="fromPropertyTypeId") String fromPropertyTypeId) {
        return this.profileService.getPropertyTypeMapping(fromPropertyTypeId);
    }

    @POST
    @Path(value="/personas/search")
    public PartialList<Persona> getPersonas(Query query) {
        return this.profileService.search(query, Persona.class);
    }

    @GET
    @Path(value="/personas/{personaId}")
    public Persona loadPersona(@PathParam(value="personaId") String personaId) {
        return this.profileService.loadPersona(personaId);
    }

    @GET
    @Path(value="/personasWithSessions/{personaId}")
    public PersonaWithSessions loadPersonaWithSessions(@PathParam(value="personaId") String personaId) {
        return this.profileService.loadPersonaWithSessions(personaId);
    }

    @POST
    @Path(value="/personasWithSessions")
    public PersonaWithSessions savePersonaWithSessions(PersonaWithSessions personaWithSessions) {
        return this.profileService.savePersonaWithSessions(personaWithSessions);
    }

    @POST
    @Path(value="/personas")
    public Persona savePersona(Persona persona) {
        return this.profileService.savePersona(persona);
    }

    @DELETE
    @Path(value="/personas/{personaId}")
    public void deletePersona(@PathParam(value="personaId") String personaId, @QueryParam(value="persona") @DefaultValue(value="true") boolean persona) {
        this.profileService.delete(personaId, persona);
    }

    @PUT
    @Path(value="/personas/{personaId}")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Persona createPersona(@PathParam(value="personaId") String personaId) {
        return this.profileService.createPersona(personaId);
    }

    @GET
    @Path(value="/personas/{personaId}/sessions")
    public PartialList<Session> getPersonaSessions(@PathParam(value="personaId") String personaId, @QueryParam(value="offset") @DefaultValue(value="0") int offset, @QueryParam(value="size") @DefaultValue(value="50") int size, @QueryParam(value="sort") String sortBy) {
        return this.profileService.getPersonaSessions(personaId, offset, size, sortBy);
    }

    @GET
    @Path(value="/sessions/{sessionId}")
    public Session loadSession(@PathParam(value="sessionId") String sessionId, @QueryParam(value="dateHint") String dateHint) throws ParseException {
        return this.profileService.loadSession(sessionId, dateHint != null ? new SimpleDateFormat("yyyy-MM").parse(dateHint) : null);
    }

    @POST
    @Path(value="/sessions/{sessionId}")
    public Session saveSession(Session session) {
        return this.profileService.saveSession(session);
    }

    @GET
    @Path(value="/sessions/{sessionId}/events")
    public PartialList<Event> getSessionEvents(@PathParam(value="sessionId") String sessionId, @QueryParam(value="eventTypes") String[] eventTypes, @QueryParam(value="q") String query, @QueryParam(value="offset") @DefaultValue(value="0") int offset, @QueryParam(value="size") @DefaultValue(value="50") int size, @QueryParam(value="sort") String sortBy) {
        return this.eventService.searchEvents(sessionId, eventTypes, query, offset, size, sortBy);
    }

    @WebMethod(exclude=true)
    public PartialList<Session> findProfileSessions(String profileId) {
        return null;
    }

    @WebMethod(exclude=true)
    public boolean matchCondition(Condition condition, Profile profile, Session session) {
        return this.profileService.matchCondition(condition, profile, session);
    }

    @GET
    @Path(value="/existingProperties")
    public Collection<PropertyType> getExistingProperties(@QueryParam(value="tag") String tag, @QueryParam(value="isSystemTag") boolean isSystemTag, @QueryParam(value="itemType") String itemType, @HeaderParam(value="Accept-Language") String language, @Context HttpServletResponse response) throws IOException {
        if (StringUtils.isBlank((String)tag) || StringUtils.isBlank((String)itemType)) {
            response.sendError(Response.Status.BAD_REQUEST.getStatusCode(), "Missing mandatory query parameters when requesting /cxs/profiles/existingProperties, mandatory query parameters are tag and itemType");
            return null;
        }
        Set properties = isSystemTag ? this.profileService.getExistingProperties(tag, itemType, isSystemTag) : this.profileService.getExistingProperties(tag, itemType);
        return properties;
    }

    @GET
    @Path(value="/properties")
    public Map<String, Collection<PropertyType>> getPropertyTypes(@HeaderParam(value="Accept-Language") String language) {
        return this.profileService.getTargetPropertyTypes();
    }

    @GET
    @Path(value="/properties/{propertyId}")
    public PropertyType getPropertyType(@PathParam(value="propertyId") String propertyId, @HeaderParam(value="Accept-Language") String language) {
        return this.profileService.getPropertyType(propertyId);
    }

    @GET
    @Path(value="/properties/targets/{target}")
    public Collection<PropertyType> getPropertyTypesByTarget(@PathParam(value="target") String target, @HeaderParam(value="Accept-Language") String language) {
        return this.profileService.getTargetPropertyTypes(target);
    }

    @GET
    @Path(value="/properties/tags/{tags}")
    public Collection<PropertyType> getPropertyTypeByTag(@PathParam(value="tags") String tags, @HeaderParam(value="Accept-Language") String language) {
        String[] tagsArray = tags.split(",");
        LinkedHashSet<PropertyType> results = new LinkedHashSet<PropertyType>();
        for (String tag : tagsArray) {
            results.addAll(this.profileService.getPropertyTypeByTag(tag));
        }
        return results;
    }

    @GET
    @Path(value="/properties/systemTags/{tags}")
    public Collection<PropertyType> getPropertyTypeBySystemTag(@PathParam(value="tags") String tags, @HeaderParam(value="Accept-Language") String language) {
        String[] tagsArray = tags.split(",");
        LinkedHashSet<PropertyType> results = new LinkedHashSet<PropertyType>();
        for (String tag : tagsArray) {
            results.addAll(this.profileService.getPropertyTypeBySystemTag(tag));
        }
        return results;
    }

    @POST
    @Path(value="/properties")
    public boolean setPropertyType(PropertyType property) {
        return this.profileService.setPropertyType(property);
    }

    @POST
    @Path(value="/properties/bulk")
    public boolean setPropertyTypes(List<PropertyType> properties) {
        boolean saved = false;
        for (PropertyType property : properties) {
            saved |= this.profileService.setPropertyType(property);
        }
        return saved;
    }

    @DELETE
    @Path(value="/properties/{propertyId}")
    public boolean deleteProperty(@PathParam(value="propertyId") String propertyId) {
        return this.profileService.deletePropertyType(propertyId);
    }

    @POST
    @Path(value="/search/sessions")
    public PartialList<Session> searchSession(Query query) {
        return this.profileService.searchSessions(query);
    }
}

