/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.http.common;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.camel.http.common.HttpConsumer;
import org.apache.camel.http.common.ServletResolveConsumerStrategy;
import org.apache.camel.support.RestConsumerContextPathMatcher;

public class HttpServletResolveConsumerStrategy
implements ServletResolveConsumerStrategy {
    @Override
    public HttpConsumer resolve(HttpServletRequest request, Map<String, HttpConsumer> consumers) {
        String path = request.getPathInfo();
        if (path == null) {
            return null;
        }
        HttpConsumer answer = consumers.get(path);
        if (answer == null) {
            List<Object> candidates = new ArrayList();
            for (String key : consumers.keySet()) {
                HttpConsumer consumer;
                boolean matchOnUriPrefix;
                String consumerPath = consumers.get(key).getPath();
                if (!RestConsumerContextPathMatcher.matchPath((String)path, (String)consumerPath, (boolean)(matchOnUriPrefix = (consumer = consumers.get(key)).getEndpoint().isMatchOnUriPrefix()))) continue;
                candidates.add((Object)consumer);
            }
            if (candidates.size() == 1) {
                answer = (HttpConsumer)((Object)candidates.get(0));
            } else if ((candidates = candidates.stream().filter(c -> HttpServletResolveConsumerStrategy.matchRestMethod(request.getMethod(), c.getEndpoint().getHttpMethodRestrict())).collect(Collectors.toList())).size() == 1) {
                answer = (HttpConsumer)((Object)candidates.get(0));
            }
        }
        return answer;
    }

    private static boolean matchRestMethod(String method, String restrict) {
        return restrict == null || restrict.toLowerCase(Locale.ENGLISH).contains(method.toLowerCase(Locale.ENGLISH));
    }
}

