/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.features.command.completers;

import java.util.ArrayList;
import java.util.List;
import org.apache.karaf.features.Feature;
import org.apache.karaf.features.FeaturesService;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.console.Candidate;
import org.apache.karaf.shell.api.console.CommandLine;
import org.apache.karaf.shell.api.console.Completer;
import org.apache.karaf.shell.api.console.Session;

public abstract class FeatureCompleterSupport
implements Completer {
    @Reference
    protected FeaturesService featuresService;

    public void setFeaturesService(FeaturesService featuresService) {
        this.featuresService = featuresService;
    }

    public int complete(Session session, CommandLine commandLine, List<String> candidates) {
        ArrayList<Candidate> cands = new ArrayList<Candidate>();
        this.completeCandidates(session, commandLine, cands);
        for (Candidate cand : cands) {
            candidates.add(cand.value());
        }
        return candidates.isEmpty() ? -1 : 0;
    }

    public void completeCandidates(Session session, CommandLine commandLine, List<Candidate> candidates) {
        try {
            for (Feature feature : this.featuresService.listFeatures()) {
                if (!this.acceptsFeature(feature)) continue;
                this.add(candidates, feature);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void add(List<Candidate> candidates, Feature feature) {
        candidates.add(new Candidate(feature.getName(), feature.getName(), null, feature.getDescription(), null, null, true));
    }

    protected abstract boolean acceptsFeature(Feature var1);
}

