/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.cellar.features.management.internal;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import org.apache.karaf.cellar.core.CellarSupport;
import org.apache.karaf.cellar.core.ClusterManager;
import org.apache.karaf.cellar.core.Group;
import org.apache.karaf.cellar.core.GroupManager;
import org.apache.karaf.cellar.core.control.SwitchStatus;
import org.apache.karaf.cellar.core.event.Event;
import org.apache.karaf.cellar.core.event.EventProducer;
import org.apache.karaf.cellar.core.event.EventType;
import org.apache.karaf.cellar.features.ClusterFeaturesEvent;
import org.apache.karaf.cellar.features.ClusterRepositoryEvent;
import org.apache.karaf.cellar.features.FeatureState;
import org.apache.karaf.cellar.features.management.CellarFeaturesMBean;
import org.apache.karaf.features.Feature;
import org.apache.karaf.features.FeatureEvent;
import org.apache.karaf.features.FeaturesService;
import org.apache.karaf.features.RepositoryEvent;
import org.apache.karaf.features.internal.model.Features;
import org.apache.karaf.features.internal.model.JaxbUtil;
import org.osgi.service.cm.ConfigurationAdmin;

public class CellarFeaturesMBeanImpl
extends StandardMBean
implements CellarFeaturesMBean {
    private ClusterManager clusterManager;
    private GroupManager groupManager;
    private EventProducer eventProducer;
    private FeaturesService featuresService;
    private ConfigurationAdmin configurationAdmin;

    public CellarFeaturesMBeanImpl() throws NotCompliantMBeanException {
        super(CellarFeaturesMBean.class);
    }

    public ClusterManager getClusterManager() {
        return this.clusterManager;
    }

    public void setClusterManager(ClusterManager clusterManager) {
        this.clusterManager = clusterManager;
    }

    public GroupManager getGroupManager() {
        return this.groupManager;
    }

    public void setGroupManager(GroupManager groupManager) {
        this.groupManager = groupManager;
    }

    public EventProducer getEventProducer() {
        return this.eventProducer;
    }

    public void setEventProducer(EventProducer eventProducer) {
        this.eventProducer = eventProducer;
    }

    public FeaturesService getFeaturesService() {
        return this.featuresService;
    }

    public void setFeaturesService(FeaturesService featuresService) {
        this.featuresService = featuresService;
    }

    public ConfigurationAdmin getConfigurationAdmin() {
        return this.configurationAdmin;
    }

    public void setConfigurationAdmin(ConfigurationAdmin configurationAdmin) {
        this.configurationAdmin = configurationAdmin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void installFeature(String groupName, String name, String version, boolean noRefresh, boolean noStart, boolean noManage, boolean upgrade) throws Exception {
        Group group = this.groupManager.findGroupByName(groupName);
        if (group == null) {
            throw new IllegalArgumentException("Cluster group " + groupName + " doesn't exist");
        }
        if (this.eventProducer.getSwitch().getStatus().equals((Object)SwitchStatus.OFF)) {
            throw new IllegalStateException("Cluster event producer is OFF");
        }
        CellarSupport support = new CellarSupport();
        support.setClusterManager(this.clusterManager);
        support.setGroupManager(this.groupManager);
        support.setConfigurationAdmin(this.configurationAdmin);
        if (!support.isAllowed(group, "feature", name, EventType.OUTBOUND).booleanValue()) {
            throw new IllegalArgumentException("Feature " + name + " is blocked outbound for cluster group " + groupName);
        }
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        try {
            Map clusterFeatures = this.clusterManager.getMap("org.apache.karaf.cellar.features." + groupName);
            FeatureState feature = null;
            String key = null;
            for (String k : clusterFeatures.keySet()) {
                FeatureState state = (FeatureState)clusterFeatures.get(k);
                key = k;
                if (version == null) {
                    if (!state.getName().equals(name)) continue;
                    feature = state;
                    break;
                }
                if (!state.getName().equals(name) || !state.getVersion().equals(version)) continue;
                feature = state;
                break;
            }
            if (feature == null) {
                if (version == null) {
                    throw new IllegalArgumentException("Feature " + name + " doesn't exist in cluster group " + groupName);
                }
                throw new IllegalArgumentException("Feature " + name + "/" + version + " doesn't exist in cluster group " + groupName);
            }
            feature.setInstalled(true);
            clusterFeatures.put(key, feature);
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
        ClusterFeaturesEvent event = new ClusterFeaturesEvent(name, version, noRefresh, noStart, noManage, upgrade, FeatureEvent.EventType.FeatureInstalled);
        event.setSourceGroup(group);
        this.eventProducer.produce((Event)event);
    }

    @Override
    public void installFeature(String groupName, String name, String version) throws Exception {
        this.installFeature(groupName, name, version, false, false, false, false);
    }

    @Override
    public void installFeature(String groupName, String name) throws Exception {
        this.installFeature(groupName, name, null);
    }

    @Override
    public void installFeature(String groupName, String name, boolean noRefresh, boolean noStart, boolean noManage, boolean upgrade) throws Exception {
        this.installFeature(groupName, name, null, noRefresh, noStart, noManage, upgrade);
    }

    @Override
    public void uninstallFeature(String groupName, String name, String version) throws Exception {
        this.uninstallFeature(groupName, name, version, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void uninstallFeature(String groupName, String name, String version, boolean noRefresh) throws Exception {
        Group group = this.groupManager.findGroupByName(groupName);
        if (group == null) {
            throw new IllegalArgumentException("Cluster group " + groupName + " doesn't exist");
        }
        if (this.eventProducer.getSwitch().getStatus().equals((Object)SwitchStatus.OFF)) {
            throw new IllegalStateException("Cluster event producer is OFF");
        }
        CellarSupport support = new CellarSupport();
        support.setClusterManager(this.clusterManager);
        support.setGroupManager(this.groupManager);
        support.setConfigurationAdmin(this.configurationAdmin);
        if (!support.isAllowed(group, "feature", name, EventType.OUTBOUND).booleanValue()) {
            throw new IllegalArgumentException("Feature " + name + " is blocked outbound for cluster group " + groupName);
        }
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        try {
            Map clusterFeatures = this.clusterManager.getMap("org.apache.karaf.cellar.features." + groupName);
            FeatureState feature = null;
            String key = null;
            for (String k : clusterFeatures.keySet()) {
                FeatureState state = (FeatureState)clusterFeatures.get(k);
                key = k;
                if (version == null) {
                    if (!state.getName().equals(name)) continue;
                    feature = state;
                    break;
                }
                if (!state.getName().equals(name) || !state.getVersion().equals(version)) continue;
                feature = state;
                break;
            }
            if (feature == null) {
                if (version == null) {
                    throw new IllegalArgumentException("Feature " + name + " doesn't exist in cluster group " + groupName);
                }
                throw new IllegalArgumentException("Feature " + name + "/" + version + " doesn't exist in cluster group " + groupName);
            }
            feature.setInstalled(false);
            clusterFeatures.put(key, feature);
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
        ClusterFeaturesEvent event = new ClusterFeaturesEvent(name, version, noRefresh, false, false, false, FeatureEvent.EventType.FeatureUninstalled);
        event.setSourceGroup(group);
        this.eventProducer.produce((Event)event);
    }

    @Override
    public void uninstallFeature(String groupName, String name) throws Exception {
        this.uninstallFeature(groupName, name, null, false);
    }

    @Override
    public void uninstallFeature(String groupName, String name, boolean noRefresh) throws Exception {
        this.uninstallFeature(groupName, name, null, noRefresh);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TabularData getFeatures(String groupName) throws Exception {
        Group group = this.groupManager.findGroupByName(groupName);
        if (group == null) {
            throw new IllegalArgumentException("Cluster group " + groupName + " doesn't exist");
        }
        CellarSupport support = new CellarSupport();
        support.setClusterManager(this.clusterManager);
        support.setGroupManager(this.groupManager);
        support.setConfigurationAdmin(this.configurationAdmin);
        CompositeType featuresType = new CompositeType("Feature", "Karaf Cellar feature", new String[]{"name", "version", "installed", "located", "blocked"}, new String[]{"Name of the feature", "Version of the feature", "Whether the feature is installed or not", "Location of the feature (on the cluster or the local node)", "Feature block policy"}, new OpenType[]{SimpleType.STRING, SimpleType.STRING, SimpleType.BOOLEAN, SimpleType.STRING, SimpleType.STRING});
        TabularType tabularType = new TabularType("Features", "Table of all Karaf Cellar features", featuresType, new String[]{"name", "version"});
        TabularDataSupport table = new TabularDataSupport(tabularType);
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        try {
            Map<String, ExtendedFeatureState> features = this.gatherFeatures(groupName);
            if (features != null && !features.isEmpty()) {
                for (ExtendedFeatureState feature : features.values()) {
                    String located = "";
                    boolean cluster = feature.isCluster();
                    boolean local = feature.isLocal();
                    if (cluster && local) {
                        located = "cluster/local";
                    }
                    if (cluster && !local) {
                        located = "cluster";
                    }
                    if (local && !cluster) {
                        located = "local";
                    }
                    String blocked = "";
                    boolean inbound = support.isAllowed(group, "feature", feature.getName(), EventType.INBOUND);
                    boolean outbound = support.isAllowed(group, "feature", feature.getName(), EventType.OUTBOUND);
                    if (!inbound && !outbound) {
                        blocked = "in/out";
                    }
                    if (!inbound && outbound) {
                        blocked = "in";
                    }
                    if (!outbound && inbound) {
                        blocked = "out";
                    }
                    CompositeDataSupport data = new CompositeDataSupport(featuresType, new String[]{"name", "version", "installed", "located", "blocked"}, new Object[]{feature.getName(), feature.getVersion(), feature.getInstalled(), located, blocked});
                    table.put(data);
                }
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
        return table;
    }

    private Map<String, ExtendedFeatureState> gatherFeatures(String groupName) throws Exception {
        HashMap<String, ExtendedFeatureState> features = new HashMap<String, ExtendedFeatureState>();
        Map clusterFeatures = this.clusterManager.getMap("org.apache.karaf.cellar.features." + groupName);
        for (String key : clusterFeatures.keySet()) {
            FeatureState state = (FeatureState)clusterFeatures.get(key);
            ExtendedFeatureState extendedState = new ExtendedFeatureState();
            extendedState.setName(state.getName());
            extendedState.setInstalled(state.getInstalled());
            extendedState.setVersion(state.getVersion());
            extendedState.setCluster(true);
            extendedState.setLocal(true);
            features.put(key, extendedState);
        }
        for (Feature feature : this.featuresService.listFeatures()) {
            ExtendedFeatureState extendedState;
            String key = feature.getName() + "/" + feature.getVersion();
            if (features.containsKey(key)) {
                extendedState = (ExtendedFeatureState)features.get(key);
                if (this.featuresService.isInstalled(feature)) {
                    extendedState.setInstalled(true);
                }
                extendedState.setLocal(true);
                continue;
            }
            extendedState = new ExtendedFeatureState();
            extendedState.setCluster(false);
            extendedState.setLocal(true);
            extendedState.setName(feature.getName());
            extendedState.setVersion(feature.getVersion());
            if (this.featuresService.isInstalled(feature)) {
                extendedState.setInstalled(true);
            } else {
                extendedState.setInstalled(false);
            }
            features.put(key, extendedState);
        }
        return features;
    }

    @Override
    public List<String> getRepositories(String groupName) throws Exception {
        Group group = this.groupManager.findGroupByName(groupName);
        if (group == null) {
            throw new IllegalArgumentException("Cluster group " + groupName + " doesn't exist");
        }
        Map clusterRepositories = this.clusterManager.getMap("org.apache.karaf.cellar.repositories." + groupName);
        ArrayList<String> result = new ArrayList<String>();
        for (String clusterRepository : clusterRepositories.keySet()) {
            result.add(clusterRepository);
        }
        return result;
    }

    @Override
    public void addRepository(String groupName, String nameOrUrl) throws Exception {
        this.addRepository(groupName, nameOrUrl, null, false);
    }

    @Override
    public void addRepository(String groupName, String nameOrUrl, String version) throws Exception {
        this.addRepository(groupName, nameOrUrl, version, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRepository(String groupName, String nameOrUrl, String version, boolean install) throws Exception {
        block9: {
            Group group = this.groupManager.findGroupByName(groupName);
            if (group == null) {
                throw new IllegalArgumentException("Cluster group " + groupName + " doesn't exist");
            }
            if (this.eventProducer.getSwitch().getStatus().equals((Object)SwitchStatus.OFF)) {
                throw new IllegalStateException("Cluster event producer is OFF");
            }
            ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            try {
                Map clusterRepositories = this.clusterManager.getMap("org.apache.karaf.cellar.repositories." + groupName);
                Map clusterFeatures = this.clusterManager.getMap("org.apache.karaf.cellar.features." + groupName);
                URI uri = this.featuresService.getRepositoryUriFor(nameOrUrl, version);
                if (uri == null) {
                    uri = new URI(nameOrUrl);
                }
                String name = null;
                for (Object repository : clusterRepositories.keySet()) {
                    if (!((String)repository).equals(uri)) continue;
                    name = (String)clusterRepositories.get(repository);
                    break;
                }
                if (name == null) {
                    Features repository = JaxbUtil.unmarshal(uri.toASCIIString(), true);
                    clusterRepositories.put(uri.toString(), repository.getName());
                    for (Feature feature : repository.getFeature()) {
                        FeatureState state = new FeatureState();
                        state.setName(feature.getName());
                        state.setVersion(feature.getVersion());
                        state.setInstalled(this.featuresService.isInstalled(feature));
                        clusterFeatures.put(feature.getName() + "/" + feature.getVersion(), state);
                    }
                    ClusterRepositoryEvent event = new ClusterRepositoryEvent(uri.toString(), RepositoryEvent.EventType.RepositoryAdded);
                    event.setInstall(install);
                    event.setSourceGroup(group);
                    event.setSourceNode(this.clusterManager.getNode());
                    this.eventProducer.produce((Event)event);
                    break block9;
                }
                throw new IllegalArgumentException("Features repository URL " + uri + " already registered");
            }
            finally {
                Thread.currentThread().setContextClassLoader(originalClassLoader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refreshRepository(String groupName, String nameOrUrl) throws Exception {
        Group group = this.groupManager.findGroupByName(groupName);
        if (group == null) {
            throw new IllegalArgumentException("Cluster group " + groupName + " doesn't exist");
        }
        if (this.eventProducer.getSwitch().getStatus().equals((Object)SwitchStatus.OFF)) {
            throw new IllegalStateException("Cluster event producer is OFF");
        }
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        try {
            String uri = null;
            if (nameOrUrl != null) {
                Map clusterFeaturesRepositories = this.clusterManager.getMap("org.apache.karaf.cellar.repositories." + groupName);
                for (Map.Entry entry : clusterFeaturesRepositories.entrySet()) {
                    if (!((String)entry.getKey()).equals(nameOrUrl) && !((String)entry.getValue()).equals(nameOrUrl)) continue;
                    uri = (String)entry.getKey();
                    break;
                }
                if (uri == null) {
                    throw new IllegalArgumentException("Features repository " + nameOrUrl + " doesn't exist in cluster group " + groupName);
                }
            }
            ClusterRepositoryEvent event = new ClusterRepositoryEvent(uri, RepositoryEvent.EventType.RepositoryAdded);
            event.setRefresh(true);
            event.setSourceGroup(group);
            event.setSourceNode(this.clusterManager.getNode());
            this.eventProducer.produce((Event)event);
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }

    @Override
    public void removeRepository(String groupName, String repository) throws Exception {
        this.removeRepository(groupName, repository, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeRepository(String groupName, String repo, boolean uninstall) throws Exception {
        Group group = this.groupManager.findGroupByName(groupName);
        if (group == null) {
            throw new IllegalArgumentException("Cluster group " + groupName + " doesn't exist");
        }
        if (this.eventProducer.getSwitch().getStatus().equals((Object)SwitchStatus.OFF)) {
            throw new IllegalStateException("Cluster event producer is OFF");
        }
        Map clusterRepositories = this.clusterManager.getMap("org.apache.karaf.cellar.repositories." + groupName);
        Map clusterFeatures = this.clusterManager.getMap("org.apache.karaf.cellar.features." + groupName);
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            ArrayList<String> urls = new ArrayList<String>();
            Pattern pattern = Pattern.compile(repo);
            for (String repositoryUrl : clusterRepositories.keySet()) {
                String repositoryName = (String)clusterRepositories.get(repositoryUrl);
                if (repositoryName != null && !repositoryName.isEmpty()) {
                    Matcher nameMatcher = pattern.matcher(repositoryName);
                    if (nameMatcher.matches()) {
                        urls.add(repositoryUrl);
                        continue;
                    }
                    Matcher uriMatcher = pattern.matcher(repositoryUrl);
                    if (!uriMatcher.matches()) continue;
                    urls.add(repositoryUrl);
                    continue;
                }
                Matcher uriMatcher = pattern.matcher(repositoryUrl);
                if (!uriMatcher.matches()) continue;
                urls.add(repositoryUrl);
            }
            for (String url : urls) {
                boolean found = false;
                for (Object repository : clusterRepositories.keySet()) {
                    if (!((String)repository).equals(url)) continue;
                    found = true;
                    break;
                }
                if (found) {
                    Object repository;
                    Features repositoryModel = JaxbUtil.unmarshal(url, true);
                    clusterRepositories.remove(url);
                    repository = repositoryModel.getFeature().iterator();
                    while (repository.hasNext()) {
                        Feature feature = (Feature)repository.next();
                        clusterFeatures.remove(feature.getName() + "/" + feature.getVersion());
                    }
                    ClusterRepositoryEvent event = new ClusterRepositoryEvent(url, RepositoryEvent.EventType.RepositoryRemoved);
                    event.setUninstall(uninstall);
                    event.setSourceGroup(group);
                    event.setSourceNode(this.clusterManager.getNode());
                    this.eventProducer.produce((Event)event);
                    continue;
                }
                throw new IllegalArgumentException("Features repository URL " + url + " not found in cluster group " + groupName);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }

    @Override
    public void block(String groupName, String featurePattern, boolean whitelist, boolean blacklist, boolean in, boolean out) throws Exception {
        Group group = this.groupManager.findGroupByName(groupName);
        if (group == null) {
            throw new IllegalArgumentException("Cluster group " + groupName + " doesn't exist");
        }
        CellarSupport support = new CellarSupport();
        support.setClusterManager(this.clusterManager);
        support.setGroupManager(this.groupManager);
        support.setConfigurationAdmin(this.configurationAdmin);
        if (in) {
            if (whitelist) {
                support.switchListEntry("whitelist", groupName, "feature", EventType.INBOUND, featurePattern);
            }
            if (blacklist) {
                support.switchListEntry("blacklist", groupName, "feature", EventType.INBOUND, featurePattern);
            }
        }
        if (out) {
            if (whitelist) {
                support.switchListEntry("whitelist", groupName, "feature", EventType.OUTBOUND, featurePattern);
            }
            if (blacklist) {
                support.switchListEntry("blacklist", groupName, "feature", EventType.OUTBOUND, featurePattern);
            }
        }
    }

    class ExtendedFeatureState
    extends FeatureState {
        private boolean cluster;
        private boolean local;

        ExtendedFeatureState() {
        }

        public boolean isCluster() {
            return this.cluster;
        }

        public void setCluster(boolean cluster) {
            this.cluster = cluster;
        }

        public boolean isLocal() {
            return this.local;
        }

        public void setLocal(boolean local) {
            this.local = local;
        }
    }
}

