/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.services.impl.cluster;

import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TimerTask;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.karaf.cellar.config.ClusterConfigurationEvent;
import org.apache.karaf.cellar.core.CellarSupport;
import org.apache.karaf.cellar.core.ClusterManager;
import org.apache.karaf.cellar.core.Group;
import org.apache.karaf.cellar.core.GroupManager;
import org.apache.karaf.cellar.core.Node;
import org.apache.karaf.cellar.core.control.SwitchStatus;
import org.apache.karaf.cellar.core.event.Event;
import org.apache.karaf.cellar.core.event.EventProducer;
import org.apache.karaf.cellar.core.event.EventType;
import org.apache.unomi.api.ClusterNode;
import org.apache.unomi.api.services.ClusterService;
import org.apache.unomi.api.services.SchedulerService;
import org.apache.unomi.persistence.spi.PersistenceService;
import org.apache.unomi.services.impl.cluster.ClusterSystemStatisticsEvent;
import org.osgi.service.cm.ConfigurationAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterServiceImpl
implements ClusterService {
    public static final String KARAF_CELLAR_CLUSTER_NODE_CONFIGURATION = "org.apache.unomi.nodes";
    public static final String KARAF_CLUSTER_CONFIGURATION_PUBLIC_ENDPOINTS = "publicEndpoints";
    public static final String KARAF_CLUSTER_CONFIGURATION_INTERNAL_ENDPOINTS = "internalEndpoints";
    private static final Logger logger = LoggerFactory.getLogger((String)ClusterServiceImpl.class.getName());
    PersistenceService persistenceService;
    private ClusterManager karafCellarClusterManager;
    private EventProducer karafCellarEventProducer;
    private GroupManager karafCellarGroupManager;
    private String karafCellarGroupName = "default";
    private ConfigurationAdmin osgiConfigurationAdmin;
    private String publicAddress;
    private String internalAddress;
    private Map<String, Map<String, Serializable>> nodeSystemStatistics = new ConcurrentHashMap<String, Map<String, Serializable>>();
    private Group group = null;
    private SchedulerService schedulerService;
    private long nodeStatisticsUpdateFrequency = 10000L;

    public void setPersistenceService(PersistenceService persistenceService) {
        this.persistenceService = persistenceService;
    }

    public void setKarafCellarClusterManager(ClusterManager karafCellarClusterManager) {
        this.karafCellarClusterManager = karafCellarClusterManager;
    }

    public void setKarafCellarEventProducer(EventProducer karafCellarEventProducer) {
        this.karafCellarEventProducer = karafCellarEventProducer;
    }

    public void setKarafCellarGroupManager(GroupManager karafCellarGroupManager) {
        this.karafCellarGroupManager = karafCellarGroupManager;
    }

    public void setKarafCellarGroupName(String karafCellarGroupName) {
        this.karafCellarGroupName = karafCellarGroupName;
    }

    public void setOsgiConfigurationAdmin(ConfigurationAdmin osgiConfigurationAdmin) {
        this.osgiConfigurationAdmin = osgiConfigurationAdmin;
    }

    public void setPublicAddress(String publicAddress) {
        this.publicAddress = publicAddress;
    }

    public void setInternalAddress(String internalAddress) {
        this.internalAddress = internalAddress;
    }

    public void setNodeStatisticsUpdateFrequency(long nodeStatisticsUpdateFrequency) {
        this.nodeStatisticsUpdateFrequency = nodeStatisticsUpdateFrequency;
    }

    public void setSchedulerService(SchedulerService schedulerService) {
        this.schedulerService = schedulerService;
    }

    public Map<String, Map<String, Serializable>> getNodeSystemStatistics() {
        return this.nodeSystemStatistics;
    }

    public void init() {
        if (this.karafCellarEventProducer != null && this.karafCellarClusterManager != null) {
            boolean setupConfigOk = true;
            this.group = this.karafCellarGroupManager.findGroupByName(this.karafCellarGroupName);
            if (setupConfigOk && this.group == null) {
                logger.error("Cluster group " + this.karafCellarGroupName + " doesn't exist, creating it...");
                this.group = this.karafCellarGroupManager.createGroup(this.karafCellarGroupName);
                setupConfigOk = this.group != null;
            }
            if (setupConfigOk && this.karafCellarEventProducer.getSwitch().getStatus().equals((Object)SwitchStatus.OFF)) {
                logger.error("Cluster event producer is OFF");
                setupConfigOk = false;
            }
            if (setupConfigOk && !this.isClusterConfigPIDAllowed(this.group, "config", KARAF_CELLAR_CLUSTER_NODE_CONFIGURATION, EventType.OUTBOUND)) {
                logger.error("Configuration PID org.apache.unomi.nodes is blocked outbound for cluster group " + this.karafCellarGroupName);
                setupConfigOk = false;
            }
            if (setupConfigOk) {
                Map configurations = this.karafCellarClusterManager.getMap("org.apache.karaf.cellar.configuration.map." + this.karafCellarGroupName);
                Node thisKarafNode = this.karafCellarClusterManager.getNode();
                Properties karafCellarClusterNodeConfiguration = (Properties)configurations.get(KARAF_CELLAR_CLUSTER_NODE_CONFIGURATION);
                if (karafCellarClusterNodeConfiguration == null) {
                    karafCellarClusterNodeConfiguration = new Properties();
                }
                Map<String, String> publicEndpoints = this.getMapProperty(karafCellarClusterNodeConfiguration, KARAF_CLUSTER_CONFIGURATION_PUBLIC_ENDPOINTS, thisKarafNode.getId() + "=" + this.publicAddress);
                publicEndpoints.put(thisKarafNode.getId(), this.publicAddress);
                this.setMapProperty(karafCellarClusterNodeConfiguration, KARAF_CLUSTER_CONFIGURATION_PUBLIC_ENDPOINTS, publicEndpoints);
                Map<String, String> internalEndpoints = this.getMapProperty(karafCellarClusterNodeConfiguration, KARAF_CLUSTER_CONFIGURATION_INTERNAL_ENDPOINTS, thisKarafNode.getId() + "=" + this.internalAddress);
                internalEndpoints.put(thisKarafNode.getId(), this.internalAddress);
                this.setMapProperty(karafCellarClusterNodeConfiguration, KARAF_CLUSTER_CONFIGURATION_INTERNAL_ENDPOINTS, internalEndpoints);
                configurations.put(KARAF_CELLAR_CLUSTER_NODE_CONFIGURATION, karafCellarClusterNodeConfiguration);
                ClusterConfigurationEvent clusterConfigurationEvent = new ClusterConfigurationEvent(KARAF_CELLAR_CLUSTER_NODE_CONFIGURATION);
                this.sendEvent((Serializable)clusterConfigurationEvent);
            }
            TimerTask statisticsTask = new TimerTask(){

                @Override
                public void run() {
                    try {
                        ClusterServiceImpl.this.updateSystemStats();
                    }
                    catch (Throwable t) {
                        logger.error("Error updating system statistics", t);
                    }
                }
            };
            this.schedulerService.getScheduleExecutorService().scheduleWithFixedDelay(statisticsTask, 0L, this.nodeStatisticsUpdateFrequency, TimeUnit.MILLISECONDS);
        }
        logger.info("Cluster service initialized.");
    }

    public void destroy() {
        logger.info("Cluster service shutdown.");
    }

    public List<ClusterNode> getClusterNodes() {
        LinkedHashMap<String, ClusterNode> clusterNodes = new LinkedHashMap<String, ClusterNode>();
        Set karafCellarNodes = this.karafCellarClusterManager.listNodes();
        Node thisKarafNode = this.karafCellarClusterManager.getNode();
        Map clusterConfigurations = this.karafCellarClusterManager.getMap("org.apache.karaf.cellar.configuration.map." + this.karafCellarGroupName);
        Properties karafCellarClusterNodeConfiguration = (Properties)clusterConfigurations.get(KARAF_CELLAR_CLUSTER_NODE_CONFIGURATION);
        Map<Object, Object> publicNodeEndpoints = new TreeMap();
        Map<Object, Object> internalNodeEndpoints = new TreeMap();
        if (karafCellarClusterNodeConfiguration != null) {
            publicNodeEndpoints = this.getMapProperty(karafCellarClusterNodeConfiguration, KARAF_CLUSTER_CONFIGURATION_PUBLIC_ENDPOINTS, thisKarafNode.getId() + "=" + this.publicAddress);
            internalNodeEndpoints = this.getMapProperty(karafCellarClusterNodeConfiguration, KARAF_CLUSTER_CONFIGURATION_INTERNAL_ENDPOINTS, thisKarafNode.getId() + "=" + this.internalAddress);
        }
        for (Node karafCellarNode : karafCellarNodes) {
            Map<String, Serializable> nodeStatistics;
            String internalEndpoint;
            ClusterNode clusterNode = new ClusterNode();
            String publicEndpoint = (String)publicNodeEndpoints.get(karafCellarNode.getId());
            if (publicEndpoint != null) {
                clusterNode.setPublicHostAddress(publicEndpoint);
            }
            if ((internalEndpoint = (String)internalNodeEndpoints.get(karafCellarNode.getId())) != null) {
                clusterNode.setInternalHostAddress(internalEndpoint);
            }
            if ((nodeStatistics = this.nodeSystemStatistics.get(karafCellarNode.getId())) != null) {
                List loadAverage;
                Double systemCpuLoad;
                Long uptime = (Long)nodeStatistics.get("uptime");
                if (uptime != null) {
                    clusterNode.setUptime(uptime.longValue());
                }
                if ((systemCpuLoad = (Double)nodeStatistics.get("systemCpuLoad")) != null) {
                    clusterNode.setCpuLoad(systemCpuLoad.doubleValue());
                }
                if ((loadAverage = (List)((Object)nodeStatistics.get("systemLoadAverage"))) != null) {
                    Double[] loadAverageArray = loadAverage.toArray(new Double[loadAverage.size()]);
                    ArrayUtils.toPrimitive((Double[])loadAverageArray);
                    clusterNode.setLoadAverage(ArrayUtils.toPrimitive((Double[])loadAverageArray));
                }
            }
            clusterNodes.put(karafCellarNode.getId(), clusterNode);
        }
        return new ArrayList<ClusterNode>(clusterNodes.values());
    }

    public void purge(Date date) {
        this.persistenceService.purge(date);
    }

    public void purge(String scope) {
        this.persistenceService.purge(scope);
    }

    public void sendEvent(Serializable eventObject) {
        Event event = (Event)eventObject;
        event.setSourceGroup(this.group);
        event.setSourceNode(this.karafCellarClusterManager.getNode());
        this.karafCellarEventProducer.produce(event);
    }

    public boolean isClusterConfigPIDAllowed(Group group, String category, String pid, EventType type) {
        CellarSupport support = new CellarSupport();
        support.setClusterManager(this.karafCellarClusterManager);
        support.setGroupManager(this.karafCellarGroupManager);
        support.setConfigurationAdmin(this.osgiConfigurationAdmin);
        return support.isAllowed(group, category, pid, type);
    }

    private Map<String, String> getMapProperty(Properties properties, String propertyName, String defaultValue) {
        String propertyValue = properties.getProperty(propertyName, defaultValue);
        return this.getMapProperty(propertyValue);
    }

    private Map<String, String> getMapProperty(String propertyValue) {
        String[] propertyValueArray = propertyValue.split(",");
        LinkedHashMap<String, String> propertyMapValue = new LinkedHashMap<String, String>();
        for (String propertyValueElement : propertyValueArray) {
            String[] propertyValueElementPrats = propertyValueElement.split("=");
            propertyMapValue.put(propertyValueElementPrats[0], propertyValueElementPrats[1]);
        }
        return propertyMapValue;
    }

    private Map<String, String> setMapProperty(Properties properties, String propertyName, Map<String, String> propertyMapValue) {
        StringBuilder propertyValueBuilder = new StringBuilder();
        int entryCount = 0;
        for (Map.Entry<String, String> propertyMapValueEntry : propertyMapValue.entrySet()) {
            propertyValueBuilder.append(propertyMapValueEntry.getKey());
            propertyValueBuilder.append("=");
            propertyValueBuilder.append(propertyMapValueEntry.getValue());
            if (entryCount >= propertyMapValue.size() - 1) continue;
            propertyValueBuilder.append(",");
        }
        String oldPropertyValue = (String)properties.setProperty(propertyName, propertyValueBuilder.toString());
        if (oldPropertyValue == null) {
            return null;
        }
        return this.getMapProperty(oldPropertyValue);
    }

    private void updateSystemStats() {
        RuntimeMXBean remoteRuntime = ManagementFactory.getRuntimeMXBean();
        long uptime = remoteRuntime.getUptime();
        ObjectName operatingSystemMXBeanName = ManagementFactory.getOperatingSystemMXBean().getObjectName();
        Double systemCpuLoad = null;
        try {
            systemCpuLoad = (Double)ManagementFactory.getPlatformMBeanServer().getAttribute(operatingSystemMXBeanName, "SystemCpuLoad");
        }
        catch (MBeanException e) {
            logger.error("Error retrieving system CPU load", (Throwable)e);
        }
        catch (AttributeNotFoundException e) {
            logger.error("Error retrieving system CPU load", (Throwable)e);
        }
        catch (InstanceNotFoundException e) {
            logger.error("Error retrieving system CPU load", (Throwable)e);
        }
        catch (ReflectionException e) {
            logger.error("Error retrieving system CPU load", (Throwable)e);
        }
        OperatingSystemMXBean operatingSystemMXBean = ManagementFactory.getOperatingSystemMXBean();
        double systemLoadAverage = operatingSystemMXBean.getSystemLoadAverage();
        ClusterSystemStatisticsEvent clusterSystemStatisticsEvent = new ClusterSystemStatisticsEvent("org.apache.unomi.cluster.system.statistics");
        TreeMap<String, Serializable> systemStatistics = new TreeMap<String, Serializable>();
        ArrayList<Double> systemLoadAverageArray = new ArrayList<Double>();
        systemLoadAverageArray.add(systemLoadAverage);
        systemStatistics.put("systemLoadAverage", systemLoadAverageArray);
        systemStatistics.put("systemCpuLoad", systemCpuLoad);
        systemStatistics.put("uptime", Long.valueOf(uptime));
        clusterSystemStatisticsEvent.setStatistics(systemStatistics);
        this.nodeSystemStatistics.put(this.karafCellarClusterManager.getNode().getId(), systemStatistics);
        this.sendEvent((Serializable)((Object)clusterSystemStatisticsEvent));
    }
}

