/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.cellar.features.shell;

import java.util.HashMap;
import java.util.Map;
import org.apache.karaf.cellar.core.Group;
import org.apache.karaf.cellar.core.shell.CellarCommandSupport;
import org.apache.karaf.cellar.core.shell.completer.AllGroupsCompleter;
import org.apache.karaf.features.FeaturesService;
import org.apache.karaf.features.Repository;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.support.table.ShellTable;

@Command(scope="cluster", name="feature-repo-list", description="List the features repositories in a cluster group")
@Service
public class RepoListCommand
extends CellarCommandSupport {
    @Argument(index=0, name="group", description="The cluster group name", required=true, multiValued=false)
    @Completion(value=AllGroupsCompleter.class)
    String groupName;
    @Option(name="--no-format", description="Disable table rendered output", required=false, multiValued=false)
    boolean noFormat;
    @Option(name="--local", description="Shows only features repositories local to the node", required=false, multiValued=false)
    boolean onlyLocal;
    @Option(name="--cluster", description="Shows only features repositories on the cluster", required=false, multiValued=false)
    boolean onlyCluster;
    @Reference
    private FeaturesService featuresService;

    protected Object doExecute() throws Exception {
        Group group = this.groupManager.findGroupByName(this.groupName);
        if (group == null) {
            System.err.println("Cluster group " + this.groupName + " doesn't exist");
            return null;
        }
        Map<String, RepositoryState> repositories = this.gatherRepositories();
        ShellTable table = new ShellTable();
        table.column("Repository");
        table.column("Located").alignCenter();
        table.column("URL");
        for (String url : repositories.keySet()) {
            RepositoryState state = repositories.get(url);
            String located = "";
            boolean local = state.isLocal();
            boolean cluster = state.isCluster();
            if (local && cluster) {
                located = "cluster/local";
            }
            if (local && !cluster) {
                if (this.onlyCluster) continue;
                located = "local";
            }
            if (cluster && !local) {
                if (this.onlyLocal) continue;
                located = "cluster";
            }
            table.addRow().addContent(new Object[]{state.getName(), located, url});
        }
        table.print(System.out, !this.noFormat);
        return null;
    }

    private Map<String, RepositoryState> gatherRepositories() {
        HashMap<String, RepositoryState> repositories = new HashMap<String, RepositoryState>();
        Map clusterRepositories = this.clusterManager.getMap("org.apache.karaf.cellar.repositories." + this.groupName);
        for (String url : clusterRepositories.keySet()) {
            RepositoryState state = new RepositoryState();
            state.setCluster(true);
            state.setLocal(true);
            state.setName((String)clusterRepositories.get(url));
            repositories.put(url, state);
        }
        try {
            for (Repository localRepository : this.featuresService.listRepositories()) {
                RepositoryState state;
                if (repositories.containsKey(localRepository.getURI().toString())) {
                    state = (RepositoryState)repositories.get(localRepository.getURI().toString());
                    state.setLocal(true);
                    continue;
                }
                state = new RepositoryState();
                state.setCluster(false);
                state.setLocal(true);
                state.setName(localRepository.getName());
                repositories.put(localRepository.getURI().toString(), state);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return repositories;
    }

    public FeaturesService getFeaturesService() {
        return this.featuresService;
    }

    public void setFeaturesService(FeaturesService featuresService) {
        this.featuresService = featuresService;
    }

    class RepositoryState {
        private String name;
        private boolean cluster;
        private boolean local;

        RepositoryState() {
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public boolean isCluster() {
            return this.cluster;
        }

        public void setCluster(boolean cluster) {
            this.cluster = cluster;
        }

        public boolean isLocal() {
            return this.local;
        }

        public void setLocal(boolean local) {
            this.local = local;
        }
    }
}

