/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.querycache.subscriber;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.ContinuousQueryMadePublishableCodec;
import com.hazelcast.client.impl.protocol.codec.ContinuousQueryPublisherCreateCodec;
import com.hazelcast.client.impl.protocol.codec.ContinuousQueryPublisherCreateWithValueCodec;
import com.hazelcast.map.impl.querycache.InvokerWrapper;
import com.hazelcast.map.impl.querycache.accumulator.AccumulatorInfo;
import com.hazelcast.map.impl.querycache.subscriber.AbstractQueryCacheEndToEndConstructor;
import com.hazelcast.map.impl.querycache.subscriber.InternalQueryCache;
import com.hazelcast.map.impl.querycache.subscriber.QueryCacheRequest;
import com.hazelcast.nio.serialization.Data;

public class ClientQueryCacheEndToEndConstructor
extends AbstractQueryCacheEndToEndConstructor {
    public ClientQueryCacheEndToEndConstructor(QueryCacheRequest request) {
        super(request);
    }

    @Override
    public void createPublisherAccumulator(AccumulatorInfo info) throws Exception {
        ClientMessage publisherCreateMessage = this.newPublisherCreateMessage(info);
        InvokerWrapper invokerWrapper = this.context.getInvokerWrapper();
        ClientMessage response = (ClientMessage)invokerWrapper.invoke(publisherCreateMessage);
        ClientQueryCacheEndToEndConstructor.prepopulate(this.queryCache, response, info.isIncludeValue());
        if (info.isPopulate()) {
            this.madePublishable(info.getMapName(), info.getCacheId());
            info.setPublishable(true);
        }
    }

    private ClientMessage newPublisherCreateMessage(AccumulatorInfo info) {
        Object dataPredicate = this.context.getSerializationService().toData(info.getPredicate());
        if (info.isIncludeValue()) {
            return ContinuousQueryPublisherCreateWithValueCodec.encodeRequest(info.getMapName(), info.getCacheId(), dataPredicate, info.getBatchSize(), info.getBufferSize(), info.getDelaySeconds(), info.isPopulate(), info.isCoalesce());
        }
        return ContinuousQueryPublisherCreateCodec.encodeRequest(info.getMapName(), info.getCacheId(), dataPredicate, info.getBatchSize(), info.getBufferSize(), info.getDelaySeconds(), info.isPopulate(), info.isCoalesce());
    }

    private void madePublishable(String mapName, String cacheName) throws Exception {
        ClientMessage request = ContinuousQueryMadePublishableCodec.encodeRequest(mapName, cacheName);
        this.context.getInvokerWrapper().invokeOnAllPartitions(request);
    }

    private static void prepopulate(InternalQueryCache queryCache, ClientMessage clientMessage, boolean includeValue) {
        int responseSize = clientMessage.getInt();
        for (int responseIndex = 0; responseIndex < responseSize && !queryCache.reachedMaxCapacity(); ++responseIndex) {
            Data dataKey = clientMessage.getData();
            Data dataValue = includeValue ? clientMessage.getData() : null;
            queryCache.prepopulate(dataKey, dataValue);
        }
    }
}

