/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.engine;

import com.carrotsearch.hppc.ObjectIntHashMap;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.LongSupplier;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexDeletionPolicy;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.store.Directory;
import org.elasticsearch.index.engine.SafeCommitInfo;
import org.elasticsearch.index.engine.SoftDeletesPolicy;
import org.elasticsearch.index.seqno.SequenceNumbers;
import org.elasticsearch.index.translog.TranslogDeletionPolicy;

public class CombinedDeletionPolicy
extends IndexDeletionPolicy {
    private final Logger logger;
    private final TranslogDeletionPolicy translogDeletionPolicy;
    private final SoftDeletesPolicy softDeletesPolicy;
    private final LongSupplier globalCheckpointSupplier;
    private final ObjectIntHashMap<IndexCommit> snapshottedCommits;
    private volatile IndexCommit safeCommit;
    private volatile IndexCommit lastCommit;
    private volatile SafeCommitInfo safeCommitInfo = SafeCommitInfo.EMPTY;

    CombinedDeletionPolicy(Logger logger, TranslogDeletionPolicy translogDeletionPolicy, SoftDeletesPolicy softDeletesPolicy, LongSupplier globalCheckpointSupplier) {
        this.logger = logger;
        this.translogDeletionPolicy = translogDeletionPolicy;
        this.softDeletesPolicy = softDeletesPolicy;
        this.globalCheckpointSupplier = globalCheckpointSupplier;
        this.snapshottedCommits = new ObjectIntHashMap();
    }

    public void onInit(List<? extends IndexCommit> commits) throws IOException {
        assert (!commits.isEmpty()) : "index is opened, but we have no commits";
        this.onCommit(commits);
        if (this.safeCommit != commits.get(commits.size() - 1)) {
            throw new IllegalStateException("Engine is opened, but the last commit isn't safe. Global checkpoint [" + this.globalCheckpointSupplier.getAsLong() + "], seqNo is last commit [" + SequenceNumbers.loadSeqNoInfoFromLuceneCommit(this.lastCommit.getUserData().entrySet()) + "], seqNos in safe commit [" + SequenceNumbers.loadSeqNoInfoFromLuceneCommit(this.safeCommit.getUserData().entrySet()) + "]");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onCommit(List<? extends IndexCommit> commits) throws IOException {
        IndexCommit safeCommit;
        CombinedDeletionPolicy combinedDeletionPolicy = this;
        synchronized (combinedDeletionPolicy) {
            int keptPosition = CombinedDeletionPolicy.indexOfKeptCommits(commits, this.globalCheckpointSupplier.getAsLong());
            this.safeCommitInfo = SafeCommitInfo.EMPTY;
            this.lastCommit = commits.get(commits.size() - 1);
            this.safeCommit = commits.get(keptPosition);
            for (int i = 0; i < keptPosition; ++i) {
                if (this.snapshottedCommits.containsKey((Object)commits.get(i))) continue;
                this.deleteCommit(commits.get(i));
            }
            this.updateRetentionPolicy();
            safeCommit = this.safeCommit;
        }
        assert (!Thread.holdsLock((Object)this)) : "should not block concurrent acquire or relesase";
        this.safeCommitInfo = new SafeCommitInfo(Long.parseLong((String)safeCommit.getUserData().get("local_checkpoint")), this.getDocCountOfCommit(safeCommit));
        IndexCommit newSafeCommit = this.safeCommit;
        assert (safeCommit == newSafeCommit) : "onCommit called concurrently? " + safeCommit.getGeneration() + " vs " + newSafeCommit.getGeneration();
    }

    private void deleteCommit(IndexCommit commit) throws IOException {
        assert (!commit.isDeleted()) : "Index commit [" + CombinedDeletionPolicy.commitDescription(commit) + "] is deleted twice";
        this.logger.debug("Delete index commit [{}]", (Object)CombinedDeletionPolicy.commitDescription(commit));
        commit.delete();
        assert (commit.isDeleted()) : "Deletion commit [" + CombinedDeletionPolicy.commitDescription(commit) + "] was suppressed";
    }

    private void updateRetentionPolicy() throws IOException {
        assert (Thread.holdsLock((Object)this));
        this.logger.debug("Safe commit [{}], last commit [{}]", (Object)CombinedDeletionPolicy.commitDescription(this.safeCommit), (Object)CombinedDeletionPolicy.commitDescription(this.lastCommit));
        assert (!this.safeCommit.isDeleted()) : "The safe commit must not be deleted";
        long minRequiredGen = Long.parseLong((String)this.safeCommit.getUserData().get("translog_generation"));
        assert (!this.lastCommit.isDeleted()) : "The last commit must not be deleted";
        long lastGen = Long.parseLong((String)this.lastCommit.getUserData().get("translog_generation"));
        assert (minRequiredGen <= lastGen) : "minRequiredGen must not be greater than lastGen";
        this.translogDeletionPolicy.setTranslogGenerationOfLastCommit(lastGen);
        this.translogDeletionPolicy.setMinTranslogGenerationForRecovery(minRequiredGen);
        this.softDeletesPolicy.setLocalCheckpointOfSafeCommit(Long.parseLong((String)this.safeCommit.getUserData().get("local_checkpoint")));
    }

    protected int getDocCountOfCommit(IndexCommit indexCommit) throws IOException {
        return SegmentInfos.readCommit((Directory)indexCommit.getDirectory(), (String)indexCommit.getSegmentsFileName()).totalMaxDoc();
    }

    SafeCommitInfo getSafeCommitInfo() {
        return this.safeCommitInfo;
    }

    synchronized IndexCommit acquireIndexCommit(boolean acquiringSafeCommit) {
        assert (this.safeCommit != null) : "Safe commit is not initialized yet";
        assert (this.lastCommit != null) : "Last commit is not initialized yet";
        IndexCommit snapshotting = acquiringSafeCommit ? this.safeCommit : this.lastCommit;
        this.snapshottedCommits.addTo((Object)snapshotting, 1);
        return new SnapshotIndexCommit(snapshotting);
    }

    synchronized boolean releaseCommit(IndexCommit snapshotCommit) {
        IndexCommit releasingCommit = ((SnapshotIndexCommit)snapshotCommit).delegate;
        assert (this.snapshottedCommits.containsKey((Object)releasingCommit)) : "Release non-snapshotted commit;snapshotted commits [" + this.snapshottedCommits + "], releasing commit [" + releasingCommit + "]";
        int refCount = this.snapshottedCommits.addTo((Object)releasingCommit, -1);
        assert (refCount >= 0) : "Number of snapshots can not be negative [" + refCount + "]";
        if (refCount == 0) {
            this.snapshottedCommits.remove((Object)releasingCommit);
        }
        return refCount == 0 && !releasingCommit.equals((Object)this.safeCommit) && !releasingCommit.equals((Object)this.lastCommit);
    }

    public static IndexCommit findSafeCommitPoint(List<IndexCommit> commits, long globalCheckpoint) throws IOException {
        if (commits.isEmpty()) {
            throw new IllegalArgumentException("Commit list must not empty");
        }
        int keptPosition = CombinedDeletionPolicy.indexOfKeptCommits(commits, globalCheckpoint);
        return commits.get(keptPosition);
    }

    private static int indexOfKeptCommits(List<? extends IndexCommit> commits, long globalCheckpoint) throws IOException {
        String expectedTranslogUUID = (String)commits.get(commits.size() - 1).getUserData().get("translog_uuid");
        for (int i = commits.size() - 1; i >= 0; --i) {
            Map commitUserData = commits.get(i).getUserData();
            if (!expectedTranslogUUID.equals(commitUserData.get("translog_uuid"))) {
                return i + 1;
            }
            long maxSeqNoFromCommit = Long.parseLong((String)commitUserData.get("max_seq_no"));
            if (maxSeqNoFromCommit > globalCheckpoint) continue;
            return i;
        }
        return 0;
    }

    synchronized boolean hasSnapshottedCommits() {
        return !this.snapshottedCommits.isEmpty();
    }

    boolean hasUnreferencedCommits() throws IOException {
        IndexCommit lastCommit = this.lastCommit;
        if (this.safeCommit != lastCommit) {
            long maxSeqNoFromLastCommit = Long.parseLong((String)lastCommit.getUserData().get("max_seq_no"));
            return this.globalCheckpointSupplier.getAsLong() >= maxSeqNoFromLastCommit;
        }
        return false;
    }

    public static String commitDescription(IndexCommit commit) throws IOException {
        return String.format(Locale.ROOT, "CommitPoint{segment[%s], userData[%s]}", commit.getSegmentsFileName(), commit.getUserData());
    }

    private static class SnapshotIndexCommit
    extends IndexCommit {
        private final IndexCommit delegate;

        SnapshotIndexCommit(IndexCommit delegate) {
            this.delegate = delegate;
        }

        public String getSegmentsFileName() {
            return this.delegate.getSegmentsFileName();
        }

        public Collection<String> getFileNames() throws IOException {
            return this.delegate.getFileNames();
        }

        public Directory getDirectory() {
            return this.delegate.getDirectory();
        }

        public void delete() {
            throw new UnsupportedOperationException("A snapshot commit does not support deletion");
        }

        public boolean isDeleted() {
            return this.delegate.isDeleted();
        }

        public int getSegmentCount() {
            return this.delegate.getSegmentCount();
        }

        public long getGeneration() {
            return this.delegate.getGeneration();
        }

        public Map<String, String> getUserData() throws IOException {
            return this.delegate.getUserData();
        }

        public String toString() {
            return "SnapshotIndexCommit{" + this.delegate + "}";
        }
    }
}

